/*    Copyright (C) 1999- XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

	/* This program sorts the index files of small groups. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

#define MAX_LINELEN 10239
#define MAX_FILELEN 1023999
#define MAX_GROUPS 12000

char mainbuf[MAX_FILELEN+1];
FILE *indf;

struct groupstruct {
    int serial,nature,exponent,centsize,absize,conj,sub,subconj,normal,o2;
    char centparm[32];
    char abparm[32];
} group[MAX_GROUPS];

int totgroup;

int multsize(char *p)
{
    int i=1;
    char *p1, *p2, buf[64];

    if(*p==0) return 1;
    strcpy(buf,p);
    for(p1=buf; p1!=NULL; p1=p2) {
	p2=strchr(p1,','); if(p2!=NULL) *p2++=0;
	i*=atoi(p1);
    }
    return i;
}

/*		0  1  2  3  4  5  6  7  8  9 10 11 12 */
int natlist[]={ 5, 2, 3, 6, 7, 4, 9, 9, 9, 9, 9, 0, 1};

	/* Here is the main sorting principle. */
int mysorter(const void *p1, const void *p2)
{
    const struct groupstruct *g1, *g2;
    int i;
    
    g1=p1; g2=p2;
    if(g1->nature!=g2->nature) return natlist[g1->nature]-natlist[g2->nature];
    i=g1->exponent-g2->exponent; if(i) return -i;
    i=g1->centsize-g2->centsize; if(i) return i;
    i=strcmp(g1->centparm,g2->centparm); if(i) return -i;
    i=g1->absize-g2->absize; if(i) return i;
    i=strcmp(g1->abparm,g2->abparm); if(i) return -i;
    i=g1->conj-g2->conj; if(i) return i;
    i=g1->sub-g2->sub; if(i) return i;
    i=g1->subconj-g2->subconj; if(i) return i;
    i=g1->normal-g2->normal; if(i) return i;
    i=g1->o2-g2->o2; if(i) return i;
    return 0;
}

int maketable(void)
{
    int len,i;
    char c, *p1, *p2, *p3;
        
    len=strlen(mainbuf);
    for(i=0;i<len;i++) {
	c=mainbuf[i];
	if(c=='[' || c==']' || c=='\n') mainbuf[i]=' ';
	if(c=='-') mainbuf[i]='0';
    }
    for(totgroup=0,p1=strchr(mainbuf,':');
	p1!=NULL && totgroup<MAX_GROUPS; totgroup++, p1=p2) {
	p1++;p2=strchr(p1,':');
	if(p2!=NULL) *p2=0;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].serial=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].nature=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].exponent=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; strncpy(group[totgroup].centparm,p1,31);
	group[totgroup].centparm[31]=0; p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; strncpy(group[totgroup].abparm,p1,31);
	group[totgroup].abparm[31]=0; p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].conj=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].sub=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].subconj=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3==NULL) return -1;
	*p3=0; group[totgroup].normal=atoi(p1); p1=p3+1;
	p3=strchr(p1,';'); if(p3!=NULL) *p3=0;
	group[totgroup].o2=atoi(p1);
	for(p3=group[totgroup].centparm;*p3;) {
	    if(*p3==' ') strcpy(p3,p3+1); else p3++;
	}
	for(p3=group[totgroup].abparm;*p3;) {
	    if(*p3==' ') strcpy(p3,p3+1); else p3++;
	}
	group[totgroup].centsize=multsize(group[totgroup].centparm);
	group[totgroup].absize=multsize(group[totgroup].abparm);
    }
    return 0;
}

void rewrite(char *fname)
{
    int i;
    indf=fopen(fname,"w"); if(indf==NULL) return;
    for(i=0;i<totgroup;i++) {
	fprintf(indf,":%d;%d;%d;%s;%s;%d;",
		group[i].serial,
		group[i].nature,
		group[i].exponent,
		group[i].centparm,
		group[i].abparm,
		group[i].conj);
	if(group[i].sub>0)
	  fprintf(indf,"%d;%d;%d;",
		  group[i].sub,
		  group[i].subconj,
		  group[i].normal);
	else fprintf(indf,"--;--;--;");
	fprintf(indf,"%d;%d;%d\n",
		group[i].o2,
		group[i].centsize,
		group[i].absize);
    }
    fclose(indf);
}

int main(int argc, char *argv[])
{
    int i;
    long l;
    
    if(argc<=1) return 1; /* no argument found */
    for(i=1;i<argc;i++) {
	indf=fopen(argv[i],"r"); if(indf==NULL) continue;
	fseek(indf,0,SEEK_END); l=ftell(indf);
	if(l<=0 || l>MAX_FILELEN) {fclose(indf);continue;}
	fseek(indf,0,SEEK_SET); fread(mainbuf,1,l,indf); mainbuf[l]=0;
	fclose(indf);
	if(maketable()!=0 || totgroup<=0) continue;
	qsort(group,totgroup,sizeof(group[0]),mysorter);
	rewrite(argv[i]);
    }
    
    return 0;
}

