# -*- coding: utf-8 -*-
#
# Copyright (c) 2017 jmui <jmui@jmui.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#
#
# A simple script to print a random emoji chosen from a list
#
# Usage: /emojis
#
#
#  History:
#  2017-11-17
#      0.1 First version
#
#

SCRIPT_NAME = "emojis"
SCRIPT_AUTHOR = "jmui <jmui@jmui.net>"
SCRIPT_VERSION = "0.1"
SCRIPT_LICENSE = "GPL3"
SCRIPT_DESC = "Send a random emoji to the current buffer"


import_ok = True

try:
    import weechat
except ImportError:
    print("Script must be used in WeeChat.")
    import_ok = False

from random import choice


emojiList = [
    '¢‿¢',
    '©¿© o',
    'ª{•̃̾_•̃̾}ª',
    '¬_¬',
    '¯＼(º_o)/¯',
    '¯\(º o)/¯',
    '¯\_(⊙︿⊙)_/¯',
    '¯\_(ツ)_/¯',
    '°ω°',
    '°Д°',
    '°‿‿°',
    '´ ▽ ` )ﾉ',
    '¿ⓧ_ⓧﮌ',
    'Ò,ó',
    'ó‿ó',
    'ô⌐ô',
    'ôヮô',
    'ŎםŎ',
    'ŏﺡó',
    'ʕ•̫͡•ʔ',
    'ʕ•ᴥ•ʔ',
    'ʘ‿ʘ',
    '˚•_•˚',
    '˚⌇˚',
    '˚▱˚',
    'Σ ◕ ◡ ◕',
    'Σ (ﾟДﾟ;）',
    'Σ(ﾟДﾟ；≡；ﾟдﾟ)',
    'Σ(ﾟДﾟ )',
    'Σ(||ﾟДﾟ)',
    'Φ,Φ',
    'δﺡό',
    'σ_σ',
    'д_д',
    'ф_ф',
    'щ（ﾟДﾟщ）',
    'щ(ಠ益ಠщ)',
    'щ(ಥДಥщ)',
    'Ծ_Ծ',
    '٩๏̯͡๏۶',
    '٩๏̯͡๏)۶',
    '٩◔̯◔۶',
    '٩(×̯×)۶',
    '٩(̾●̮̮̃̾•̃̾)۶',
    '٩(͡๏̯͡๏)۶',
    '٩(͡๏̯ ͡๏)۶',
    '٩(ಥ_ಥ)۶',
    '٩(•̮̮̃•̃)۶',
    '٩(●̮̮̃•̃)۶',
    '٩(●̮̮̃●̃)۶',
    '٩(｡͡•‿•｡)۶',
    '٩(-̮̮̃•̃)۶',
    '٩(-̮̮̃-̃)۶',
    '۞_۞',
    '۞_۟۞',
    '۹ↁﮌↁ',
    '۹⌤_⌤۹',
    '॓_॔',
    '१✌◡✌५',
    '१|˚–˚|५',
    'ਉ_ਉ',
    'ଘ_ଘ',
    'இ_இ',
    'ఠ_ఠ',
    'రృర',
    'ಠ¿ಠi',
    'ಠ‿ಠ',
    'ಠ⌣ಠ',
    'ಠ╭╮ಠ',
    'ಠ▃ಠ',
    'ಠ◡ಠ',
    'ಠ益ಠ',
    'ಠ益ಠ',
    'ಠ︵ಠ凸',
    'ಠ , ಥ',
    'ಠ.ಠ',
    'ಠoಠ',
    'ಠ_ృ',
    'ಠ_ಠ',
    'ಠ_๏',
    'ಠ~ಠ',
    'ಡ_ಡ',
    'ತಎತ',
    'ತ_ತ',
    'ಥдಥ',
    'ಥ‿ಥ',
    'ಥ⌣ಥ',
    'ಥ◡ಥ',
    'ಥ﹏ಥ',
    'ಥ_ಥ',
    'ಭ_ಭ',
    'ರ_ರ',
    'ಸ , ໖',
    'ಸ_ಸ',
    'ക_ക',
    'อ้_อ้',
    'อ_อ',
    'โ๏௰๏ใ ื',
    '๏̯͡๏﴿',
    '๏̯͡๏',
    '๏̯͡๏﴿',
    '๏[-ิิ_•ิ]๏',
    '๏_๏',
    '໖_໖',
    '༺‿༻',
    'ლ(´ڡ`ლ)',
    'ლ(́◉◞౪◟◉‵ლ)',
    'ლ(ಠ益ಠლ)',
    'ლ(╹◡╹ლ)',
    'ლ(◉◞౪◟◉‵ლ)',
    'ლ,ᔑ•ﺪ͟͠•ᔐ.ლ',
    'ᄽὁȍ ̪ őὀᄿ',
    'ᕕ( ᐛ )ᕗ',
    'ᕙ(⇀‸↼‶)ᕗ',
    'ᕦ(ò_óˇ)ᕤ',
    'ᶘ ᵒᴥᵒᶅ',
    '‘︿’',
    '•▱•',
    '•✞_✞•',
    '•(⌚_⌚)•',
    '•_•)',
    '‷̗ↂ凸ↂ‴̖',
    '‹•.•›',
    '‹› ‹(•¿•)› ‹›',
    '‹(ᵒᴥᵒ­­­­­)›',
    '‹(•¿•)›',
    'ↁ_ↁ',
    '⇎_⇎',
    '∩(︶▽︶)∩',
    '∩( ・ω・)∩',
    '≖‿≖',
    '≧ヮ≦',
    '⊂•⊃_⊂•⊃',
    '⊂⌒~⊃｡Д｡)⊃',
    '⊂(◉‿◉)つ',
    '⊂(ﾟДﾟ,,⊂⌒｀つ',
    '⊙ω⊙',
    '⊙▂⊙',
    '⊙▃⊙',
    '⊙△⊙',
    '⊙︿⊙',
    '⊙﹏⊙',
    '⊙０⊙',
    '⊛ठ̯⊛',
    '⋋ō_ō`',
    '━━━ヽ(ヽ(ﾟヽ(ﾟ∀ヽ(ﾟ∀ﾟヽ(ﾟ∀ﾟ)ﾉﾟ∀ﾟ)ﾉ∀ﾟ)ﾉﾟ)ﾉ)ﾉ━━━',
    '┌∩┐(◕_◕)┌∩┐',
    '┌( ಠ_ಠ)┘',
    '┌( ಥ_ಥ)┘',
    '╚(•⌂•)╝',
    '╭╮╭╮☜{•̃̾_•̃̾}☞╭╮╭╮',
    '╭✬⌢✬╮',
    '╮(─▽─)╭',
    '╯‵Д′)╯彡┻━┻',
    '╰☆╮',
    '□_□',
    '►_◄',
    '◃┆◉◡◉┆▷',
    '◉△◉',
    '◉︵◉',
    '◉_◉',
    '○_○',
    '●¿●\ ~',
    '●_●',
    '◔̯◔',
    '◔ᴗ◔',
    '◔ ⌣ ◔',
    '◔_◔',
    '◕ω◕',
    '◕‿◕',
    '◕◡◕',
    '◕ ◡ ◕',
    '◖♪_♪|◗',
    '◖|◔◡◉|◗',
    '◘_◘',
    '◙‿◙',
    '◜㍕◝',
    '◪_◪',
    '◮_◮',
    '☁ ☝ˆ~ˆ☂',
    '☆¸☆',
    '☉‿⊙',
    '☉_☉',
    '☐_☐',
    '☜(⌒▽⌒)☞',
    '☜(ﾟヮﾟ☜)',
    '☜-(ΘLΘ)-☞',
    '☝☞✌',
    '☮▁▂▃▄☾ ♛ ◡ ♛ ☽▄▃▂▁☮',
    '☹_☹',
    '☻_☻',
    '☼.☼',
    '☾˙❀‿❀˙☽',
    '♥‿♥',
    '♥╣[-_-]╠♥',
    '♥╭╮♥',
    '♥◡♥',
    '✌♫♪˙❤‿❤˙♫♪✌',
    '✌.ʕʘ‿ʘʔ.✌',
    '✌.|•͡˘‿•͡˘|.✌',
    '✖‿✖',
    '✖_✖',
    '❐‿❑',
    '⨀_⨀',
    '⨀_Ꙩ',
    '⨂_⨂',
    '〆(・∀・＠)',
    '《〠_〠》',
    '【•】_【•】',
    '〠_〠',
    '〴⋋_⋌〵',
    'の� �の',
    'ニガー? ━━━━━━(ﾟ∀ﾟ)━━━━━━ ニガー?',
    'ヽ(´ｰ｀ )ﾉ',
    'ヽ(๏∀๏ )ﾉ',
    'ヽ(｀Д´)ﾉ',
    'ヽ(ｏ`皿′ｏ)ﾉ',
    'ヽ(`Д´)ﾉ',
    'ㅎ_ㅎ',
    '乂◜◬◝乂',
    '凸ಠ益ಠ)凸',
    '句_句',
    'Ꙩ⌵Ꙩ',
    'Ꙩ_Ꙩ',
    'ꙩ_ꙩ',
    'Ꙫ_Ꙫ',
    'ꙫ_ꙫ',
    'ꙮ_ꙮ',
    '흫_흫',
    '句_句',
    '﴾͡๏̯͡๏﴿',
    '¯\(ºдಠ)/¯',
    '（·×·）',
    '（⌒Д⌒）',
    '（╹ェ╹）',
    '（♯・∀・）⊃',
    '（　´∀｀）☆',
    '（　´∀｀）',
    '（゜Д゜）',
    '（・∀・）',
    '（・Ａ・）',
    '（ﾟ∀ﾟ）',
    '（￣へ￣）',
    '（ ´☣///_ゝ///☣｀）',
    '（ つ Д ｀）',
    '＿☆（ ´_⊃｀）☆＿',
    '｡◕‿‿◕｡',
    '｡◕ ‿ ◕｡',
    '!⑈ˆ~ˆ!⑈',
    '!(｀･ω･｡)',
    '(¬‿¬)',
    '(¬▂¬)',
    '(¬_¬)',
    '(°ℇ °)',
    '(°∀°)',
    '(´ω｀)',
    '(´◉◞౪◟◉)',
    '(´ヘ｀;)',
    '(´・ω・｀)',
    '(´ー｀)',
    '(ʘ‿ʘ)',
    '(ʘ_ʘ)',
    '(˚இ˚)',
    '(͡๏̯͡๏)',
    '(ΘεΘ;)',
    '(ι´Д｀)ﾉ',
    '(Ծ‸ Ծ)',
    '(॓_॔)',
    '(० ्०)',
    '(ு८ு_ .:)',
    '(ಠ‾ಠ)',
    '(ಠ‿ʘ)',
    '(ಠ‿ಠ)',
    '(ಠ⌣ಠ)',
    '(ಠ益ಠ ╬)',
    '(ಠ益ಠ)',
    '(ಠ_ృ)',
    '(ಠ_ಠ)',
    '(ಥ﹏ಥ)',
    '(ಥ_ಥ)',
    '(๏̯͡๏ )',
    '(ღ˘⌣˘ღ) ♫･*:.｡. .｡.:*･',
    '(ღ˘⌣˘ღ)',
    '(ᵔᴥᵔ)',
    '(•ω•)',
    '(•‿•)',
    '(•⊙ω⊙•)',
    '(• ε •)',
    '(∩▂∩)',
    '(∩︵∩)',
    '(∪ ◡ ∪)',
    '(≧ω≦)',
    '(≧◡≦)',
    '(≧ロ≦)',
    '(⊙ヮ⊙)',
    '(⊙_◎)',
    '(⋋▂⋌)',
    '(⌐■_■)',
    '(─‿‿─)',
    '(┛◉Д◉)┛┻━┻',
    '(╥_╥)',
    '(╬ಠ益ಠ)',
    '(╬◣д◢)',
    '(╬ ಠ益ಠ)',
    '(╯°□°）╯︵ ┻━┻',
    '(╯ಊ╰)',
    '(╯◕_◕)╯',
    '(╯︵╰,)',
    '(╯3╰)',
    '(╯_╰)',
    '(╹◡╹)凸',
    '(▰˘◡˘▰)',
    '(●´ω｀●)',
    '(●´∀｀●)',
    '(◑‿◐)',
    '(◑◡◑)',
    '(◕‿◕✿)',
    '(◕‿◕)',
    '(◕‿-)',
    '(◕︵◕)',
    '(◕ ^ ◕)',
    '(◕_◕)',
    '(◜௰◝)',
    '(◡‿◡✿)',
    '(◣_◢)',
    '(☞ﾟ∀ﾟ)☞',
    '(☞ﾟヮﾟ)☞',
    '(☞ﾟ ∀ﾟ )☞',
    '(☼◡☼)',
    '(☼_☼)',
    '(✌ﾟ∀ﾟ)☞',
    '(✖╭╮✖)',
    '(✪㉨✪)',
    '(✿◠‿◠)',
    '(✿ ♥‿♥)',
    '(　・∀・)',
    '(　･ัω･ั)？',
    '(　ﾟ∀ﾟ)o彡゜',
    '(。・_・。)',
    '(つд｀)',
    '(づ｡◕‿‿◕｡)づ',
    '(ノಠ益ಠ)ノ彡┻━┻',
    '(ノ ◑‿◑)ノ',
    '(ノ_・。)',
    '(・∀・ )',
    '(屮ﾟДﾟ)屮',
    '(︶ω︶)',
    '(︶︹︺)',
    '(；一_一)',
    '(｀・ω・´)”',
    '(｡◕‿‿◕｡)',
    '(｡◕‿◕｡)',
    '(｡◕ ‿ ◕｡)',
    '(｡♥‿♥｡)',
    '(｡･ω..･)っ',
    '(･ｪ-)',
    '(ﾉ◕ヮ◕)ﾉ*:･ﾟ✧',
    '(ﾟДﾟ)',
    '(ﾟДﾟ)y─┛~~',
    '(ﾟ∀ﾟ)',
    '(ﾟヮﾟ)',
    '(￣□￣)',
    '(￣。￣)',
    '(￣ー￣)',
    '(￣(エ)￣)',
    '( °٢° )',
    '( ´_ゝ｀)',
    '( ͡° ͜ʖ ͡°)',
    '( ͡~ ͜ʖ ͡°)',
    '( ಠ◡ಠ )',
    '( •_•)>⌐■-■',
    '( 　ﾟ,_ゝﾟ)',
    '( ･ิз･ิ)',
    '( ﾟдﾟ)､',
    '( ^▽^)σ)~O~)',
    '((((゜д゜;))))',
    '(*´д｀*)',
    '(*..Д｀)',
    '(*..д｀*)',
    '(*~▽~)',
    '(-’๏_๏’-)',
    '(-＿- )ノ',
    '(/◔ ◡ ◔)/',
    '(///_ಥ)',
    '(;´Д`)',
    '(=ω=;)',
    '(=゜ω゜)',
    '(>\'o\')> ♥ <(\'o\'<)',
    '(n˘v˘•)¬',
    '(o´ω｀o)',
    '(V)(°,,°)(V)',
    '(\/) (°,,°) (\/)',
    '(^▽^)',
    '(`･ω･´)',
    '(~￣▽￣)~',
    '\= (ﾟдﾟ)ｳ',
    '@_@',
    'd(*⌒▽⌒*)b',
    'o(≧∀≦)o',
    'o(≧o≦)o',
    'q(❂‿❂)p',
    'y=ｰ( ﾟдﾟ)･∵.',
    '\˚ㄥ˚\ ',
    '\ᇂ_ᇂ\ ',
    '\(ಠ ὡ ಠ )/',
    '\(◕ ◡ ◕\)',
    '^̮^',
    '^ㅂ^',
    '_(͡๏̯͡๏)_',
    '{´◕ ◡ ◕｀}',
    '\{ಠ_ಠ\}__,,|,',
    '{◕ ◡ ◕}',
]


def print_face(data, buf, args):
    weechat.command(buf, choice(emojiList))
    return weechat.WEECHAT_RC_OK


if __name__ == "__main__" and import_ok:
    if weechat.register(SCRIPT_NAME, SCRIPT_AUTHOR, SCRIPT_VERSION,
                        SCRIPT_LICENSE, SCRIPT_DESC, "", ""):
        weechat.hook_command(SCRIPT_NAME, SCRIPT_DESC, "", "", "",
                             "print_face", "")
