// @HEADER
//
// ***********************************************************************
//
//        MueLu: A package for multigrid based preconditioning
//                  Copyright 2012 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact
//                    Jonathan Hu       (jhu@sandia.gov)
//                    Andrey Prokopenko (aprokop@sandia.gov)
//                    Ray Tuminaro      (rstumin@sandia.gov)
//
// ***********************************************************************
//
// @HEADER
// @HEADER
// @HEADER

#ifndef MUELU_DOXYGEN_DOCUMENTATION_HPP
#define MUELU_DOXYGEN_DOCUMENTATION_HPP

/*!

\mainpage

@image html muelu.png

\section muelu_index Table of Contents

- \ref muelu_overview
- \ref muelu_documentation
- \ref muelu_authors
- \ref muelu_copyright
- \ref muelu_questions

\section muelu_overview MueLu Overview

MueLu is a flexible and extensible multigrid solver framework.  It is intended for the research and
development of new multigrid preconditioning techniques.
More information can be found at https://trilinos.org/packages/muelu.

\section muelu_documentation Documentation

Useful views of the Doxygen documentation are:
  - Browsing the entire class documentation. Choose the <a href="classes.html">Class Index subtab</a>.
  - Browsing the class documentation organized by logical groups.  Choose the <a href="modules.html">Modules tab</a>.

The MueLu User's Guide is located in muelu/doc/UsersGuide and at the
<a href=https://trilinos.org/packages/muelu/muelu-documentation>MueLu home page</a>.


\section muelu_authors Authors and Contributors

  - Tom Benson, LLNL
  - Emily Furst, University of Washington (summer intern, 2015)
  - Jeremie Gaidamour, INRIA (Nancy, France)
  - Axel Gerstenberger, Rolls Royce
  - Jonathan Hu, Sandia National Labs
  - Brian Kelley, Texas A&M (summer intern, 2015)
  - Matthias Mayr, Sandia National Labs
  - Andrey Prokopenko, Sandia National Labs
  - Chris Siefert, Sandia National Labs
  - Paul Tsuji, LLNL
  - Ray Tuminaro, Sandia National Labs
  - Tobias Wiesner, Sandia National Labs

\section muelu_copyright Copyright and License

\verbinclude COPYRIGHT_AND_LICENSE

\section muelu_questions For All Questions and Comments...

   Please contact the authors listed in the License above, or use one of the
   <a href=https://trilinos.org/packages/muelu/muelu-contact-us>MueLu mailing lists</a>.

*/

/* ************************************************************************ */
/* ************************************************************************ */

#endif //ifndef MUELU_DOXYGEN_DOCUMENTATION_HPP
