//! test the paths_to_atoms function

use super::*;

fn build_expr(input: &str) -> BeTree<char, char> {
    let mut expr = BeTree::new();
    for c in input.chars() {
        match c {
            '&' | '|' | '!' => expr.push_operator(c),
            ' ' => {}
            '(' => expr.open_par(),
            ')' => expr.close_par(),
            _ => expr.push_atom(c),
        }
    }
    expr
}

#[test]
fn test_paths() {
    let expr = build_expr("A & (B | C)");
    assert_eq!(
        expr.paths_to_atoms(),
        vec![
            (vec!['&'], 'A'),
            (vec!['&', '|'], 'B'),
            (vec!['&', '|'], 'C'),
        ]
    );

    let expr = build_expr("!A & !(B | C)");
    assert_eq!(
        expr.paths_to_atoms(),
        vec![
            (vec!['&', '!'], 'A'),
            (vec!['&', '!', '|'], 'B'),
            (vec!['&', '!', '|'], 'C'),
        ]
    );

    let expr = build_expr("!A & !(B | C) & D");
    assert_eq!(
        expr.paths_to_atoms(),
        vec![
            (vec!['&', '!'], 'A'),
            (vec!['&', '&', '!', '|'], 'B'),
            (vec!['&', '&', '!', '|'], 'C'),
            (vec!['&', '&'], 'D'),
        ]
    );

}
