% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csrf.R
\name{csrf}
\alias{csrf}
\title{Case-specific random forests.}
\usage{
csrf(
  formula,
  training_data,
  test_data,
  params1 = list(),
  params2 = list(),
  verbose = FALSE
)
}
\arguments{
\item{formula}{Object of class \code{formula} or \code{character} describing the model to fit.}

\item{training_data}{Training data of class \code{data.frame}.}

\item{test_data}{Test data of class \code{data.frame}.}

\item{params1}{Parameters for the proximity random forest grown in the first step.}

\item{params2}{Parameters for the prediction random forests grown in the second step.}

\item{verbose}{Logical indicating whether or not to print computation progress.}
}
\value{
Predictions for the test dataset.
}
\description{
In case-specific random forests (CSRF), random forests are built specific to the cases of interest. 
Instead of using equal probabilities, the cases are weighted according to their difference to the case of interest.
}
\details{
The algorithm consists of 3 steps: 
\enumerate{
  \item Grow a random forest on the training data
  \item For each observation of interest (test data), the weights of all training observations are computed by counting the number of trees in which both observations are in the same terminal node.
  \item For each test observation, grow a weighted random forest on the training data, using the weights obtained in step 2. Predict the outcome of the test observation as usual.
}
 In total, n+1 random forests are grown, where n is the number observations in the test dataset.
 For details, see Xu et al. (2014).
}
\examples{
## Split in training and test data
train.idx <- sample(nrow(iris), 2/3 * nrow(iris))
iris.train <- iris[train.idx, ]
iris.test <- iris[-train.idx, ]

## Run case-specific RF
csrf(Species ~ ., training_data = iris.train, test_data = iris.test, 
     params1 = list(num.trees = 50, mtry = 4), 
     params2 = list(num.trees = 5))

}
\references{
Xu, R., Nettleton, D. & Nordman, D.J. (2014). Case-specific random forests. J Comp Graph Stat 25:49-65. \doi{10.1080/10618600.2014.983641}.
}
\author{
Marvin N. Wright
}
