% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcut.R
\name{hcut}
\alias{hcut}
\title{Computes Hierarchical Clustering and Cut the Tree}
\usage{
hcut(
  x,
  k = 2,
  isdiss = inherits(x, "dist"),
  hc_func = c("hclust", "agnes", "diana"),
  hc_method = "ward.D2",
  hc_metric = "euclidean",
  stand = FALSE,
  graph = FALSE,
  ...
)
}
\arguments{
\item{x}{a numeric matrix, numeric data frame or a dissimilarity matrix.}

\item{k}{the number of clusters to be generated.}

\item{isdiss}{logical value specifying wether x is a dissimilarity matrix.}

\item{hc_func}{the hierarchical clustering function to be used. Default value is "hclust". Possible values 
is one of "hclust", "agnes", "diana". Abbreviation is allowed.}

\item{hc_method}{the agglomeration method to be used (?hclust) for hclust() and agnes(): 
"ward.D", "ward.D2", "single", "complete", "average", ...}

\item{hc_metric}{character string specifying the metric to be used for calculating 
dissimilarities between observations. Allowed values are those accepted by the function dist() [including "euclidean", "manhattan", "maximum",
 "canberra", "binary", "minkowski"] and correlation based distance measures ["pearson", "spearman" or "kendall"].}

\item{stand}{logical value; default is FALSE. If TRUE, then the data will be standardized using the function scale(). 
Measurements are standardized for each variable (column), by subtracting the variable's mean value and 
dividing by the variable's standard deviation.}

\item{graph}{logical value. If TRUE, the dendrogram is displayed.}

\item{...}{not used.}
}
\value{
an object of class "hcut" containing the result 
of the standard function used (read the documentation of hclust, agnes, diana). 
      
It includes also:
\itemize{
\item cluster: the cluster assignement of observations after cutting the tree
\item nbclust: the number of clusters
\item silinfo: the silhouette information of observations (if k > 1)
\item size: the size of clusters
\item data: a matrix containing the original or  the standardized data (if stand = TRUE)
}
}
\description{
Computes hierarchical clustering (hclust, agnes, diana) and cut the tree into k clusters. It also accepts 
correlation based distance measure methods such as "pearson", "spearman" and "kendall".
}
\examples{
\donttest{
data(USArrests)

# Compute hierarchical clustering and cut into 4 clusters
res <- hcut(USArrests, k = 4, stand = TRUE)

# Cluster assignements of observations
res$cluster
# Size of clusters
res$size

# Visualize the dendrogram
fviz_dend(res, rect = TRUE)

# Visualize the silhouette
fviz_silhouette(res)

# Visualize clusters as scatter plots
fviz_cluster(res)
}

}
\seealso{
\code{\link{fviz_dend}}, \code{\link{hkmeans}}, \code{\link{eclust}}
}
