/* AS path related definitions. */

/* AS path segment type.  */
#define AS_SET                       1
#define AS_SEQUENCE                  2
#define AS_CONFED_SEQUENCE           3
#define AS_CONFED_SET                4

/* Private AS range defined in RFC2270.  */
#define BGP_PRIVATE_AS_MIN       64512
#define BGP_PRIVATE_AS_MAX       65535

/* AS path may be include some AsSegments.  */
struct aspath 
{
  /* Reference count to this aspath.  */
  unsigned long refcnt;

  /* Rawdata length.  */
  int length;

  /* AS count.  */
  int count;

  /* Rawdata.  */
  caddr_t data;

  /* String expression of AS path.  This string is used by vty output
     and AS path regular expression match.  */
  char *str;
};

#define ASPATH_STR_DEFAULT_LEN 32
