# with_pkg.m4 - Macros to ease the usage of pkg-config.    -*- Autoconf -*-
# 
# Copyright © 2008 Luca Barbato <lu_zero@gentoo.org>,
#                  Diego Pettenò <flameeyes@gentoo.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.

# PKG_WITH_MODULES(VARIABLE-PREFIX, MODULES,
#                  [ACTION-IF-FOUND],[ACTION-IF-NOT-FOUND],
#                  [DESCRIPTION], [DEFAULT])
#
# Prepare a --with-variable-prefix triggered check for module,
# disable by default.
#

AC_DEFUN([PKG_WITH_MODULES],
[

m4_pushdef([with_arg], m4_tolower([$1]))

dnl Default description
m4_pushdef([description],
           [m4_default([$5], [build with ]with_arg[ support])])
dnl Disabled by default
m4_pushdef([def_arg], [m4_default([$6], [no])])

AC_ARG_WITH(with_arg,
    [AS_HELP_STRING(
        [--with-]with_arg, description[ @<:@default=]def_arg[@:>@])],,
    [AS_TR_SH([with_]with_arg)=def_arg])

AS_IF([test "$AS_TR_SH([with_]with_arg)" != "no"],
    [PKG_CHECK_MODULES([$1],[$2],[$3],[$4])])

m4_popdef([with_arg])
m4_popdef([description])
m4_popdef([def_arg])

]) dnl PKG_WITH_MODULES

# PKG_HAVE_WITH_MODULES(VARIABLE-PREFIX, MODULES,
#                       [DESCRIPTION], [DEFAULT])
#

AC_DEFUN([PKG_HAVE_WITH_MODULES],
[

PKG_WITH_MODULES([$1],[$2],,,[$3],[$4])

AM_CONDITIONAL([HAVE_][$1],
               [test "$AS_TR_SH([with_]m4_tolower([$1]))" = "yes"])
])

