module Main (main) where

-- TODO: bench bzlib?
import qualified Codec.Compression.BZip as BZ2
import           Criterion.Main
import qualified Data.ByteString.Lazy   as BSL
import           System.FilePath        ((</>))
import           System.IO.Temp         (withSystemTempDirectory)

decompressDump :: IO ()
decompressDump = withSystemTempDirectory "bz2" $
    \fp -> BSL.writeFile (fp </> "valgrind-3.15.0.tar") =<<
        (BZ2.decompress <$> BSL.readFile "valgrind-3.15.0.tar.bz2")

decompressFile :: FilePath -> IO BSL.ByteString
decompressFile = fmap BZ2.decompress . BSL.readFile

compressFile :: FilePath -> IO BSL.ByteString
compressFile = fmap BZ2.compress . BSL.readFile

main :: IO ()
main =
    defaultMain [ bgroup "decompressDump"
                      [ bench "decompress + write to file" $ nfIO decompressDump ]
                , bgroup "decompress"
                      [ bench "decompress file" $ nfIO (decompressFile "test/data/sample1.bz2")
                      , bench "decompress file" $ nfIO (decompressFile "test/data/sample2.bz2")
                      , bench "decompress file" $ nfIO (decompressFile "test/data/sample3.bz2")
                      ]
                , bgroup "compress"
                      [ bench "compress file" $ nfIO (compressFile "test/data/sample1.ref")
                      , bench "compress file" $ nfIO (compressFile "test/data/sample2.ref")
                      , bench "compress file" $ nfIO (compressFile "test/data/sample3.ref")
                      ]
                ]
