Feature: W0718

  W0718 detects that operand of right side of bitwise expression or arithmetic
  expression is `effectively boolean'.

  Scenario: an arithmetic expression
    Given a target source named "fixture.c" with:
      """
      static int func(int a, int b, int c)
      {
          return a + (b > c); /* W0718 */
      }
      """
    When I successfully run `adlint fixture.c` on noarch
    Then the output should exactly match with:
      | mesg  | line | column |
      | W1076 | 1    | 12     |
      | W0723 | 3    | 14     |
      | W0104 | 1    | 21     |
      | W0104 | 1    | 28     |
      | W0104 | 1    | 35     |
      | W0629 | 1    | 12     |
      | W0718 | 3    | 16     |
      | W0628 | 1    | 12     |

  Scenario: a bitwise expression
    Given a target source named "fixture.c" with:
      """
      static int func(int a, int b, int c)
      {
          return a ^ (b > c); /* W0718 */
      }
      """
    When I successfully run `adlint fixture.c` on noarch
    Then the output should exactly match with:
      | mesg  | line | column |
      | W1076 | 1    | 12     |
      | W0572 | 3    | 14     |
      | W0104 | 1    | 21     |
      | W0104 | 1    | 28     |
      | W0104 | 1    | 35     |
      | W0629 | 1    | 12     |
      | W0718 | 3    | 16     |
      | W0628 | 1    | 12     |

  Scenario: a shift expression
    Given a target source named "fixture.c" with:
      """
      static int func(int a, int b, int c)
      {
          return a << (b > c); /* W0718 */
      }
      """
    When I successfully run `adlint fixture.c` on noarch
    Then the output should exactly match with:
      | mesg  | line | column |
      | W1076 | 1    | 12     |
      | W0570 | 3    | 14     |
      | C1000 |      |        |
      | C1006 | 1    | 21     |
      | W0572 | 3    | 14     |
      | W0794 | 3    | 14     |
      | W0104 | 1    | 21     |
      | W0104 | 1    | 28     |
      | W0104 | 1    | 35     |
      | W0629 | 1    | 12     |
      | W0718 | 3    | 17     |
      | W0628 | 1    | 12     |
