#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Bird Story
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240905.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='a-bird-story'
GAME_NAME='A Bird Story'

ARCHIVE_BASE_1_NAME='gog_a_bird_story_2.0.0.3.sh'
ARCHIVE_BASE_1_MD5='6f334da4493e8c050a16d4b66987d3ff'
ARCHIVE_BASE_1_SIZE='180000'
ARCHIVE_BASE_1_VERSION='1.0-gog2.0.0.3'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/a_bird_story'

ARCHIVE_BASE_0_NAME='gog_a_bird_story_2.0.0.2.sh'
ARCHIVE_BASE_0_MD5='8f93d19265394a5fba61aeec23cabb8e'
ARCHIVE_BASE_0_SIZE='180000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.2'

CONTENT_PATH_DEFAULT='data/noarch/game'
## TODO: Check if some shipped libraries could be dropped
CONTENT_LIBS_FILES='
libfreetype.so.6
libjpeg.so.62
libogg.so.0
libopenal.so.1
libphysfs.so.1
libpixman-1.so.0
libpng16.so.16
libruby.so.2.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_ttf-2.0.so.0
libSDL_sound-1.0.so.1
libsigc-2.0.so.0
libvorbisfile.so.3
libvorbis.so.0
libz.so.1'
CONTENT_LIBS_BIN64_PATH='data/noarch/game/lib64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_FILES"
CONTENT_LIBS_BIN32_PATH='data/noarch/game/lib'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_FILES"
CONTENT_GAME_BIN64_FILES='
ABirdStory.amd64'
CONTENT_GAME_BIN32_FILES='
ABirdStory.x86'
CONTENT_GAME_DATA_FILES='
preload
croptextures
mkxp.conf
Audio.dat
Game.ini
icon.png
Game.rgssad'
CONTENT_DOC_DATA_FILES='
legal
LICENSE.txt'

APP_MAIN_EXE_BIN64='ABirdStory.amd64'
APP_MAIN_EXE_BIN32='ABirdStory.x86'
APP_MAIN_ICON='icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libcrypt.so.1
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
