/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class InfoWindow
extends JFrame {
    protected App _app;
    private JhoveBase _base;
    private JMenuItem _saveItem;
    private JMenuItem _closeItem;
    private JComboBox _handlerBox;
    private JComboBox _encodingBox;
    private static String _lastEncoding;
    private static String _lastHandler;
    protected static final String eol;
    private static final String[] encodings;
    protected SimpleDateFormat _dateFmt;

    public InfoWindow(String string, App app, JhoveBase jhoveBase) throws HeadlessException {
        super(string);
        if (string.length() > 32) {
            this.setTitle(string.substring(0, 29) + "...");
        }
        this._app = app;
        this._base = jhoveBase;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this._saveItem = new JMenuItem("Save as...");
        jMenu.add(this._saveItem);
        this._closeItem = new JMenuItem("Close");
        jMenu.add(this._closeItem);
        this._closeItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoWindow.this.closeFromMenu();
            }
        });
        this.setDefaultCloseOperation(1);
        this.setJMenuBar(jMenuBar);
        this._dateFmt = new SimpleDateFormat("yyyy-MM-dd");
    }

    protected void setSaveActionListener(ActionListener actionListener) {
        this._saveItem.addActionListener(actionListener);
    }

    protected PrintWriter doSaveDialog() {
        Object object;
        int n;
        Object object22;
        JFileChooser jFileChooser = new JFileChooser();
        JhoveWindow.makeChooserOpaque(jFileChooser);
        File file = this._base.getSaveDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(180, 120));
        Vector<String> vector = new Vector<String>(10);
        List list = this._base.getHandlerList();
        for (Object object22 : list) {
            vector.add(object22.getName());
        }
        this._handlerBox = new JComboBox(vector);
        this._handlerBox.setSize(120, 20);
        jPanel.add(new JLabel("Choose output handler"));
        if (_lastHandler != null) {
            this._handlerBox.setSelectedItem(_lastHandler);
        }
        jPanel.add(this._handlerBox);
        object22 = new Vector(5);
        String string = this._base.getEncoding();
        if (string != null) {
            ((Vector)object22).add(string);
        }
        for (n = 0; n < encodings.length; ++n) {
            object = encodings[n];
            if (((String)object).equals(string)) continue;
            ((Vector)object22).add(object);
        }
        this._encodingBox = new JComboBox(object22);
        if (_lastEncoding != null) {
            this._encodingBox.setSelectedItem(_lastEncoding);
        }
        this._encodingBox.setSize(120, 20);
        this._encodingBox.setEditable(true);
        jPanel.add(new JLabel("Select encoding"));
        jPanel.add(this._encodingBox);
        jFileChooser.setAccessory(jPanel);
        jFileChooser.setDialogTitle("Save information to file");
        n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            object = null;
            File file2 = null;
            try {
                this._base.setSaveDirectory(jFileChooser.getCurrentDirectory());
                file2 = jFileChooser.getSelectedFile();
                if (file2.exists()) {
                    int n2 = JOptionPane.showConfirmDialog(this, "That file already exists. Replace?", "Replace", 2);
                    if (n2 != 0) {
                        return null;
                    }
                    if (!file2.delete()) {
                        JOptionPane.showMessageDialog(this, "Could not delete file", "File not deleted", 0);
                        return null;
                    }
                }
                file2.createNewFile();
                String string2 = (String)this._encodingBox.getSelectedItem();
                object = new FileOutputStream(file2);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, string2);
                return new PrintWriter(outputStreamWriter);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JOptionPane.showMessageDialog(this, "Unknown encoding ", "File not saved", 0);
                try {
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                    file2.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), "File not saved", 0);
                try {
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                    file2.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    protected OutputHandler selectHandler() {
        int n = this._handlerBox.getSelectedIndex();
        _lastHandler = (String)this._handlerBox.getSelectedItem();
        OutputHandler outputHandler = (OutputHandler)this._base.getHandlerMap().get(_lastHandler.toLowerCase());
        _lastEncoding = (String)this._encodingBox.getSelectedItem();
        outputHandler.setEncoding(_lastEncoding);
        outputHandler.setApp(this._app);
        outputHandler.setBase(this._base);
        return outputHandler;
    }

    protected void closeFromMenu() {
        this.hide();
    }

    static {
        eol = System.getProperty("line.separator");
        encodings = new String[]{"UTF-8", "ISO-8859-1", "Cp1252", "MacRoman"};
    }
}

