/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RepInfo
implements Cloneable {
    private List _checksum;
    private boolean _consistent;
    private int _valid;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNDETERMINED = -1;
    private Date _created;
    private RepInfo _external;
    private String _format;
    private Date _lastModified;
    private List _message;
    private String _mimeType;
    private Module _module;
    private List _profile;
    private List _sigMatch;
    private Map _property;
    private long _size;
    private String _uri;
    private boolean _urlFlag;
    private int _wellFormed;
    private String _version;
    private String _note;

    public RepInfo(String string) {
        this.init(string);
    }

    public RepInfo(String string, RepInfo repInfo) {
        this.init(string);
        this._external = repInfo;
    }

    private void init(String string) {
        this._uri = string;
        this._size = -1L;
        this._wellFormed = 1;
        this._consistent = true;
        this._urlFlag = false;
        this._valid = 1;
        this._checksum = new ArrayList();
        this._message = new ArrayList();
        this._profile = new ArrayList();
        this._property = new TreeMap();
        this._sigMatch = new ArrayList();
    }

    public Object clone() {
        RepInfo repInfo;
        try {
            repInfo = (RepInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        repInfo._checksum = new ArrayList(this._checksum);
        repInfo._message = new ArrayList(this._message);
        repInfo._profile = new ArrayList(this._profile);
        repInfo._sigMatch = new ArrayList(this._sigMatch);
        repInfo._property = new TreeMap(this._property);
        return repInfo;
    }

    public void copy(RepInfo repInfo) {
        this._checksum = repInfo._checksum;
        this._consistent = repInfo._consistent;
        this._created = repInfo._created;
        this._external = repInfo._external;
        this._format = repInfo._format;
        this._lastModified = repInfo._lastModified;
        this._message = repInfo._message;
        this._mimeType = repInfo._mimeType;
        this._profile = repInfo._profile;
        this._property = repInfo._property;
        this._size = repInfo._size;
        this._uri = repInfo._uri;
        this._urlFlag = repInfo._urlFlag;
        this._wellFormed = repInfo._wellFormed;
        this._valid = repInfo._valid;
        this._version = repInfo._version;
        this._note = repInfo._note;
        this._module = repInfo._module;
        this._sigMatch = repInfo._sigMatch;
    }

    public List getChecksum() {
        return this._checksum;
    }

    public Date getCreated() {
        return this._created;
    }

    public String getFormat() {
        return this._format;
    }

    public Date getLastModified() {
        return this._lastModified;
    }

    public List getMessage() {
        return this._message;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public Module getModule() {
        return this._module;
    }

    public List getProfile() {
        return this._profile;
    }

    public Map getProperty() {
        return this._property;
    }

    public Property getProperty(String string) {
        Property property = null;
        if (this._property.size() > 0) {
            property = (Property)this._property.get(string);
        }
        return property;
    }

    public long getSize() {
        return this._size;
    }

    public String getUri() {
        return this._uri;
    }

    public boolean getURLFlag() {
        return this._urlFlag;
    }

    public boolean isConsistent() {
        return this._consistent;
    }

    public int getWellFormed() {
        return this._wellFormed;
    }

    public int getValid() {
        return this._valid;
    }

    public String getVersion() {
        return this._version;
    }

    public String getNote() {
        return this._note;
    }

    public List getSigMatch() {
        return this._sigMatch;
    }

    public Property getByName(String string) {
        Property property2 = null;
        Collection collection = this._property.values();
        for (Property property2 : collection) {
            if ((property2 = property2.getByName(string)) == null) continue;
            break;
        }
        return property2;
    }

    public void setChecksum(Checksum checksum) {
        this._checksum.add(checksum);
    }

    public void setConsistent(boolean bl) {
        this._consistent = bl;
    }

    public void setCreated(Date date) {
        this._created = date;
    }

    public void setFormat(String string) {
        this._format = string;
    }

    public void setLastModified(Date date) {
        this._lastModified = date;
    }

    public void setMessage(Message message) {
        this._message.add(message);
    }

    public void setMimeType(String string) {
        this._mimeType = string;
    }

    public void setModule(Module module) {
        this._module = module;
    }

    public void setProfile(String string) {
        this._profile.add(string);
    }

    public void setProperty(Property property) {
        this._property.put(property.getName(), property);
    }

    public void setSize(long l) {
        this._size = l;
    }

    public void setURLFlag(boolean bl) {
        this._urlFlag = bl;
    }

    public void setWellFormed(boolean bl) {
        int n = this._wellFormed = bl ? 1 : 0;
        if (!bl) {
            this._consistent = false;
            this._valid = 0;
        }
    }

    public void setWellFormed(int n) {
        this._wellFormed = n;
        if (n == 0) {
            this._consistent = false;
            this._valid = 0;
        }
        if (n == -1) {
            this._valid = -1;
        }
    }

    public void setValid(boolean bl) {
        this._valid = bl ? 1 : 0;
    }

    public void setValid(int n) {
        this._valid = n;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public void setNote(String string) {
        this._note = string;
    }

    public void setSigMatch(String string) {
        this._sigMatch.add(string);
    }

    public void setSigMatch(List list) {
        this._sigMatch = list;
    }

    public void show(OutputHandler outputHandler) {
        outputHandler.analyze(this);
        outputHandler.show(this);
    }
}

