package org.codehaus.plexus.context;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.StringReader;
import java.io.StringWriter;

import junit.framework.TestCase;

import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

/**
 * Generated by JUnitDoclet, a tool provided by ObjectFab GmbH under LGPL. Please see www.junitdoclet.org, www.gnu.org
 * and www.objectfab.de for informations about the tool, the licence and the authors.
 */
public class ContextMapAdapterTest
    extends TestCase
{
    public ContextMapAdapterTest( final String name )
    {
        super( name );
    }

    public void testInterpolation()
        throws Exception
    {
        final DefaultContext context = new DefaultContext();

        context.put( "name", "jason" );

        context.put( "occupation", "exotic dancer" );

        final ContextMapAdapter adapter = new ContextMapAdapter( context );

        assertEquals( "jason", (String) adapter.get( "name" ) );

        assertEquals( "exotic dancer", (String) adapter.get( "occupation" ) );

        assertNull( adapter.get( "foo" ) );
    }

    public void testInterpolationWithContext()
        throws Exception
    {
        final DefaultContext context = new DefaultContext();
        context.put( "name", "jason" );
        context.put( "noun", "asshole" );

        final String foo = "${name} is an ${noun}. ${not.interpolated}";

        final InterpolationFilterReader reader =
            new InterpolationFilterReader( new StringReader( foo ), new ContextMapAdapter( context ) );

        final StringWriter writer = new StringWriter();
        IOUtil.copy( reader, writer );

        final String bar = writer.toString();
        assertEquals( "jason is an asshole. ${not.interpolated}", bar );
    }
}
