/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2016 Klaus Spanderen

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <https://www.quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/


#include <ql/errors.hpp>
#include <ql/experimental/math/gaussiannoncentralchisquaredpolynomial.hpp>
#include <ql/functional.hpp>

#include <boost/preprocessor/iteration/local.hpp>
#include <boost/math/distributions/non_central_chi_squared.hpp>


namespace QuantLib {

    namespace {

        #define NM 28

        #define moment_(n, x) Real f_##n(Real _nu, Real _lambda) \
          {                                                          \
             const Real lambda(_lambda);                             \
             const Real nu(_nu);                                     \
                                                                     \
             return x;                                               \
          }

        moment_(0, 1.0 + 0.0*(lambda + nu));
        moment_(1, lambda + nu);
        moment_(2, std::pow(lambda,2) + 2.*lambda*(2. + nu) + nu*(2. + nu));
        moment_(3, std::pow(lambda,3) + 3.*std::pow(lambda,2)*(4. + nu) + 3.*lambda*(8. + 6.*nu + std::pow(nu,2)) + nu*(8. + 6.*nu + std::pow(nu,2)));
        moment_(4, std::pow(lambda,4) + 4.*std::pow(lambda,3)*(6. + nu) + 6.*std::pow(lambda,2)*(24. + 10.*nu + std::pow(nu,2)) + 4.*lambda*(48. + 44.*nu + 12.*std::pow(nu,2) + std::pow(nu,3)) + nu*(48. + 44.*nu + 12.*std::pow(nu,2) + std::pow(nu,3)));
        moment_(5, std::pow(lambda,5) + 5.*std::pow(lambda,4)*(8. + nu) + 10.*std::pow(lambda,3)*(48. + 14.*nu + std::pow(nu,2)) + 10.*std::pow(lambda,2)*(192. + 104.*nu + 18.*std::pow(nu,2) + std::pow(nu,3)) + 5.*lambda*(384. + 400.*nu + 140.*std::pow(nu,2) + 20.*std::pow(nu,3) + std::pow(nu,4)) + nu*(384. + 400.*nu + 140.*std::pow(nu,2) + 20.*std::pow(nu,3) + std::pow(nu,4)));
        moment_(6, std::pow(lambda,6) + 6.*std::pow(lambda,5)*(10. + nu) + 15.*std::pow(lambda,4)*(80. + 18.*nu + std::pow(nu,2)) + 20.*std::pow(lambda,3)*(480. + 188.*nu + 24.*std::pow(nu,2) + std::pow(nu,3)) + 15.*std::pow(lambda,2)*(1920. + 1232.*nu + 284.*std::pow(nu,2) + 28.*std::pow(nu,3) + std::pow(nu,4)) + 6.*lambda*(3840. + 4384.*nu + 1800.*std::pow(nu,2) + 340.*std::pow(nu,3) + 30.*std::pow(nu,4) + std::pow(nu,5)) + nu*(3840. + 4384.*nu + 1800.*std::pow(nu,2) + 340.*std::pow(nu,3) + 30.*std::pow(nu,4) + std::pow(nu,5)));
        moment_(7, std::pow(lambda,7) + 7.*std::pow(lambda,6)*(12. + nu) + 21.*std::pow(lambda,5)*(120. + 22.*nu + std::pow(nu,2)) + 35.*std::pow(lambda,4)*(960. + 296.*nu + 30.*std::pow(nu,2) + std::pow(nu,3)) + 35.*std::pow(lambda,3)*(5760. + 2736.*nu + 476.*std::pow(nu,2) + 36.*std::pow(nu,3) + std::pow(nu,4)) + 21.*std::pow(lambda,2)*(23040. + 16704.*nu + 4640.*std::pow(nu,2) + 620.*std::pow(nu,3) + 40.*std::pow(nu,4) + std::pow(nu,5)) + 7.*lambda*(46080. + 56448.*nu + 25984.*std::pow(nu,2) + 5880.*std::pow(nu,3) + 700.*std::pow(nu,4) + 42.*std::pow(nu,5) + std::pow(nu,6)) + nu*(46080. + 56448.*nu + 25984.*std::pow(nu,2) + 5880.*std::pow(nu,3) + 700.*std::pow(nu,4) + 42.*std::pow(nu,5) + std::pow(nu,6)));
        moment_(8, std::pow(lambda,8) + 8.*std::pow(lambda,7)*(14. + nu) + 28.*std::pow(lambda,6)*(168. + 26.*nu + std::pow(nu,2)) + 56.*std::pow(lambda,5)*(1680. + 428.*nu + 36.*std::pow(nu,2) + std::pow(nu,3)) + 70.*std::pow(lambda,4)*(13440. + 5104.*nu + 716.*std::pow(nu,2) + 44.*std::pow(nu,3) + std::pow(nu,4)) + 56.*std::pow(lambda,3)*(80640. + 44064.*nu + 9400.*std::pow(nu,2) + 980.*std::pow(nu,3) + 50.*std::pow(nu,4) + std::pow(nu,5)) + 28.*std::pow(lambda,2)*(322560. + 256896.*nu + 81664.*std::pow(nu,2) + 13320.*std::pow(nu,3) + 1180.*std::pow(nu,4) + 54.*std::pow(nu,5) + std::pow(nu,6)) + 8.*lambda*(645120. + 836352.*nu + 420224.*std::pow(nu,2) + 108304.*std::pow(nu,3) + 15680.*std::pow(nu,4) + 1288.*std::pow(nu,5) + 56.*std::pow(nu,6) + std::pow(nu,7)) + nu*(645120. + 836352.*nu + 420224.*std::pow(nu,2) + 108304.*std::pow(nu,3) + 15680.*std::pow(nu,4) + 1288.*std::pow(nu,5) + 56.*std::pow(nu,6) + std::pow(nu,7)));
        moment_(9, std::pow(lambda,9) + 9.*std::pow(lambda,8)*(16. + nu) + 36.*std::pow(lambda,7)*(224. + 30.*nu + std::pow(nu,2)) + 84.*std::pow(lambda,6)*(2688. + 584.*nu + 42.*std::pow(nu,2) + std::pow(nu,3)) + 126.*std::pow(lambda,5)*(26880. + 8528.*nu + 1004.*std::pow(nu,2) + 52.*std::pow(nu,3) + std::pow(nu,4)) + 126.*std::pow(lambda,4)*(215040. + 95104.*nu + 16560.*std::pow(nu,2) + 1420.*std::pow(nu,3) + 60.*std::pow(nu,4) + std::pow(nu,5)) + 84.*std::pow(lambda,3)*(1290240. + 785664.*nu + 194464.*std::pow(nu,2) + 25080.*std::pow(nu,3) + 1780.*std::pow(nu,4) + 66.*std::pow(nu,5) + std::pow(nu,6)) + 36.*std::pow(lambda,2)*(5160960. + 4432896.*nu + 1563520.*std::pow(nu,2) + 294784.*std::pow(nu,3) + 32200.*std::pow(nu,4) + 2044.*std::pow(nu,5) + 70.*std::pow(nu,6) + std::pow(nu,7)) + 9.*lambda*(10321920. + 14026752.*nu + 7559936.*std::pow(nu,2) + 2153088.*std::pow(nu,3) + 359184.*std::pow(nu,4) + 36288.*std::pow(nu,5) + 2184.*std::pow(nu,6) + 72.*std::pow(nu,7) + std::pow(nu,8)) + nu*(10321920. + 14026752.*nu + 7559936.*std::pow(nu,2) + 2153088.*std::pow(nu,3) + 359184.*std::pow(nu,4) + 36288.*std::pow(nu,5) + 2184.*std::pow(nu,6) + 72.*std::pow(nu,7) + std::pow(nu,8)));
        moment_(10, std::pow(lambda,10) + 10.*std::pow(lambda,9)*(18. + nu) + 45.*std::pow(lambda,8)*(288. + 34.*nu + std::pow(nu,2)) + 120.*std::pow(lambda,7)*(4032. + 764.*nu + 48.*std::pow(nu,2) + std::pow(nu,3)) + 210.*std::pow(lambda,6)*(48384. + 13200.*nu + 1340.*std::pow(nu,2) + 60.*std::pow(nu,3) + std::pow(nu,4)) + 252.*std::pow(lambda,5)*(483840. + 180384.*nu + 26600.*std::pow(nu,2) + 1940.*std::pow(nu,3) + 70.*std::pow(nu,4) + std::pow(nu,5)) + 210.*std::pow(lambda,4)*(3870720. + 1926912.*nu + 393184.*std::pow(nu,2) + 42120.*std::pow(nu,3) + 2500.*std::pow(nu,4) + 78.*std::pow(nu,5) + std::pow(nu,6)) + 120.*std::pow(lambda,3)*(23224320. + 15432192.*nu + 4286016.*std::pow(nu,2) + 645904.*std::pow(nu,3) + 57120.*std::pow(nu,4) + 2968.*std::pow(nu,5) + 84.*std::pow(nu,6) + std::pow(nu,7)) + 45.*std::pow(lambda,2)*(92897280. + 84953088.*nu + 32576256.*std::pow(nu,2) + 6869632.*std::pow(nu,3) + 874384.*std::pow(nu,4) + 68992.*std::pow(nu,5) + 3304.*std::pow(nu,6) + 88.*std::pow(nu,7) + std::pow(nu,8)) + 10.*lambda*(185794560. + 262803456.*nu + 150105600.*std::pow(nu,2) + 46315520.*std::pow(nu,3) + 8618400.*std::pow(nu,4) + 1012368.*std::pow(nu,5) + 75600.*std::pow(nu,6) + 3480.*std::pow(nu,7) + 90.*std::pow(nu,8) + std::pow(nu,9)) + nu*(185794560. + 262803456.*nu + 150105600.*std::pow(nu,2) + 46315520.*std::pow(nu,3) + 8618400.*std::pow(nu,4) + 1012368.*std::pow(nu,5) + 75600.*std::pow(nu,6) + 3480.*std::pow(nu,7) + 90.*std::pow(nu,8) + std::pow(nu,9)));
        moment_(11, std::pow(lambda,11) + 11.*std::pow(lambda,10)*(20. + nu) + 55.*std::pow(lambda,9)*(360. + 38.*nu + std::pow(nu,2)) + 165.*std::pow(lambda,8)*(5760. + 968.*nu + 54.*std::pow(nu,2) + std::pow(nu,3)) + 330.*std::pow(lambda,7)*(80640. + 19312.*nu + 1724.*std::pow(nu,2) + 68.*std::pow(nu,3) + std::pow(nu,4)) + 462.*std::pow(lambda,6)*(967680. + 312384.*nu + 40000.*std::pow(nu,2) + 2540.*std::pow(nu,3) + 80.*std::pow(nu,4) + std::pow(nu,5)) + 462.*std::pow(lambda,5)*(9676800. + 4091520.*nu + 712384.*std::pow(nu,2) + 65400.*std::pow(nu,3) + 3340.*std::pow(nu,4) + 90.*std::pow(nu,5) + std::pow(nu,6)) + 330.*std::pow(lambda,4)*(77414400. + 42408960.*nu + 9790592.*std::pow(nu,2) + 1235584.*std::pow(nu,3) + 92120.*std::pow(nu,4) + 4060.*std::pow(nu,5) + 98.*std::pow(nu,6) + std::pow(nu,7)) + 165.*std::pow(lambda,3)*(464486400. + 331868160.*nu + 101152512.*std::pow(nu,2) + 17204096.*std::pow(nu,3) + 1788304.*std::pow(nu,4) + 116480.*std::pow(nu,5) + 4648.*std::pow(nu,6) + 104.*std::pow(nu,7) + std::pow(nu,8)) + 55.*std::pow(lambda,2)*(1857945600. + 1791959040.*nu + 736478208.*std::pow(nu,2) + 169968896.*std::pow(nu,3) + 24357312.*std::pow(nu,4) + 2254224.*std::pow(nu,5) + 135072.*std::pow(nu,6) + 5064.*std::pow(nu,7) + 108.*std::pow(nu,8) + std::pow(nu,9)) + 11.*lambda*(3715891200. + 5441863680.*nu + 3264915456.*std::pow(nu,2) + 1076416000.*std::pow(nu,3) + 218683520.*std::pow(nu,4) + 28865760.*std::pow(nu,5) + 2524368.*std::pow(nu,6) + 145200.*std::pow(nu,7) + 5280.*std::pow(nu,8) + 110.*std::pow(nu,9) + std::pow(nu,10)) + nu*(3715891200. + 5441863680.*nu + 3264915456.*std::pow(nu,2) + 1076416000.*std::pow(nu,3) + 218683520.*std::pow(nu,4) + 28865760.*std::pow(nu,5) + 2524368.*std::pow(nu,6) + 145200.*std::pow(nu,7) + 5280.*std::pow(nu,8) + 110.*std::pow(nu,9) + std::pow(nu,10)));
        moment_(12, std::pow(lambda,12) + 12.*std::pow(lambda,11)*(22. + nu) + 66.*std::pow(lambda,10)*(440. + 42.*nu + std::pow(nu,2)) + 220.*std::pow(lambda,9)*(7920. + 1196.*nu + 60.*std::pow(nu,2) + std::pow(nu,3)) + 495.*std::pow(lambda,8)*(126720. + 27056.*nu + 2156.*std::pow(nu,2) + 76.*std::pow(nu,3) + std::pow(nu,4)) + 792.*std::pow(lambda,7)*(1774080. + 505504.*nu + 57240.*std::pow(nu,2) + 3220.*std::pow(nu,3) + 90.*std::pow(nu,4) + std::pow(nu,5)) + 924.*std::pow(lambda,6)*(21288960. + 7840128.*nu + 1192384.*std::pow(nu,2) + 95880.*std::pow(nu,3) + 4300.*std::pow(nu,4) + 102.*std::pow(nu,5) + std::pow(nu,6)) + 792.*std::pow(lambda,5)*(212889600. + 99690240.*nu + 19763968.*std::pow(nu,2) + 2151184.*std::pow(nu,3) + 138880.*std::pow(nu,4) + 5320.*std::pow(nu,5) + 112.*std::pow(nu,6) + std::pow(nu,7)) + 495.*std::pow(lambda,4)*(1703116800. + 1010411520.*nu + 257801984.*std::pow(nu,2) + 36973440.*std::pow(nu,3) + 3262224.*std::pow(nu,4) + 181440.*std::pow(nu,5) + 6216.*std::pow(nu,6) + 120.*std::pow(nu,7) + std::pow(nu,8)) + 220.*std::pow(lambda,3)*(10218700800. + 7765585920.*nu + 2557223424.*std::pow(nu,2) + 479642624.*std::pow(nu,3) + 56546784.*std::pow(nu,4) + 4350864.*std::pow(nu,5) + 218736.*std::pow(nu,6) + 6936.*std::pow(nu,7) + 126.*std::pow(nu,8) + std::pow(nu,9)) + 66.*std::pow(lambda,2)*(40874803200. + 41281044480.*nu + 17994479616.*std::pow(nu,2) + 4475793920.*std::pow(nu,3) + 705829760.*std::pow(nu,4) + 73950240.*std::pow(nu,5) + 5225808.*std::pow(nu,6) + 246480.*std::pow(nu,7) + 7440.*std::pow(nu,8) + 130.*std::pow(nu,9) + std::pow(nu,10)) + 12.*lambda*(81749606400. + 123436892160.*nu + 77270003712.*std::pow(nu,2) + 26946067456.*std::pow(nu,3) + 5887453440.*std::pow(nu,4) + 853730240.*std::pow(nu,5) + 84401856.*std::pow(nu,6) + 5718768.*std::pow(nu,7) + 261360.*std::pow(nu,8) + 7700.*std::pow(nu,9) + 132.*std::pow(nu,10) + std::pow(nu,11)) + nu*(81749606400. + 123436892160.*nu + 77270003712.*std::pow(nu,2) + 26946067456.*std::pow(nu,3) + 5887453440.*std::pow(nu,4) + 853730240.*std::pow(nu,5) + 84401856.*std::pow(nu,6) + 5718768.*std::pow(nu,7) + 261360.*std::pow(nu,8) + 7700.*std::pow(nu,9) + 132.*std::pow(nu,10) + std::pow(nu,11)));
        moment_(13, std::pow(lambda,13) + 13.*std::pow(lambda,12)*(24. + nu) + 78.*std::pow(lambda,11)*(528. + 46.*nu + std::pow(nu,2)) + 286.*std::pow(lambda,10)*(10560. + 1448.*nu + 66.*std::pow(nu,2) + std::pow(nu,3)) + 715.*std::pow(lambda,9)*(190080. + 36624.*nu + 2636.*std::pow(nu,2) + 84.*std::pow(nu,3) + std::pow(nu,4)) + 1287.*std::pow(lambda,8)*(3041280. + 776064.*nu + 78800.*std::pow(nu,2) + 3980.*std::pow(nu,3) + 100.*std::pow(nu,4) + std::pow(nu,5)) + 1716.*std::pow(lambda,7)*(42577920. + 13906176.*nu + 1879264.*std::pow(nu,2) + 134520.*std::pow(nu,3) + 5380.*std::pow(nu,4) + 114.*std::pow(nu,5) + std::pow(nu,6)) + 1716.*std::pow(lambda,6)*(510935040. + 209452032.*nu + 36457344.*std::pow(nu,2) + 3493504.*std::pow(nu,3) + 199080.*std::pow(nu,4) + 6748.*std::pow(nu,5) + 126.*std::pow(nu,6) + std::pow(nu,7)) + 1287.*std::pow(lambda,5)*(5109350400. + 2605455360.*nu + 574025472.*std::pow(nu,2) + 71392384.*std::pow(nu,3) + 5484304.*std::pow(nu,4) + 266560.*std::pow(nu,5) + 8008.*std::pow(nu,6) + 136.*std::pow(nu,7) + std::pow(nu,8)) + 715.*std::pow(lambda,4)*(40874803200. + 25952993280.*nu + 7197659136.*std::pow(nu,2) + 1145164544.*std::pow(nu,3) + 115266816.*std::pow(nu,4) + 7616784.*std::pow(nu,5) + 330624.*std::pow(nu,6) + 9096.*std::pow(nu,7) + 144.*std::pow(nu,8) + std::pow(nu,9)) + 286.*std::pow(lambda,3)*(245248819200. + 196592762880.*nu + 69138948096.*std::pow(nu,2) + 14068646400.*std::pow(nu,3) + 1836765440.*std::pow(nu,4) + 160967520.*std::pow(nu,5) + 9600528.*std::pow(nu,6) + 385200.*std::pow(nu,7) + 9960.*std::pow(nu,8) + 150.*std::pow(nu,9) + std::pow(nu,10)) + 78.*std::pow(lambda,2)*(980995276800. + 1031619870720.*nu + 473148555264.*std::pow(nu,2) + 125413533696.*std::pow(nu,3) + 21415708160.*std::pow(nu,4) + 2480635520.*std::pow(nu,5) + 199369632.*std::pow(nu,6) + 11141328.*std::pow(nu,7) + 425040.*std::pow(nu,8) + 10560.*std::pow(nu,9) + 154.*std::pow(nu,10) + std::pow(nu,11)) + 13.*lambda*(1961990553600. + 3044235018240.*nu + 1977916981248.*std::pow(nu,2) + 723975622656.*std::pow(nu,3) + 168244950016.*std::pow(nu,4) + 26376979200.*std::pow(nu,5) + 2879374784.*std::pow(nu,6) + 221652288.*std::pow(nu,7) + 11991408.*std::pow(nu,8) + 446160.*std::pow(nu,9) + 10868.*std::pow(nu,10) + 156.*std::pow(nu,11) + std::pow(nu,12)) + nu*(1961990553600. + 3044235018240.*nu + 1977916981248.*std::pow(nu,2) + 723975622656.*std::pow(nu,3) + 168244950016.*std::pow(nu,4) + 26376979200.*std::pow(nu,5) + 2879374784.*std::pow(nu,6) + 221652288.*std::pow(nu,7) + 11991408.*std::pow(nu,8) + 446160.*std::pow(nu,9) + 10868.*std::pow(nu,10) + 156.*std::pow(nu,11) + std::pow(nu,12)));
        moment_(14, std::pow(lambda,14) + 14.*std::pow(lambda,13)*(26. + nu) + 91.*std::pow(lambda,12)*(624. + 50.*nu + std::pow(nu,2)) + 364.*std::pow(lambda,11)*(13728. + 1724.*nu + 72.*std::pow(nu,2) + std::pow(nu,3)) + 1001.*std::pow(lambda,10)*(274560. + 48208.*nu + 3164.*std::pow(nu,2) + 92.*std::pow(nu,3) + std::pow(nu,4)) + 2002.*std::pow(lambda,9)*(4942080. + 1142304.*nu + 105160.*std::pow(nu,2) + 4820.*std::pow(nu,3) + 110.*std::pow(nu,4) + std::pow(nu,5)) + 3003.*std::pow(lambda,8)*(79073280. + 23218944.*nu + 2824864.*std::pow(nu,2) + 182280.*std::pow(nu,3) + 6580.*std::pow(nu,4) + 126.*std::pow(nu,5) + std::pow(nu,6)) + 3432.*std::pow(lambda,7)*(1107025920. + 404138496.*nu + 62767040.*std::pow(nu,2) + 5376784.*std::pow(nu,3) + 274400.*std::pow(nu,4) + 8344.*std::pow(nu,5) + 140.*std::pow(nu,6) + std::pow(nu,7)) + 3003.*std::pow(lambda,6)*(13284311040. + 5956687872.*nu + 1157342976.*std::pow(nu,2) + 127288448.*std::pow(nu,3) + 8669584.*std::pow(nu,4) + 374528.*std::pow(nu,5) + 10024.*std::pow(nu,6) + 152.*std::pow(nu,7) + std::pow(nu,8)) + 2002.*std::pow(lambda,5)*(132843110400. + 72851189760.*nu + 17530117632.*std::pow(nu,2) + 2430227456.*std::pow(nu,3) + 213984288.*std::pow(nu,4) + 12414864.*std::pow(nu,5) + 474768.*std::pow(nu,6) + 11544.*std::pow(nu,7) + 162.*std::pow(nu,8) + std::pow(nu,9)) + 1001.*std::pow(lambda,4)*(1062744883200. + 715652628480.*nu + 213092130816.*std::pow(nu,2) + 36971937280.*std::pow(nu,3) + 4142101760.*std::pow(nu,4) + 313303200.*std::pow(nu,5) + 16213008.*std::pow(nu,6) + 567120.*std::pow(nu,7) + 12840.*std::pow(nu,8) + 170.*std::pow(nu,9) + std::pow(nu,10)) + 364.*std::pow(lambda,3)*(6376469299200. + 5356660654080.*nu + 1994205413376.*std::pow(nu,2) + 434923754496.*std::pow(nu,3) + 61824547840.*std::pow(nu,4) + 6021920960.*std::pow(nu,5) + 410581248.*std::pow(nu,6) + 19615728.*std::pow(nu,7) + 644160.*std::pow(nu,8) + 13860.*std::pow(nu,9) + 176.*std::pow(nu,10) + std::pow(nu,11)) + 91.*std::pow(lambda,2)*(25505877196800. + 27803111915520.*nu + 13333482307584.*std::pow(nu,2) + 3733900431360.*std::pow(nu,3) + 682221945856.*std::pow(nu,4) + 85912231680.*std::pow(nu,5) + 7664245952.*std::pow(nu,6) + 489044160.*std::pow(nu,7) + 22192368.*std::pow(nu,8) + 699600.*std::pow(nu,9) + 14564.*std::pow(nu,10) + 180.*std::pow(nu,11) + std::pow(nu,12)) + 14.*lambda*(51011754393600. + 81112101027840.*nu + 54470076530688.*std::pow(nu,2) + 20801283170304.*std::pow(nu,3) + 5098344323072.*std::pow(nu,4) + 854046409216.*std::pow(nu,5) + 101240723584.*std::pow(nu,6) + 8642334272.*std::pow(nu,7) + 533428896.*std::pow(nu,8) + 23591568.*std::pow(nu,9) + 728728.*std::pow(nu,10) + 14924.*std::pow(nu,11) + 182.*std::pow(nu,12) + std::pow(nu,13)) + nu*(51011754393600. + 81112101027840.*nu + 54470076530688.*std::pow(nu,2) + 20801283170304.*std::pow(nu,3) + 5098344323072.*std::pow(nu,4) + 854046409216.*std::pow(nu,5) + 101240723584.*std::pow(nu,6) + 8642334272.*std::pow(nu,7) + 533428896.*std::pow(nu,8) + 23591568.*std::pow(nu,9) + 728728.*std::pow(nu,10) + 14924.*std::pow(nu,11) + 182.*std::pow(nu,12) + std::pow(nu,13)));
        moment_(15, std::pow(lambda,15) + 15.*std::pow(lambda,14)*(28. + nu) + 105.*std::pow(lambda,13)*(728. + 54.*nu + std::pow(nu,2)) + 455.*std::pow(lambda,12)*(17472. + 2024.*nu + 78.*std::pow(nu,2) + std::pow(nu,3)) + 1365.*std::pow(lambda,11)*(384384. + 62000.*nu + 3740.*std::pow(nu,2) + 100.*std::pow(nu,3) + std::pow(nu,4)) + 3003.*std::pow(lambda,10)*(7687680. + 1624384.*nu + 136800.*std::pow(nu,2) + 5740.*std::pow(nu,3) + 120.*std::pow(nu,4) + std::pow(nu,5)) + 5005.*std::pow(lambda,9)*(138378240. + 36926592.*nu + 4086784.*std::pow(nu,2) + 240120.*std::pow(nu,3) + 7900.*std::pow(nu,4) + 138.*std::pow(nu,5) + std::pow(nu,6)) + 6435.*std::pow(lambda,8)*(2214051840. + 729203712.*nu + 102315136.*std::pow(nu,2) + 7928704.*std::pow(nu,3) + 366520.*std::pow(nu,4) + 10108.*std::pow(nu,5) + 154.*std::pow(nu,6) + std::pow(nu,7)) + 6435.*std::pow(lambda,7)*(30996725760. + 12422903808.*nu + 2161615616.*std::pow(nu,2) + 213316992.*std::pow(nu,3) + 13059984.*std::pow(nu,4) + 508032.*std::pow(nu,5) + 12264.*std::pow(nu,6) + 168.*std::pow(nu,7) + std::pow(nu,8)) + 5005.*std::pow(lambda,6)*(371960709120. + 180071571456.*nu + 38362291200.*std::pow(nu,2) + 4721419520.*std::pow(nu,3) + 370036800.*std::pow(nu,4) + 19156368.*std::pow(nu,5) + 655200.*std::pow(nu,6) + 14280.*std::pow(nu,7) + 180.*std::pow(nu,8) + std::pow(nu,9)) + 3003.*std::pow(lambda,5)*(3719607091200. + 2172676423680.*nu + 563694483456.*std::pow(nu,2) + 85576486400.*std::pow(nu,3) + 8421787520.*std::pow(nu,4) + 561600480.*std::pow(nu,5) + 25708368.*std::pow(nu,6) + 798000.*std::pow(nu,7) + 16080.*std::pow(nu,8) + 190.*std::pow(nu,9) + std::pow(nu,10)) + 1365.*std::pow(lambda,4)*(29756856729600. + 21101018480640.*nu + 6682232291328.*std::pow(nu,2) + 1248306374656.*std::pow(nu,3) + 152950786560.*std::pow(nu,4) + 12914591360.*std::pow(nu,5) + 767267424.*std::pow(nu,6) + 32092368.*std::pow(nu,7) + 926640.*std::pow(nu,8) + 17600.*std::pow(nu,9) + 198.*std::pow(nu,10) + std::pow(nu,11)) + 455.*std::pow(lambda,3)*(178541140377600. + 156362967613440.*nu + 61194412228608.*std::pow(nu,2) + 14172070539264.*std::pow(nu,3) + 2166011094016.*std::pow(nu,4) + 230438334720.*std::pow(nu,5) + 17518195904.*std::pow(nu,6) + 959821632.*std::pow(nu,7) + 37652208.*std::pow(nu,8) + 1032240.*std::pow(nu,9) + 18788.*std::pow(nu,10) + 204.*std::pow(nu,11) + std::pow(nu,12)) + 105.*std::pow(lambda,2)*(714164561510400. + 803993010831360.*nu + 401140616527872.*std::pow(nu,2) + 117882694385664.*std::pow(nu,3) + 22836114915328.*std::pow(nu,4) + 3087764432896.*std::pow(nu,5) + 300511118336.*std::pow(nu,6) + 21357482432.*std::pow(nu,7) + 1110430464.*std::pow(nu,8) + 41781168.*std::pow(nu,9) + 1107392.*std::pow(nu,10) + 19604.*std::pow(nu,11) + 208.*std::pow(nu,12) + std::pow(nu,13)) + 15.*lambda*(1428329123020800. + 2322150583173120.*nu + 1606274243887104.*std::pow(nu,2) + 636906005299200.*std::pow(nu,3) + 163554924216320.*std::pow(nu,4) + 29011643781120.*std::pow(nu,5) + 3688786669568.*std::pow(nu,6) + 343226083200.*std::pow(nu,7) + 23578343360.*std::pow(nu,8) + 1193992800.*std::pow(nu,9) + 43995952.*std::pow(nu,10) + 1146600.*std::pow(nu,11) + 20020.*std::pow(nu,12) + 210.*std::pow(nu,13) + std::pow(nu,14)) + nu*(1428329123020800. + 2322150583173120.*nu + 1606274243887104.*std::pow(nu,2) + 636906005299200.*std::pow(nu,3) + 163554924216320.*std::pow(nu,4) + 29011643781120.*std::pow(nu,5) + 3688786669568.*std::pow(nu,6) + 343226083200.*std::pow(nu,7) + 23578343360.*std::pow(nu,8) + 1193992800.*std::pow(nu,9) + 43995952.*std::pow(nu,10) + 1146600.*std::pow(nu,11) + 20020.*std::pow(nu,12) + 210.*std::pow(nu,13) + std::pow(nu,14)));
        moment_(16, std::pow(lambda,16) + 16.*std::pow(lambda,15)*(30. + nu) + 120.*std::pow(lambda,14)*(840. + 58.*nu + std::pow(nu,2)) + 560.*std::pow(lambda,13)*(21840. + 2348.*nu + 84.*std::pow(nu,2) + std::pow(nu,3)) + 1820.*std::pow(lambda,12)*(524160. + 78192.*nu + 4364.*std::pow(nu,2) + 108.*std::pow(nu,3) + std::pow(nu,4)) + 4368.*std::pow(lambda,11)*(11531520. + 2244384.*nu + 174200.*std::pow(nu,2) + 6740.*std::pow(nu,3) + 130.*std::pow(nu,4) + std::pow(nu,5)) + 8008.*std::pow(lambda,10)*(230630400. + 56419200.*nu + 5728384.*std::pow(nu,2) + 309000.*std::pow(nu,3) + 9340.*std::pow(nu,4) + 150.*std::pow(nu,5) + std::pow(nu,6)) + 11440.*std::pow(lambda,9)*(4151347200. + 1246176000.*nu + 159530112.*std::pow(nu,2) + 11290384.*std::pow(nu,3) + 477120.*std::pow(nu,4) + 12040.*std::pow(nu,5) + 168.*std::pow(nu,6) + std::pow(nu,7)) + 12870.*std::pow(lambda,8)*(66421555200. + 24090163200.*nu + 3798657792.*std::pow(nu,2) + 340176256.*std::pow(nu,3) + 18924304.*std::pow(nu,4) + 669760.*std::pow(nu,5) + 14728.*std::pow(nu,6) + 184.*std::pow(nu,7) + std::pow(nu,8)) + 11440.*std::pow(lambda,7)*(929901772800. + 403683840000.*nu + 77271372288.*std::pow(nu,2) + 8561125376.*std::pow(nu,3) + 605116512.*std::pow(nu,4) + 28300944.*std::pow(nu,5) + 875952.*std::pow(nu,6) + 17304.*std::pow(nu,7) + 198.*std::pow(nu,8) + std::pow(nu,9)) + 8008.*std::pow(lambda,6)*(11158821273600. + 5774107852800.*nu + 1330940307456.*std::pow(nu,2) + 180004876800.*std::pow(nu,3) + 15822523520.*std::pow(nu,4) + 944727840.*std::pow(nu,5) + 38812368.*std::pow(nu,6) + 1083600.*std::pow(nu,7) + 19680.*std::pow(nu,8) + 210.*std::pow(nu,9) + std::pow(nu,10)) + 4368.*std::pow(lambda,5)*(111588212736000. + 68899899801600.*nu + 19083510927360.*std::pow(nu,2) + 3130989075456.*std::pow(nu,3) + 338230112000.*std::pow(nu,4) + 25269801920.*std::pow(nu,5) + 1332851520.*std::pow(nu,6) + 49648368.*std::pow(nu,7) + 1280400.*std::pow(nu,8) + 21780.*std::pow(nu,9) + 220.*std::pow(nu,10) + std::pow(nu,11)) + 1820.*std::pow(lambda,4)*(892705701888000. + 662787411148800.*nu + 221567987220480.*std::pow(nu,2) + 44131423531008.*std::pow(nu,3) + 5836829971456.*std::pow(nu,4) + 540388527360.*std::pow(nu,5) + 35932614080.*std::pow(nu,6) + 1730038464.*std::pow(nu,7) + 59891568.*std::pow(nu,8) + 1454640.*std::pow(nu,9) + 23540.*std::pow(nu,10) + 228.*std::pow(nu,11) + std::pow(nu,12)) + 560.*std::pow(lambda,3)*(5356234211328000. + 4869430168780800.*nu + 1992195334471680.*std::pow(nu,2) + 486356528406528.*std::pow(nu,3) + 79152403359744.*std::pow(nu,4) + 9079161135616.*std::pow(nu,5) + 755984211840.*std::pow(nu,6) + 46312844864.*std::pow(nu,7) + 2089387872.*std::pow(nu,8) + 68619408.*std::pow(nu,9) + 1595880.*std::pow(nu,10) + 24908.*std::pow(nu,11) + 234.*std::pow(nu,12) + std::pow(nu,13)) + 120.*std::pow(lambda,2)*(21424936845312000. + 24833954886451200.*nu + 12838211506667520.*std::pow(nu,2) + 3937621448097792.*std::pow(nu,3) + 802966141845504.*std::pow(nu,4) + 115469047902208.*std::pow(nu,5) + 12103097982976.*std::pow(nu,6) + 941235591296.*std::pow(nu,7) + 54670396352.*std::pow(nu,8) + 2363865504.*std::pow(nu,9) + 75002928.*std::pow(nu,10) + 1695512.*std::pow(nu,11) + 25844.*std::pow(nu,12) + 238.*std::pow(nu,13) + std::pow(nu,14)) + 16.*lambda*(42849873690624000. + 71092846618214400.*nu + 50510377899786240.*std::pow(nu,2) + 20713454402863104.*std::pow(nu,3) + 5543553731788800.*std::pow(nu,4) + 1033904237649920.*std::pow(nu,5) + 139675243868160.*std::pow(nu,6) + 13985569165568.*std::pow(nu,7) + 1050576384000.*std::pow(nu,8) + 59398127360.*std::pow(nu,9) + 2513871360.*std::pow(nu,10) + 78393952.*std::pow(nu,11) + 1747200.*std::pow(nu,12) + 26320.*std::pow(nu,13) + 240.*std::pow(nu,14) + std::pow(nu,15)) + nu*(42849873690624000. + 71092846618214400.*nu + 50510377899786240.*std::pow(nu,2) + 20713454402863104.*std::pow(nu,3) + 5543553731788800.*std::pow(nu,4) + 1033904237649920.*std::pow(nu,5) + 139675243868160.*std::pow(nu,6) + 13985569165568.*std::pow(nu,7) + 1050576384000.*std::pow(nu,8) + 59398127360.*std::pow(nu,9) + 2513871360.*std::pow(nu,10) + 78393952.*std::pow(nu,11) + 1747200.*std::pow(nu,12) + 26320.*std::pow(nu,13) + 240.*std::pow(nu,14) + std::pow(nu,15)));
        moment_(17, std::pow(lambda,17) + 17.*std::pow(lambda,16)*(32. + nu) + 136.*std::pow(lambda,15)*(960. + 62.*nu + std::pow(nu,2)) + 680.*std::pow(lambda,14)*(26880. + 2696.*nu + 90.*std::pow(nu,2) + std::pow(nu,3)) + 2380.*std::pow(lambda,13)*(698880. + 96976.*nu + 5036.*std::pow(nu,2) + 116.*std::pow(nu,3) + std::pow(nu,4)) + 6188.*std::pow(lambda,12)*(16773120. + 3026304.*nu + 217840.*std::pow(nu,2) + 7820.*std::pow(nu,3) + 140.*std::pow(nu,4) + std::pow(nu,5)) + 12376.*std::pow(lambda,11)*(369008640. + 83351808.*nu + 7818784.*std::pow(nu,2) + 389880.*std::pow(nu,3) + 10900.*std::pow(nu,4) + 162.*std::pow(nu,5) + std::pow(nu,6)) + 19448.*std::pow(lambda,10)*(7380172800. + 2036044800.*nu + 239727488.*std::pow(nu,2) + 15616384.*std::pow(nu,3) + 607880.*std::pow(nu,4) + 14140.*std::pow(nu,5) + 182.*std::pow(nu,6) + std::pow(nu,7)) + 24310.*std::pow(lambda,9)*(132843110400. + 44028979200.*nu + 6351139584.*std::pow(nu,2) + 520822400.*std::pow(nu,3) + 26558224.*std::pow(nu,4) + 862400.*std::pow(nu,5) + 17416.*std::pow(nu,6) + 200.*std::pow(nu,7) + std::pow(nu,8)) + 24310.*std::pow(lambda,8)*(2125489766400. + 837306777600.*nu + 145647212544.*std::pow(nu,2) + 14684297984.*std::pow(nu,3) + 945753984.*std::pow(nu,4) + 40356624.*std::pow(nu,5) + 1141056.*std::pow(nu,6) + 20616.*std::pow(nu,7) + 216.*std::pow(nu,8) + std::pow(nu,9)) + 19448.*std::pow(lambda,7)*(29756856729600. + 13847784652800.*nu + 2876367753216.*std::pow(nu,2) + 351227384320.*std::pow(nu,3) + 27924853760.*std::pow(nu,4) + 1510746720.*std::pow(nu,5) + 56331408.*std::pow(nu,6) + 1429680.*std::pow(nu,7) + 23640.*std::pow(nu,8) + 230.*std::pow(nu,9) + std::pow(nu,10)) + 12376.*std::pow(lambda,6)*(357082280755200. + 195930272563200.*nu + 48364197691392.*std::pow(nu,2) + 7091096365056.*std::pow(nu,3) + 686325629440.*std::pow(nu,4) + 46053814400.*std::pow(nu,5) + 2186723616.*std::pow(nu,6) + 73487568.*std::pow(nu,7) + 1713360.*std::pow(nu,8) + 26400.*std::pow(nu,9) + 242.*std::pow(nu,10) + std::pow(nu,11)) + 6188.*std::pow(lambda,5)*(3570822807552000. + 2316385006387200.*nu + 679572249477120.*std::pow(nu,2) + 119275161341952.*std::pow(nu,3) + 13954352659456.*std::pow(nu,4) + 1146863773440.*std::pow(nu,5) + 67921050560.*std::pow(nu,6) + 2921599296.*std::pow(nu,7) + 90621168.*std::pow(nu,8) + 1977360.*std::pow(nu,9) + 28820.*std::pow(nu,10) + 252.*std::pow(nu,11) + std::pow(nu,12)) + 2380.*std::pow(lambda,4)*(28566582460416000. + 22101902858649600.*nu + 7752963002204160.*std::pow(nu,2) + 1633773540212736.*std::pow(nu,3) + 230909982617600.*std::pow(nu,4) + 23129262846976.*std::pow(nu,5) + 1690232177920.*std::pow(nu,6) + 91293844928.*std::pow(nu,7) + 3646568640.*std::pow(nu,8) + 106440048.*std::pow(nu,9) + 2207920.*std::pow(nu,10) + 30836.*std::pow(nu,11) + 260.*std::pow(nu,12) + std::pow(nu,13)) + 680.*std::pow(lambda,3)*(171399494762496000. + 161177999612313600.*nu + 68619680871874560.*std::pow(nu,2) + 17555604243480576.*std::pow(nu,3) + 3019233435918336.*std::pow(nu,4) + 369685559699456.*std::pow(nu,5) + 33270655914496.*std::pow(nu,6) + 2237995247488.*std::pow(nu,7) + 113173256768.*std::pow(nu,8) + 4285208928.*std::pow(nu,9) + 119687568.*std::pow(nu,10) + 2392936.*std::pow(nu,11) + 32396.*std::pow(nu,12) + 266.*std::pow(nu,13) + std::pow(nu,14)) + 136.*std::pow(lambda,2)*(685597979049984000. + 816111493211750400.*nu + 435656723099811840.*std::pow(nu,2) + 138842097845796864.*std::pow(nu,3) + 29632537987153920.*std::pow(nu,4) + 4497975674716160.*std::pow(nu,5) + 502768183357440.*std::pow(nu,6) + 42222636904448.*std::pow(nu,7) + 2690688274560.*std::pow(nu,8) + 130314092480.*std::pow(nu,9) + 4763959200.*std::pow(nu,10) + 129259312.*std::pow(nu,11) + 2522520.*std::pow(nu,12) + 33460.*std::pow(nu,13) + 270.*std::pow(nu,14) + std::pow(nu,15)) + 17.*lambda*(1371195958099968000. + 2317820965473484800.*nu + 1687424939411374080.*std::pow(nu,2) + 713340918791405568.*std::pow(nu,3) + 198107173820104704.*std::pow(nu,4) + 38628489336586240.*std::pow(nu,5) + 5503512041431040.*std::pow(nu,6) + 587213457166336.*std::pow(nu,7) + 47604013453568.*std::pow(nu,8) + 2951316459520.*std::pow(nu,9) + 139842010880.*std::pow(nu,10) + 5022477824.*std::pow(nu,11) + 134304352.*std::pow(nu,12) + 2589440.*std::pow(nu,13) + 34000.*std::pow(nu,14) + 272.*std::pow(nu,15) + std::pow(nu,16)) + nu*(1371195958099968000. + 2317820965473484800.*nu + 1687424939411374080.*std::pow(nu,2) + 713340918791405568.*std::pow(nu,3) + 198107173820104704.*std::pow(nu,4) + 38628489336586240.*std::pow(nu,5) + 5503512041431040.*std::pow(nu,6) + 587213457166336.*std::pow(nu,7) + 47604013453568.*std::pow(nu,8) + 2951316459520.*std::pow(nu,9) + 139842010880.*std::pow(nu,10) + 5022477824.*std::pow(nu,11) + 134304352.*std::pow(nu,12) + 2589440.*std::pow(nu,13) + 34000.*std::pow(nu,14) + 272.*std::pow(nu,15) + std::pow(nu,16)));
        moment_(18, std::pow(lambda,18) + 18.*std::pow(lambda,17)*(34. + nu) + 153.*std::pow(lambda,16)*(1088. + 66.*nu + std::pow(nu,2)) + 816.*std::pow(lambda,15)*(32640. + 3068.*nu + 96.*std::pow(nu,2) + std::pow(nu,3)) + 3060.*std::pow(lambda,14)*(913920. + 118544.*nu + 5756.*std::pow(nu,2) + 124.*std::pow(nu,3) + std::pow(nu,4)) + 8568.*std::pow(lambda,13)*(23761920. + 3996064.*nu + 268200.*std::pow(nu,2) + 8980.*std::pow(nu,3) + 150.*std::pow(nu,4) + std::pow(nu,5)) + 18564.*std::pow(lambda,12)*(570286080. + 119667456.*nu + 10432864.*std::pow(nu,2) + 483720.*std::pow(nu,3) + 12580.*std::pow(nu,4) + 174.*std::pow(nu,5) + std::pow(nu,6)) + 31824.*std::pow(lambda,11)*(12546293760. + 3202970112.*nu + 349190464.*std::pow(nu,2) + 21074704.*std::pow(nu,3) + 760480.*std::pow(nu,4) + 16408.*std::pow(nu,5) + 196.*std::pow(nu,6) + std::pow(nu,7)) + 43758.*std::pow(lambda,10)*(250925875200. + 76605696000.*nu + 10186779392.*std::pow(nu,2) + 770684544.*std::pow(nu,3) + 36284304.*std::pow(nu,4) + 1088640.*std::pow(nu,5) + 20328.*std::pow(nu,6) + 216.*std::pow(nu,7) + std::pow(nu,8)) + 48620.*std::pow(lambda,9)*(4516665753600. + 1629828403200.*nu + 259967725056.*std::pow(nu,2) + 24059101184.*std::pow(nu,3) + 1423802016.*std::pow(nu,4) + 55879824.*std::pow(nu,5) + 1454544.*std::pow(nu,6) + 24216.*std::pow(nu,7) + 234.*std::pow(nu,8) + std::pow(nu,9)) + 43758.*std::pow(lambda,8)*(72266652057600. + 30593920204800.*nu + 5789312004096.*std::pow(nu,2) + 644913344000.*std::pow(nu,3) + 46839933440.*std::pow(nu,4) + 2317879200.*std::pow(nu,5) + 79152528.*std::pow(nu,6) + 1842000.*std::pow(nu,7) + 27960.*std::pow(nu,8) + 250.*std::pow(nu,9) + std::pow(nu,10)) + 31824.*std::pow(lambda,7)*(1011733128806400. + 500581534924800.*nu + 111644288262144.*std::pow(nu,2) + 14818098820096.*std::pow(nu,3) + 1300672412160.*std::pow(nu,4) + 79290242240.*std::pow(nu,5) + 3426014592.*std::pow(nu,6) + 104940528.*std::pow(nu,7) + 2233440.*std::pow(nu,8) + 31460.*std::pow(nu,9) + 264.*std::pow(nu,10) + std::pow(nu,11)) + 18564.*std::pow(lambda,6)*(12140797545676800. + 7018711547904000.*nu + 1840312994070528.*std::pow(nu,2) + 289461474103296.*std::pow(nu,3) + 30426167766016.*std::pow(nu,4) + 2252155319040.*std::pow(nu,5) + 120402417344.*std::pow(nu,6) + 4685300928.*std::pow(nu,7) + 131741808.*std::pow(nu,8) + 2610960.*std::pow(nu,9) + 34628.*std::pow(nu,10) + 276.*std::pow(nu,11) + std::pow(nu,12)) + 8568.*std::pow(lambda,5)*(121407975456768000. + 82327913024716800.*nu + 25421841488609280.*std::pow(nu,2) + 4734927735103488.*std::pow(nu,3) + 593723151763456.*std::pow(nu,4) + 52947720956416.*std::pow(nu,5) + 3456179492480.*std::pow(nu,6) + 167255426624.*std::pow(nu,7) + 6002719008.*std::pow(nu,8) + 157851408.*std::pow(nu,9) + 2957240.*std::pow(nu,10) + 37388.*std::pow(nu,11) + 286.*std::pow(nu,12) + std::pow(nu,13)) + 3060.*std::pow(lambda,4)*(971263803654144000. + 780031279654502400.*nu + 285702644933591040.*std::pow(nu,2) + 63301263369437184.*std::pow(nu,3) + 9484712949211136.*std::pow(nu,4) + 1017304919414784.*std::pow(nu,5) + 80597156896256.*std::pow(nu,6) + 4794222905472.*std::pow(nu,7) + 215277178688.*std::pow(nu,8) + 7265530272.*std::pow(nu,9) + 181509328.*std::pow(nu,10) + 3256344.*std::pow(nu,11) + 39676.*std::pow(nu,12) + 294.*std::pow(nu,13) + std::pow(nu,14)) + 816.*std::pow(lambda,3)*(5827582821924864000. + 5651451481581158400.*nu + 2494247149256048640.*std::pow(nu,2) + 665510225150214144.*std::pow(nu,3) + 120209541064704000.*std::pow(nu,4) + 15588542465699840.*std::pow(nu,5) + 1500887860792320.*std::pow(nu,6) + 109362494329088.*std::pow(nu,7) + 6085885977600.*std::pow(nu,8) + 258870360320.*std::pow(nu,9) + 8354586240.*std::pow(nu,10) + 201047392.*std::pow(nu,11) + 3494400.*std::pow(nu,12) + 41440.*std::pow(nu,13) + 300.*std::pow(nu,14) + std::pow(nu,15)) + 153.*std::pow(lambda,2)*(23310331287699456000. + 28433388748249497600.*nu + 15628440078605352960.*std::pow(nu,2) + 5156288049856905216.*std::pow(nu,3) + 1146348389409030144.*std::pow(nu,4) + 182563710927503360.*std::pow(nu,5) + 21592093908869120.*std::pow(nu,6) + 1938337838108672.*std::pow(nu,7) + 133706038239488.*std::pow(nu,8) + 7121367418880.*std::pow(nu,9) + 292288705280.*std::pow(nu,10) + 9158775808.*std::pow(nu,11) + 215024992.*std::pow(nu,12) + 3660160.*std::pow(nu,13) + 42640.*std::pow(nu,14) + 304.*std::pow(nu,15) + std::pow(nu,16)) + 18.*lambda*(46620662575398912000. + 80177108784198451200.*nu + 59690268905460203520.*std::pow(nu,2) + 25941016178319163392.*std::pow(nu,3) + 7448984828674965504.*std::pow(nu,4) + 1511475811264036864.*std::pow(nu,5) + 225747898745241600.*std::pow(nu,6) + 25468769585086464.*std::pow(nu,7) + 2205749914587648.*std::pow(nu,8) + 147948773077248.*std::pow(nu,9) + 7705944829440.*std::pow(nu,10) + 310606256896.*std::pow(nu,11) + 9588825792.*std::pow(nu,12) + 222345312.*std::pow(nu,13) + 3745440.*std::pow(nu,14) + 43248.*std::pow(nu,15) + 306.*std::pow(nu,16) + std::pow(nu,17)) + nu*(46620662575398912000. + 80177108784198451200.*nu + 59690268905460203520.*std::pow(nu,2) + 25941016178319163392.*std::pow(nu,3) + 7448984828674965504.*std::pow(nu,4) + 1511475811264036864.*std::pow(nu,5) + 225747898745241600.*std::pow(nu,6) + 25468769585086464.*std::pow(nu,7) + 2205749914587648.*std::pow(nu,8) + 147948773077248.*std::pow(nu,9) + 7705944829440.*std::pow(nu,10) + 310606256896.*std::pow(nu,11) + 9588825792.*std::pow(nu,12) + 222345312.*std::pow(nu,13) + 3745440.*std::pow(nu,14) + 43248.*std::pow(nu,15) + 306.*std::pow(nu,16) + std::pow(nu,17)));
        moment_(19, std::pow(lambda,19) + 19.*std::pow(lambda,18)*(36. + nu) + 171.*std::pow(lambda,17)*(1224. + 70.*nu + std::pow(nu,2)) + 969.*std::pow(lambda,16)*(39168. + 3464.*nu + 102.*std::pow(nu,2) + std::pow(nu,3)) + 3876.*std::pow(lambda,15)*(1175040. + 143088.*nu + 6524.*std::pow(nu,2) + 132.*std::pow(nu,3) + std::pow(nu,4)) + 11628.*std::pow(lambda,14)*(32901120. + 5181504.*nu + 325760.*std::pow(nu,2) + 10220.*std::pow(nu,3) + 160.*std::pow(nu,4) + std::pow(nu,5)) + 27132.*std::pow(lambda,13)*(855429120. + 167620224.*nu + 13651264.*std::pow(nu,2) + 591480.*std::pow(nu,3) + 14380.*std::pow(nu,4) + 186.*std::pow(nu,5) + std::pow(nu,6)) + 50388.*std::pow(lambda,12)*(20530298880. + 4878314496.*nu + 495250560.*std::pow(nu,2) + 27846784.*std::pow(nu,3) + 936600.*std::pow(nu,4) + 18844.*std::pow(nu,5) + 210.*std::pow(nu,6) + std::pow(nu,7)) + 75582.*std::pow(lambda,11)*(451666575360. + 127853217792.*nu + 15773826816.*std::pow(nu,2) + 1107879808.*std::pow(nu,3) + 48451984.*std::pow(nu,4) + 1351168.*std::pow(nu,5) + 23464.*std::pow(nu,6) + 232.*std::pow(nu,7) + std::pow(nu,8)) + 92378.*std::pow(lambda,10)*(9033331507200. + 3008730931200.*nu + 443329754112.*std::pow(nu,2) + 37931422976.*std::pow(nu,3) + 2076919488.*std::pow(nu,4) + 75475344.*std::pow(nu,5) + 1820448.*std::pow(nu,6) + 28104.*std::pow(nu,7) + 252.*std::pow(nu,8) + std::pow(nu,9)) + 92378.*std::pow(lambda,9)*(162599967129600. + 63190488268800.*nu + 10988666505216.*std::pow(nu,2) + 1126095367680.*std::pow(nu,3) + 75315973760.*std::pow(nu,4) + 3435475680.*std::pow(nu,5) + 108243408.*std::pow(nu,6) + 2326320.*std::pow(nu,7) + 32640.*std::pow(nu,8) + 270.*std::pow(nu,9) + std::pow(nu,10)) + 75582.*std::pow(lambda,8)*(2601599474073600. + 1173647779430400.*nu + 239009152352256.*std::pow(nu,2) + 29006192388096.*std::pow(nu,3) + 2331150947840.*std::pow(nu,4) + 130283584640.*std::pow(nu,5) + 5167370208.*std::pow(nu,6) + 145464528.*std::pow(nu,7) + 2848560.*std::pow(nu,8) + 36960.*std::pow(nu,9) + 286.*std::pow(nu,10) + std::pow(nu,11)) + 50388.*std::pow(lambda,7)*(36422392637030400. + 19032668386099200.*nu + 4519775912361984.*std::pow(nu,2) + 645095845785600.*std::pow(nu,3) + 61642305657856.*std::pow(nu,4) + 4155121132800.*std::pow(nu,5) + 202626767552.*std::pow(nu,6) + 7203873600.*std::pow(nu,7) + 185344368.*std::pow(nu,8) + 3366000.*std::pow(nu,9) + 40964.*std::pow(nu,10) + 300.*std::pow(nu,11) + std::pow(nu,12)) + 27132.*std::pow(lambda,6)*(437068711644364800. + 264814413270220800.*nu + 73269979334443008.*std::pow(nu,2) + 12260926061789184.*std::pow(nu,3) + 1384803513679872.*std::pow(nu,4) + 111503759251456.*std::pow(nu,5) + 6586642343424.*std::pow(nu,6) + 289073250752.*std::pow(nu,7) + 9428006016.*std::pow(nu,8) + 225736368.*std::pow(nu,9) + 3857568.*std::pow(nu,10) + 44564.*std::pow(nu,11) + 312.*std::pow(nu,12) + std::pow(nu,13)) + 11628.*std::pow(lambda,5)*(4370687116443648000. + 3085212844346572800.*nu + 997514206614650880.*std::pow(nu,2) + 195879239952334848.*std::pow(nu,3) + 26108961198587904.*std::pow(nu,4) + 2499841106194432.*std::pow(nu,5) + 177370182685696.*std::pow(nu,6) + 9477374850944.*std::pow(nu,7) + 383353310912.*std::pow(nu,8) + 11685369696.*std::pow(nu,9) + 264312048.*std::pow(nu,10) + 4303208.*std::pow(nu,11) + 47684.*std::pow(nu,12) + 322.*std::pow(nu,13) + std::pow(nu,14)) + 3876.*std::pow(lambda,4)*(34965496931549184000. + 29052389871216230400.*nu + 11065326497263779840.*std::pow(nu,2) + 2564548126233329664.*std::pow(nu,3) + 404750929541038080.*std::pow(nu,4) + 46107690048143360.*std::pow(nu,5) + 3918802567680000.*std::pow(nu,6) + 253189181493248.*std::pow(nu,7) + 12544201338240.*std::pow(nu,8) + 476836268480.*std::pow(nu,9) + 13799866080.*std::pow(nu,10) + 298737712.*std::pow(nu,11) + 4684680.*std::pow(nu,12) + 50260.*std::pow(nu,13) + 330.*std::pow(nu,14) + std::pow(nu,15)) + 969.*std::pow(lambda,3)*(209792981589295104000. + 209279836158846566400.*nu + 95444348854798909440.*std::pow(nu,2) + 26452615254663757824.*std::pow(nu,3) + 4993053703479558144.*std::pow(nu,4) + 681397069829898240.*std::pow(nu,5) + 69620505454223360.*std::pow(nu,6) + 5437937656639488.*std::pow(nu,7) + 328454389522688.*std::pow(nu,8) + 15405218949120.*std::pow(nu,9) + 559635464960.*std::pow(nu,10) + 15592292352.*std::pow(nu,11) + 326845792.*std::pow(nu,12) + 4986240.*std::pow(nu,13) + 52240.*std::pow(nu,14) + 336.*std::pow(nu,15) + std::pow(nu,16)) + 171.*std::pow(lambda,2)*(839171926357180416000. + 1046912326224681369600.*nu + 591057231578042204160.*std::pow(nu,2) + 201254809873453940736.*std::pow(nu,3) + 46424830068581990400.*std::pow(nu,4) + 7718641982799151104.*std::pow(nu,5) + 959879091646791680.*std::pow(nu,6) + 91372256080781312.*std::pow(nu,7) + 6751755214730240.*std::pow(nu,8) + 390075265319168.*std::pow(nu,9) + 17643760808960.*std::pow(nu,10) + 622004634368.*std::pow(nu,11) + 16899675520.*std::pow(nu,12) + 346790752.*std::pow(nu,13) + 5195200.*std::pow(nu,14) + 53584.*std::pow(nu,15) + 340.*std::pow(nu,16) + std::pow(nu,17)) + 19.*lambda*(1678343852714360832000. + 2932996578806543155200.*nu + 2229026789380765777920.*std::pow(nu,2) + 993566851324950085632.*std::pow(nu,3) + 294104470010617921536.*std::pow(nu,4) + 61862114034180292608.*std::pow(nu,5) + 9638400166092734464.*std::pow(nu,6) + 1142623603808354304.*std::pow(nu,7) + 104875766510241792.*std::pow(nu,8) + 7531905745368576.*std::pow(nu,9) + 425362786937088.*std::pow(nu,10) + 18887770077696.*std::pow(nu,11) + 655803985408.*std::pow(nu,12) + 17593257024.*std::pow(nu,13) + 357181152.*std::pow(nu,14) + 5302368.*std::pow(nu,15) + 54264.*std::pow(nu,16) + 342.*std::pow(nu,17) + std::pow(nu,18)) + nu*(1678343852714360832000. + 2932996578806543155200.*nu + 2229026789380765777920.*std::pow(nu,2) + 993566851324950085632.*std::pow(nu,3) + 294104470010617921536.*std::pow(nu,4) + 61862114034180292608.*std::pow(nu,5) + 9638400166092734464.*std::pow(nu,6) + 1142623603808354304.*std::pow(nu,7) + 104875766510241792.*std::pow(nu,8) + 7531905745368576.*std::pow(nu,9) + 425362786937088.*std::pow(nu,10) + 18887770077696.*std::pow(nu,11) + 655803985408.*std::pow(nu,12) + 17593257024.*std::pow(nu,13) + 357181152.*std::pow(nu,14) + 5302368.*std::pow(nu,15) + 54264.*std::pow(nu,16) + 342.*std::pow(nu,17) + std::pow(nu,18)));
        moment_(20, std::pow(lambda,20) + 20.*std::pow(lambda,19)*(38. + nu) + 190.*std::pow(lambda,18)*(1368. + 74.*nu + std::pow(nu,2)) + 1140.*std::pow(lambda,17)*(46512. + 3884.*nu + 108.*std::pow(nu,2) + std::pow(nu,3)) + 4845.*std::pow(lambda,16)*(1488384. + 170800.*nu + 7340.*std::pow(nu,2) + 140.*std::pow(nu,3) + std::pow(nu,4)) + 15504.*std::pow(lambda,15)*(44651520. + 6612384.*nu + 391000.*std::pow(nu,2) + 11540.*std::pow(nu,3) + 170.*std::pow(nu,4) + std::pow(nu,5)) + 38760.*std::pow(lambda,14)*(1250242560. + 229798272.*nu + 17560384.*std::pow(nu,2) + 714120.*std::pow(nu,3) + 16300.*std::pow(nu,4) + 198.*std::pow(nu,5) + std::pow(nu,6)) + 77520.*std::pow(lambda,13)*(32506306560. + 7224997632.*nu + 686368256.*std::pow(nu,2) + 36127504.*std::pow(nu,3) + 1137920.*std::pow(nu,4) + 21448.*std::pow(nu,5) + 224.*std::pow(nu,6) + std::pow(nu,7)) + 125970.*std::pow(lambda,12)*(780151357440. + 205906249728.*nu + 23697835776.*std::pow(nu,2) + 1553428352.*std::pow(nu,3) + 63437584.*std::pow(nu,4) + 1652672.*std::pow(nu,5) + 26824.*std::pow(nu,6) + 248.*std::pow(nu,7) + std::pow(nu,8)) + 167960.*std::pow(lambda,11)*(17163329863680. + 5310088851456.*nu + 727258636800.*std::pow(nu,2) + 57873259520.*std::pow(nu,3) + 2949055200.*std::pow(nu,4) + 99796368.*std::pow(nu,5) + 2242800.*std::pow(nu,6) + 32280.*std::pow(nu,7) + 270.*std::pow(nu,8) + std::pow(nu,9)) + 184756.*std::pow(lambda,10)*(343266597273600. + 123365106892800.*nu + 19855261587456.*std::pow(nu,2) + 1884723827200.*std::pow(nu,3) + 116854363520.*std::pow(nu,4) + 4944982560.*std::pow(nu,5) + 144652368.*std::pow(nu,6) + 2888400.*std::pow(nu,7) + 37680.*std::pow(nu,8) + 290.*std::pow(nu,9) + std::pow(nu,10)) + 167960.*std::pow(lambda,9)*(6178798750924800. + 2563838521344000.*nu + 480759815467008.*std::pow(nu,2) + 53780290477056.*std::pow(nu,3) + 3988102370560.*std::pow(nu,4) + 205864049600.*std::pow(nu,5) + 7548725184.*std::pow(nu,6) + 196643568.*std::pow(nu,7) + 3566640.*std::pow(nu,8) + 42900.*std::pow(nu,9) + 308.*std::pow(nu,10) + std::pow(nu,11)) + 125970.*std::pow(lambda,8)*(98860780014796800. + 47200215092428800.*nu + 10255995568816128.*std::pow(nu,2) + 1341244463099904.*std::pow(nu,3) + 117589928406016.*std::pow(nu,4) + 7281927164160.*std::pow(nu,5) + 326643652544.*std::pow(nu,6) + 10695022272.*std::pow(nu,7) + 253709808.*std::pow(nu,8) + 4253040.*std::pow(nu,9) + 47828.*std::pow(nu,10) + 324.*std::pow(nu,11) + std::pow(nu,12)) + 77520.*std::pow(lambda,7)*(1384050920207155200. + 759663791308800000.*nu + 190784153055854592.*std::pow(nu,2) + 29033418052214784.*std::pow(nu,3) + 2987503460784128.*std::pow(nu,4) + 219536908704256.*std::pow(nu,5) + 11854938299776.*std::pow(nu,6) + 476373964352.*std::pow(nu,7) + 14246959584.*std::pow(nu,8) + 313252368.*std::pow(nu,9) + 4922632.*std::pow(nu,10) + 52364.*std::pow(nu,11) + 338.*std::pow(nu,12) + std::pow(nu,13)) + 38760.*std::pow(lambda,6)*(16608611042485862400. + 10500016415912755200.*nu + 3049073627979055104.*std::pow(nu,2) + 539185169682432000.*std::pow(nu,3) + 64883459581624320.*std::pow(nu,4) + 5621946365235200.*std::pow(nu,5) + 361796168301568.*std::pow(nu,6) + 17571425872000.*std::pow(nu,7) + 647337479360.*std::pow(nu,8) + 18005988000.*std::pow(nu,9) + 372323952.*std::pow(nu,10) + 5551000.*std::pow(nu,11) + 56420.*std::pow(nu,12) + 350.*std::pow(nu,13) + std::pow(nu,14)) + 15504.*std::pow(lambda,5)*(166086110424858624000. + 121608775201613414400.*nu + 40990752695703306240.*std::pow(nu,2) + 8440925324803375104.*std::pow(nu,3) + 1188019765498675200.*std::pow(nu,4) + 121102923233976320.*std::pow(nu,5) + 9239908048250880.*std::pow(nu,6) + 537510427021568.*std::pow(nu,7) + 24044800665600.*std::pow(nu,8) + 827397359360.*std::pow(nu,9) + 21729227520.*std::pow(nu,10) + 427833952.*std::pow(nu,11) + 6115200.*std::pow(nu,12) + 59920.*std::pow(nu,13) + 360.*std::pow(nu,14) + std::pow(nu,15)) + 4845.*std::pow(lambda,4)*(1328688883398868992000. + 1138956312037765939200.*nu + 449534796767239864320.*std::pow(nu,2) + 108518155294130307072.*std::pow(nu,3) + 17945083448792776704.*std::pow(nu,4) + 2156843151370485760.*std::pow(nu,5) + 195022187619983360.*std::pow(nu,6) + 13539991464423424.*std::pow(nu,7) + 729868832346368.*std::pow(nu,8) + 30663979540480.*std::pow(nu,9) + 1001231179520.*std::pow(nu,10) + 25151899136.*std::pow(nu,11) + 476755552.*std::pow(nu,12) + 6594560.*std::pow(nu,13) + 62800.*std::pow(nu,14) + 368.*std::pow(nu,15) + std::pow(nu,16)) + 1140.*std::pow(lambda,3)*(7972133300393213952000. + 8162426755625464627200.*nu + 3836165092641205125120.*std::pow(nu,2) + 1100643728532021706752.*std::pow(nu,3) + 216188655986886967296.*std::pow(nu,4) + 30886142357015691264.*std::pow(nu,5) + 3326976277090385920.*std::pow(nu,6) + 276262136406523904.*std::pow(nu,7) + 17919204458501632.*std::pow(nu,8) + 913852709589248.*std::pow(nu,9) + 36671366617600.*std::pow(nu,10) + 1152142574336.*std::pow(nu,11) + 28012432448.*std::pow(nu,12) + 516322912.*std::pow(nu,13) + 6971360.*std::pow(nu,14) + 65008.*std::pow(nu,15) + 374.*std::pow(nu,16) + std::pow(nu,17)) + 190.*std::pow(lambda,2)*(31888533201572855808000. + 40621840322895072460800.*nu + 23507087126190285127680.*std::pow(nu,2) + 8238740006769291952128.*std::pow(nu,3) + 1965398352479569575936.*std::pow(nu,4) + 339733225414949732352.*std::pow(nu,5) + 44194047465377234944.*std::pow(nu,6) + 4432024822716481536.*std::pow(nu,7) + 347938954240530432.*std::pow(nu,8) + 21574615296858624.*std::pow(nu,9) + 1060538176059648.*std::pow(nu,10) + 41279936914944.*std::pow(nu,11) + 1264192304128.*std::pow(nu,12) + 30077724096.*std::pow(nu,13) + 544208352.*std::pow(nu,14) + 7231392.*std::pow(nu,15) + 66504.*std::pow(nu,16) + 378.*std::pow(nu,17) + std::pow(nu,18)) + 20.*lambda*(63777066403145711616000. + 113132213847363000729600.*nu + 87636014575275642716160.*std::pow(nu,2) + 39984567139728869031936.*std::pow(nu,3) + 12169536711728431104000.*std::pow(nu,4) + 2644864803309469040640.*std::pow(nu,5) + 428121320345704202240.*std::pow(nu,6) + 53058097110810198016.*std::pow(nu,7) + 5127902731197542400.*std::pow(nu,8) + 391088184834247680.*std::pow(nu,9) + 23695691648977920.*std::pow(nu,10) + 1143098049889536.*std::pow(nu,11) + 43808321523200.*std::pow(nu,12) + 1324347752320.*std::pow(nu,13) + 31166140800.*std::pow(nu,14) + 558671136.*std::pow(nu,15) + 7364400.*std::pow(nu,16) + 67260.*std::pow(nu,17) + 380.*std::pow(nu,18) + std::pow(nu,19)) + nu*(63777066403145711616000. + 113132213847363000729600.*nu + 87636014575275642716160.*std::pow(nu,2) + 39984567139728869031936.*std::pow(nu,3) + 12169536711728431104000.*std::pow(nu,4) + 2644864803309469040640.*std::pow(nu,5) + 428121320345704202240.*std::pow(nu,6) + 53058097110810198016.*std::pow(nu,7) + 5127902731197542400.*std::pow(nu,8) + 391088184834247680.*std::pow(nu,9) + 23695691648977920.*std::pow(nu,10) + 1143098049889536.*std::pow(nu,11) + 43808321523200.*std::pow(nu,12) + 1324347752320.*std::pow(nu,13) + 31166140800.*std::pow(nu,14) + 558671136.*std::pow(nu,15) + 7364400.*std::pow(nu,16) + 67260.*std::pow(nu,17) + 380.*std::pow(nu,18) + std::pow(nu,19)));
        moment_(21, std::pow(lambda,21) + 21.*std::pow(lambda,20)*(40. + nu) + 210.*std::pow(lambda,19)*(1520. + 78.*nu + std::pow(nu,2)) + 1330.*std::pow(lambda,18)*(54720. + 4328.*nu + 114.*std::pow(nu,2) + std::pow(nu,3)) + 5985.*std::pow(lambda,17)*(1860480. + 201872.*nu + 8204.*std::pow(nu,2) + 148.*std::pow(nu,3) + std::pow(nu,4)) + 20349.*std::pow(lambda,16)*(59535360. + 8320384.*nu + 464400.*std::pow(nu,2) + 12940.*std::pow(nu,3) + 180.*std::pow(nu,4) + std::pow(nu,5)) + 54264.*std::pow(lambda,15)*(1786060800. + 309146880.*nu + 22252384.*std::pow(nu,2) + 852600.*std::pow(nu,3) + 18340.*std::pow(nu,4) + 210.*std::pow(nu,5) + std::pow(nu,6)) + 116280.*std::pow(lambda,14)*(50009702400. + 10442173440.*nu + 932213632.*std::pow(nu,2) + 46125184.*std::pow(nu,3) + 1366120.*std::pow(nu,4) + 24220.*std::pow(nu,5) + 238.*std::pow(nu,6) + std::pow(nu,7)) + 203490.*std::pow(lambda,13)*(1300252262400. + 321506211840.*nu + 34679727872.*std::pow(nu,2) + 2131468416.*std::pow(nu,3) + 81644304.*std::pow(nu,4) + 1995840.*std::pow(nu,5) + 30408.*std::pow(nu,6) + 264.*std::pow(nu,7) + std::pow(nu,8)) + 293930.*std::pow(lambda,12)*(31206054297600. + 9016401346560.*nu + 1153819680768.*std::pow(nu,2) + 85834969856.*std::pow(nu,3) + 4090931712.*std::pow(nu,4) + 129544464.*std::pow(nu,5) + 2725632.*std::pow(nu,6) + 36744.*std::pow(nu,7) + 288.*std::pow(nu,8) + std::pow(nu,9)) + 352716.*std::pow(lambda,11)*(686533194547200. + 229566883921920.*nu + 34400434323456.*std::pow(nu,2) + 3042189017600.*std::pow(nu,3) + 175835467520.*std::pow(nu,4) + 6940909920.*std::pow(nu,5) + 189508368.*std::pow(nu,6) + 3534000.*std::pow(nu,7) + 43080.*std::pow(nu,8) + 310.*std::pow(nu,9) + std::pow(nu,10)) + 352716.*std::pow(lambda,10)*(13730663890944000. + 5277870872985600.*nu + 917575570391040.*std::pow(nu,2) + 95244214675456.*std::pow(nu,3) + 6558898368000.*std::pow(nu,4) + 314653665920.*std::pow(nu,5) + 10731077280.*std::pow(nu,6) + 260188368.*std::pow(nu,7) + 4395600.*std::pow(nu,8) + 49280.*std::pow(nu,9) + 330.*std::pow(nu,10) + std::pow(nu,11)) + 293930.*std::pow(lambda,9)*(247151950036992000. + 108732339604684800.*nu + 21794231140024320.*std::pow(nu,2) + 2631971434549248.*std::pow(nu,3) + 213304385299456.*std::pow(nu,4) + 12222664354560.*std::pow(nu,5) + 507813056960.*std::pow(nu,6) + 15414467904.*std::pow(nu,7) + 339309168.*std::pow(nu,8) + 5282640.*std::pow(nu,9) + 55220.*std::pow(nu,10) + 348.*std::pow(nu,11) + std::pow(nu,12)) + 203490.*std::pow(lambda,8)*(3954431200591872000. + 1986869383711948800.*nu + 457440037845073920.*std::pow(nu,2) + 63905774092812288.*std::pow(nu,3) + 6044841599340544.*std::pow(nu,4) + 408867014972416.*std::pow(nu,5) + 20347673265920.*std::pow(nu,6) + 754444543424.*std::pow(nu,7) + 20843414592.*std::pow(nu,8) + 423831408.*std::pow(nu,9) + 6166160.*std::pow(nu,10) + 60788.*std::pow(nu,11) + 364.*std::pow(nu,12) + std::pow(nu,13)) + 116280.*std::pow(lambda,7)*(55362036808286208000. + 31770602572559155200.*nu + 8391029913542983680.*std::pow(nu,2) + 1352120875144445952.*std::pow(nu,3) + 148533556483579904.*std::pow(nu,4) + 11768979808954368.*std::pow(nu,5) + 693734440695296.*std::pow(nu,6) + 30909896873856.*std::pow(nu,7) + 1046252347712.*std::pow(nu,8) + 26777054304.*std::pow(nu,9) + 510157648.*std::pow(nu,10) + 7017192.*std::pow(nu,11) + 65884.*std::pow(nu,12) + 378.*std::pow(nu,13) + std::pow(nu,14)) + 54264.*std::pow(lambda,6)*(664344441699434496000. + 436609267678996070400.*nu + 132462961535074959360.*std::pow(nu,2) + 24616480415276335104.*std::pow(nu,3) + 3134523552947404800.*std::pow(nu,4) + 289761314191032320.*std::pow(nu,5) + 20093793097297920.*std::pow(nu,6) + 1064653203181568.*std::pow(nu,7) + 43464925046400.*std::pow(nu,8) + 1367576999360.*std::pow(nu,9) + 32898946080.*std::pow(nu,10) + 594363952.*std::pow(nu,11) + 7807800.*std::pow(nu,12) + 70420.*std::pow(nu,13) + 390.*std::pow(nu,14) + std::pow(nu,15)) + 20349.*std::pow(lambda,5)*(6643444416994344960000. + 5030437118489395200000.*nu + 1761238883029745664000.*std::pow(nu,2) + 378627765687838310400.*std::pow(nu,3) + 55961715944750383104.*std::pow(nu,4) + 6032136694857728000.*std::pow(nu,5) + 490699245164011520.*std::pow(nu,6) + 30740325129113600.*std::pow(nu,7) + 1499302453645568.*std::pow(nu,8) + 57140695040000.*std::pow(nu,9) + 1696566460160.*std::pow(nu,10) + 38842585600.*std::pow(nu,11) + 672441952.*std::pow(nu,12) + 8512000.*std::pow(nu,13) + 74320.*std::pow(nu,14) + 400.*std::pow(nu,15) + std::pow(nu,16)) + 5985.*std::pow(lambda,4)*(53147555335954759680000. + 46886941364909506560000.*nu + 19120348182727360512000.*std::pow(nu,2) + 4790261008532452147200.*std::pow(nu,3) + 826321493245841375232.*std::pow(nu,4) + 104218809503612207104.*std::pow(nu,5) + 9957730656169820160.*std::pow(nu,6) + 736621846196920320.*std::pow(nu,7) + 42734744758278144.*std::pow(nu,8) + 1956428013965568.*std::pow(nu,9) + 70713226721280.*std::pow(nu,10) + 2007307144960.*std::pow(nu,11) + 44222121216.*std::pow(nu,12) + 740537952.*std::pow(nu,13) + 9106560.*std::pow(nu,14) + 77520.*std::pow(nu,15) + 408.*std::pow(nu,16) + std::pow(nu,17)) + 1330.*std::pow(lambda,3)*(318885332015728558080000. + 334469203525411799040000.*nu + 161609030461273669632000.*std::pow(nu,2) + 47861914233922073395200.*std::pow(nu,3) + 9748189968007500398592.*std::pow(nu,4) + 1451634350267514617856.*std::pow(nu,5) + 163965193440631128064.*std::pow(nu,6) + 14377461733351342080.*std::pow(nu,7) + 993030314746589184.*std::pow(nu,8) + 54473312842071552.*std::pow(nu,9) + 2380707374293248.*std::pow(nu,10) + 82757069591040.*std::pow(nu,11) + 2272639872256.*std::pow(nu,12) + 48665348928.*std::pow(nu,13) + 795177312.*std::pow(nu,14) + 9571680.*std::pow(nu,15) + 79968.*std::pow(nu,16) + 414.*std::pow(nu,17) + std::pow(nu,18)) + 210.*std::pow(lambda,2)*(1275541328062914232320000. + 1656762146117375754240000.*nu + 980905325370506477568000.*std::pow(nu,2) + 353056687396961963212800.*std::pow(nu,3) + 86854674105952074989568.*std::pow(nu,4) + 15554727369077558870016.*std::pow(nu,5) + 2107495124030039130112.*std::pow(nu,6) + 221475040374036496384.*std::pow(nu,7) + 18349582992337698816.*std::pow(nu,8) + 1210923566114875392.*std::pow(nu,9) + 63996142339244544.*std::pow(nu,10) + 2711735652657408.*std::pow(nu,11) + 91847629080064.*std::pow(nu,12) + 2467301267968.*std::pow(nu,13) + 51846058176.*std::pow(nu,14) + 833464032.*std::pow(nu,15) + 9891552.*std::pow(nu,16) + 81624.*std::pow(nu,17) + 418.*std::pow(nu,18) + std::pow(nu,19)) + 21.*lambda*(2551082656125828464640000. + 4589065620297665740800000.*nu + 3618572796858388709376000.*std::pow(nu,2) + 1687018700164430403993600.*std::pow(nu,3) + 526766035608866113191936.*std::pow(nu,4) + 117964128844107192729600.*std::pow(nu,5) + 19769717617137637130240.*std::pow(nu,6) + 2550445204778112122880.*std::pow(nu,7) + 258174206358711894016.*std::pow(nu,8) + 20771430124567449600.*std::pow(nu,9) + 1338915850793364480.*std::pow(nu,10) + 69419613644559360.*std::pow(nu,11) + 2895430910817536.*std::pow(nu,12) + 96782231616000.*std::pow(nu,13) + 2570993384320.*std::pow(nu,14) + 53512986240.*std::pow(nu,15) + 853247136.*std::pow(nu,16) + 10054800.*std::pow(nu,17) + 82460.*std::pow(nu,18) + 420.*std::pow(nu,19) + std::pow(nu,20)) + nu*(2551082656125828464640000. + 4589065620297665740800000.*nu + 3618572796858388709376000.*std::pow(nu,2) + 1687018700164430403993600.*std::pow(nu,3) + 526766035608866113191936.*std::pow(nu,4) + 117964128844107192729600.*std::pow(nu,5) + 19769717617137637130240.*std::pow(nu,6) + 2550445204778112122880.*std::pow(nu,7) + 258174206358711894016.*std::pow(nu,8) + 20771430124567449600.*std::pow(nu,9) + 1338915850793364480.*std::pow(nu,10) + 69419613644559360.*std::pow(nu,11) + 2895430910817536.*std::pow(nu,12) + 96782231616000.*std::pow(nu,13) + 2570993384320.*std::pow(nu,14) + 53512986240.*std::pow(nu,15) + 853247136.*std::pow(nu,16) + 10054800.*std::pow(nu,17) + 82460.*std::pow(nu,18) + 420.*std::pow(nu,19) + std::pow(nu,20)));
        moment_(22, std::pow(lambda,22) + 22.*std::pow(lambda,21)*(42. + nu) + 231.*std::pow(lambda,20)*(1680. + 82.*nu + std::pow(nu,2)) + 1540.*std::pow(lambda,19)*(63840. + 4796.*nu + 120.*std::pow(nu,2) + std::pow(nu,3)) + 7315.*std::pow(lambda,18)*(2298240. + 236496.*nu + 9116.*std::pow(nu,2) + 156.*std::pow(nu,3) + std::pow(nu,4)) + 26334.*std::pow(lambda,17)*(78140160. + 10339104.*nu + 546440.*std::pow(nu,2) + 14420.*std::pow(nu,3) + 190.*std::pow(nu,4) + std::pow(nu,5)) + 74613.*std::pow(lambda,16)*(2500485120. + 408991488.*nu + 27825184.*std::pow(nu,2) + 1007880.*std::pow(nu,3) + 20500.*std::pow(nu,4) + 222.*std::pow(nu,5) + std::pow(nu,6)) + 170544.*std::pow(lambda,15)*(75014553600. + 14770229760.*nu + 1243747008.*std::pow(nu,2) + 58061584.*std::pow(nu,3) + 1622880.*std::pow(nu,4) + 27160.*std::pow(nu,5) + 252.*std::pow(nu,6) + std::pow(nu,7)) + 319770.*std::pow(lambda,14)*(2100407500800. + 488580986880.*nu + 49595145984.*std::pow(nu,2) + 2869471360.*std::pow(nu,3) + 103502224.*std::pow(nu,4) + 2383360.*std::pow(nu,5) + 34216.*std::pow(nu,6) + 280.*std::pow(nu,7) + std::pow(nu,8)) + 497420.*std::pow(lambda,13)*(54610595020800. + 14803513159680.*nu + 1778054782464.*std::pow(nu,2) + 124201401344.*std::pow(nu,3) + 5560529184.*std::pow(nu,4) + 165469584.*std::pow(nu,5) + 3272976.*std::pow(nu,6) + 41496.*std::pow(nu,7) + 306.*std::pow(nu,8) + std::pow(nu,9)) + 646646.*std::pow(lambda,12)*(1310654280499200. + 409894910853120.*nu + 57476827938816.*std::pow(nu,2) + 4758888414720.*std::pow(nu,3) + 257654101760.*std::pow(nu,4) + 9531799200.*std::pow(nu,5) + 244021008.*std::pow(nu,6) + 4268880.*std::pow(nu,7) + 48840.*std::pow(nu,8) + 330.*std::pow(nu,9) + std::pow(nu,10)) + 705432.*std::pow(lambda,11)*(28834394170982400. + 10328342319267840.*nu + 1674385125507072.*std::pow(nu,2) + 162172373062656.*std::pow(nu,3) + 10427278653440.*std::pow(nu,4) + 467353684160.*std::pow(nu,5) + 14900261376.*std::pow(nu,6) + 337936368.*std::pow(nu,7) + 5343360.*std::pow(nu,8) + 56100.*std::pow(nu,9) + 352.*std::pow(nu,10) + std::pow(nu,11)) + 646646.*std::pow(lambda,10)*(576687883419648000. + 235401240556339200.*nu + 43816044829409280.*std::pow(nu,2) + 4917832586760192.*std::pow(nu,3) + 370717946131456.*std::pow(nu,4) + 19774352336640.*std::pow(nu,5) + 765358911680.*std::pow(nu,6) + 21658988736.*std::pow(nu,7) + 444803568.*std::pow(nu,8) + 6465360.*std::pow(nu,9) + 63140.*std::pow(nu,10) + 372.*std::pow(nu,11) + std::pow(nu,12)) + 497420.*std::pow(lambda,9)*(10380381901553664000. + 4813910213433753600.*nu + 1024090047485706240.*std::pow(nu,2) + 132337031391092736.*std::pow(nu,3) + 11590755617126400.*std::pow(nu,4) + 726656288190976.*std::pow(nu,5) + 33550812746880.*std::pow(nu,6) + 1155220708928.*std::pow(nu,7) + 29665452960.*std::pow(nu,8) + 561180048.*std::pow(nu,9) + 7601880.*std::pow(nu,10) + 69836.*std::pow(nu,11) + 390.*std::pow(nu,12) + std::pow(nu,13)) + 319770.*std::pow(lambda,8)*(166086110424858624000. + 87402945316493721600.*nu + 21199350973205053440.*std::pow(nu,2) + 3141482549743190016.*std::pow(nu,3) + 317789121265115136.*std::pow(nu,4) + 23217256228182016.*std::pow(nu,5) + 1263469292141056.*std::pow(nu,6) + 52034344089728.*std::pow(nu,7) + 1629867956288.*std::pow(nu,8) + 38644333728.*std::pow(nu,9) + 682810128.*std::pow(nu,10) + 8719256.*std::pow(nu,11) + 76076.*std::pow(nu,12) + 406.*std::pow(nu,13) + std::pow(nu,14)) + 170544.*std::pow(lambda,7)*(2325205545948020736000. + 1389727344855770726400.*nu + 384193858941364469760.*std::pow(nu,2) + 65180106669609713664.*std::pow(nu,3) + 7590530247454801920.*std::pow(nu,4) + 642830708459663360.*std::pow(nu,5) + 40905826318156800.*std::pow(nu,6) + 1991950109397248.*std::pow(nu,7) + 74852495477760.*std::pow(nu,8) + 2170888628480.*std::pow(nu,9) + 48203675520.*std::pow(nu,10) + 804879712.*std::pow(nu,11) + 9784320.*std::pow(nu,12) + 81760.*std::pow(nu,13) + 420.*std::pow(nu,14) + std::pow(nu,15)) + 74613.*std::pow(lambda,6)*(27902466551376248832000. + 19001933684217269452800.*nu + 6000053652152144363520.*std::pow(nu,2) + 1166355138976681033728.*std::pow(nu,3) + 156266469639067336704.*std::pow(nu,4) + 15304498748970762240.*std::pow(nu,5) + 1133700624277544960.*std::pow(nu,6) + 64809227630923776.*std::pow(nu,7) + 2890180055130368.*std::pow(nu,8) + 100903159019520.*std::pow(nu,9) + 2749332734720.*std::pow(nu,10) + 57862232064.*std::pow(nu,11) + 922291552.*std::pow(nu,12) + 10765440.*std::pow(nu,13) + 86800.*std::pow(nu,14) + 432.*std::pow(nu,15) + std::pow(nu,16)) + 26334.*std::pow(lambda,5)*(279024665513762488320000. + 217921803393548943360000.*nu + 79002470205738713088000.*std::pow(nu,2) + 17663605041918954700800.*std::pow(nu,3) + 2729019835367354400768.*std::pow(nu,4) + 309311457128774959104.*std::pow(nu,5) + 26641504991746211840.*std::pow(nu,6) + 1781792900586782720.*std::pow(nu,7) + 93711028182227456.*std::pow(nu,8) + 3899211645325568.*std::pow(nu,9) + 128396486366720.*std::pow(nu,10) + 3327955055360.*std::pow(nu,11) + 67085147584.*std::pow(nu,12) + 1029945952.*std::pow(nu,13) + 11633440.*std::pow(nu,14) + 91120.*std::pow(nu,15) + 442.*std::pow(nu,16) + std::pow(nu,17)) + 7315.*std::pow(lambda,4)*(2232197324110099906560000. + 2022399092662154035200000.*nu + 849941565039458648064000.*std::pow(nu,2) + 220311310541090350694400.*std::pow(nu,3) + 39495763724857789906944.*std::pow(nu,4) + 5203511492397554073600.*std::pow(nu,5) + 522443497062744653824.*std::pow(nu,6) + 40895848196440473600.*std::pow(nu,7) + 2531481126044602368.*std::pow(nu,8) + 124904721344832000.*std::pow(nu,9) + 4926383536259328.*std::pow(nu,10) + 155020126809600.*std::pow(nu,11) + 3864636236032.*std::pow(nu,12) + 75324715200.*std::pow(nu,13) + 1123013472.*std::pow(nu,14) + 12362400.*std::pow(nu,15) + 94656.*std::pow(nu,16) + 450.*std::pow(nu,17) + std::pow(nu,18)) + 1540.*std::pow(lambda,3)*(13393183944660599439360000. + 14366591880083024117760000.*nu + 7122048482898905923584000.*std::pow(nu,2) + 2171809428286000752230400.*std::pow(nu,3) + 457285892890237090136064.*std::pow(nu,4) + 70716832679243114348544.*std::pow(nu,5) + 8338172474774021996544.*std::pow(nu,6) + 767818586241387495424.*std::pow(nu,7) + 56084734952708087808.*std::pow(nu,8) + 3280909454113594368.*std::pow(nu,9) + 154463022562387968.*std::pow(nu,10) + 5856504297116928.*std::pow(nu,11) + 178207944225792.*std::pow(nu,12) + 4316584527232.*std::pow(nu,13) + 82062796032.*std::pow(nu,14) + 1197187872.*std::pow(nu,15) + 12930336.*std::pow(nu,16) + 97356.*std::pow(nu,17) + 456.*std::pow(nu,18) + std::pow(nu,19)) + 231.*std::pow(lambda,2)*(53572735778642397757440000. + 70859551464992695910400000.*nu + 42854785811678647812096000.*std::pow(nu,2) + 15809286196042908932505600.*std::pow(nu,3) + 4000952999846949112774656.*std::pow(nu,4) + 740153223607209547530240.*std::pow(nu,5) + 104069522578339202334720.*std::pow(nu,6) + 11409446819739571978240.*std::pow(nu,7) + 992157526052219846656.*std::pow(nu,8) + 69208372769162465280.*std::pow(nu,9) + 3898761544363146240.*std::pow(nu,10) + 177889039750855680.*std::pow(nu,11) + 6569336074020096.*std::pow(nu,12) + 195474282334720.*std::pow(nu,13) + 4644835711360.*std::pow(nu,14) + 86851547520.*std::pow(nu,15) + 1248909216.*std::pow(nu,16) + 13319760.*std::pow(nu,17) + 99180.*std::pow(nu,18) + 460.*std::pow(nu,19) + std::pow(nu,20)) + 22.*lambda*(107145471557284795514880000. + 195291838708627789578240000.*nu + 156569123088349991534592000.*std::pow(nu,2) + 74473358203764465677107200.*std::pow(nu,3) + 23811192195736807158054912.*std::pow(nu,4) + 5481259447061368207835136.*std::pow(nu,5) + 948292268763887952199680.*std::pow(nu,6) + 126888416217818346291200.*std::pow(nu,7) + 13393761871844011671552.*std::pow(nu,8) + 1130574271590544777216.*std::pow(nu,9) + 77005895857888757760.*std::pow(nu,10) + 4254539623864857600.*std::pow(nu,11) + 191027711898895872.*std::pow(nu,12) + 6960284638689536.*std::pow(nu,13) + 204763953757440.*std::pow(nu,14) + 4818538806400.*std::pow(nu,15) + 89349365952.*std::pow(nu,16) + 1275548736.*std::pow(nu,17) + 13518120.*std::pow(nu,18) + 100100.*std::pow(nu,19) + 462.*std::pow(nu,20) + std::pow(nu,21)) + nu*(107145471557284795514880000. + 195291838708627789578240000.*nu + 156569123088349991534592000.*std::pow(nu,2) + 74473358203764465677107200.*std::pow(nu,3) + 23811192195736807158054912.*std::pow(nu,4) + 5481259447061368207835136.*std::pow(nu,5) + 948292268763887952199680.*std::pow(nu,6) + 126888416217818346291200.*std::pow(nu,7) + 13393761871844011671552.*std::pow(nu,8) + 1130574271590544777216.*std::pow(nu,9) + 77005895857888757760.*std::pow(nu,10) + 4254539623864857600.*std::pow(nu,11) + 191027711898895872.*std::pow(nu,12) + 6960284638689536.*std::pow(nu,13) + 204763953757440.*std::pow(nu,14) + 4818538806400.*std::pow(nu,15) + 89349365952.*std::pow(nu,16) + 1275548736.*std::pow(nu,17) + 13518120.*std::pow(nu,18) + 100100.*std::pow(nu,19) + 462.*std::pow(nu,20) + std::pow(nu,21)));
        moment_(23, std::pow(lambda,23) + 23.*std::pow(lambda,22)*(44. + nu) + 253.*std::pow(lambda,21)*(1848. + 86.*nu + std::pow(nu,2)) + 1771.*std::pow(lambda,20)*(73920. + 5288.*nu + 126.*std::pow(nu,2) + std::pow(nu,3)) + 8855.*std::pow(lambda,19)*(2808960. + 274864.*nu + 10076.*std::pow(nu,2) + 164.*std::pow(nu,3) + std::pow(nu,4)) + 33649.*std::pow(lambda,18)*(101122560. + 12704064.*nu + 637600.*std::pow(nu,2) + 15980.*std::pow(nu,3) + 200.*std::pow(nu,4) + std::pow(nu,5)) + 100947.*std::pow(lambda,17)*(3438167040. + 533060736.*nu + 34382464.*std::pow(nu,2) + 1180920.*std::pow(nu,3) + 22780.*std::pow(nu,4) + 234.*std::pow(nu,5) + std::pow(nu,6)) + 245157.*std::pow(lambda,16)*(110021345280. + 20496110592.*nu + 1633299584.*std::pow(nu,2) + 72171904.*std::pow(nu,3) + 1909880.*std::pow(nu,4) + 30268.*std::pow(nu,5) + 266.*std::pow(nu,6) + std::pow(nu,7)) + 490314.*std::pow(lambda,15)*(3300640358400. + 724904663040.*nu + 69495098112.*std::pow(nu,2) + 3798456704.*std::pow(nu,3) + 129468304.*std::pow(nu,4) + 2817920.*std::pow(nu,5) + 38248.*std::pow(nu,6) + 296.*std::pow(nu,7) + std::pow(nu,8)) + 817190.*std::pow(lambda,14)*(92417930035200. + 23597970923520.*nu + 2670767410176.*std::pow(nu,2) + 175851885824.*std::pow(nu,3) + 7423569216.*std::pow(nu,4) + 208370064.*std::pow(nu,5) + 3888864.*std::pow(nu,6) + 46536.*std::pow(nu,7) + 324.*std::pow(nu,8) + std::pow(nu,9)) + 1144066.*std::pow(lambda,13)*(2402866180915200. + 705965174046720.*nu + 93037923588096.*std::pow(nu,2) + 7242916441600.*std::pow(nu,3) + 368864685440.*std::pow(nu,4) + 12841190880.*std::pow(nu,5) + 309480528.*std::pow(nu,6) + 5098800.*std::pow(nu,7) + 54960.*std::pow(nu,8) + 350.*std::pow(nu,9) + std::pow(nu,10)) + 1352078.*std::pow(lambda,12)*(57668788341964800. + 19346030358036480.*nu + 2938875340161024.*std::pow(nu,2) + 266867918186496.*std::pow(nu,3) + 16095668892160.*std::pow(nu,4) + 677053266560.*std::pow(nu,5) + 20268723552.*std::pow(nu,6) + 431851728.*std::pow(nu,7) + 6417840.*std::pow(nu,8) + 63360.*std::pow(nu,9) + 374.*std::pow(nu,10) + std::pow(nu,11)) + 1352078.*std::pow(lambda,11)*(1268713343523225600. + 483281456218767360.*nu + 84001287841579008.*std::pow(nu,2) + 8809969540263936.*std::pow(nu,3) + 620972633814016.*std::pow(nu,4) + 30990840756480.*std::pow(nu,5) + 1122965184704.*std::pow(nu,6) + 29769461568.*std::pow(nu,7) + 573044208.*std::pow(nu,8) + 7811760.*std::pow(nu,9) + 71588.*std::pow(nu,10) + 396.*std::pow(nu,11) + std::pow(nu,12)) + 1144066.*std::pow(lambda,10)*(25374266870464512000. + 10934342467898572800.*nu + 2163307213050347520.*std::pow(nu,2) + 260200678646857728.*std::pow(nu,3) + 21229422216544256.*std::pow(nu,4) + 1240789448943616.*std::pow(nu,5) + 53450144450560.*std::pow(nu,6) + 1718354416064.*std::pow(nu,7) + 41230345728.*std::pow(nu,8) + 729279408.*std::pow(nu,9) + 9243520.*std::pow(nu,10) + 79508.*std::pow(nu,11) + 416.*std::pow(nu,12) + std::pow(nu,13)) + 817190.*std::pow(lambda,9)*(456736803668361216000. + 222192431292638822400.*nu + 49873872302804828160.*std::pow(nu,2) + 6846919428693786624.*std::pow(nu,3) + 642330278544654336.*std::pow(nu,4) + 43563632297529344.*std::pow(nu,5) + 2202892049053696.*std::pow(nu,6) + 84380523939712.*std::pow(nu,7) + 2460500639168.*std::pow(nu,8) + 54357375072.*std::pow(nu,9) + 895662768.*std::pow(nu,10) + 10674664.*std::pow(nu,11) + 86996.*std::pow(nu,12) + 434.*std::pow(nu,13) + std::pow(nu,14)) + 490314.*std::pow(lambda,8)*(7307788858693779456000. + 4011815704350582374400.*nu + 1020174388137516072960.*std::pow(nu,2) + 159424583161905414144.*std::pow(nu,3) + 17124203885408256000.*std::pow(nu,4) + 1339348395305123840.*std::pow(nu,5) + 78809905082388480.*std::pow(nu,6) + 3552980432089088.*std::pow(nu,7) + 123748534166400.*std::pow(nu,8) + 3330218640320.*std::pow(nu,9) + 68687979360.*std::pow(nu,10) + 1066457392.*std::pow(nu,11) + 12066600.*std::pow(nu,12) + 93940.*std::pow(nu,13) + 450.*std::pow(nu,14) + std::pow(nu,15)) + 245157.*std::pow(lambda,7)*(102309044021712912384000. + 63473208719601932697600.*nu + 18294257138275807395840.*std::pow(nu,2) + 3252118552404191870976.*std::pow(nu,3) + 399163437557620998144.*std::pow(nu,4) + 35875081419679989760.*std::pow(nu,5) + 2442687066458562560.*std::pow(nu,6) + 128551631131635712.*std::pow(nu,7) + 5285459910418688.*std::pow(nu,8) + 170371595130880.*std::pow(nu,9) + 4291850351360.*std::pow(nu,10) + 83618382848.*std::pow(nu,11) + 1235389792.*std::pow(nu,12) + 13381760.*std::pow(nu,13) + 100240.*std::pow(nu,14) + 464.*std::pow(nu,15) + std::pow(nu,16)) + 100947.*std::pow(lambda,6)*(1227708528260554948608000. + 863987548656936104755200.*nu + 283004294378911621447680.*std::pow(nu,2) + 57319679767126109847552.*std::pow(nu,3) + 8042079803095643848704.*std::pow(nu,4) + 829664414593780875264.*std::pow(nu,5) + 65187326217182740480.*std::pow(nu,6) + 3985306640038191104.*std::pow(nu,7) + 191977150056659968.*std::pow(nu,8) + 7329919051989248.*std::pow(nu,9) + 221873799347200.*std::pow(nu,10) + 5295270945536.*std::pow(nu,11) + 98443060352.*std::pow(nu,12) + 1395970912.*std::pow(nu,13) + 14584640.*std::pow(nu,14) + 105808.*std::pow(nu,15) + 476.*std::pow(nu,16) + std::pow(nu,17)) + 33649.*std::pow(lambda,5)*(12277085282605549486080000. + 9867584014829915996160000.*nu + 3694030492446052319232000.*std::pow(nu,2) + 856201092050172719923200.*std::pow(nu,3) + 137740477798082548334592.*std::pow(nu,4) + 16338723949033452601344.*std::pow(nu,5) + 1481537676765608280064.*std::pow(nu,6) + 105040392617564651520.*std::pow(nu,7) + 5905078140604790784.*std::pow(nu,8) + 265276340576552448.*std::pow(nu,9) + 9548657045461248.*std::pow(nu,10) + 274826508802560.*std::pow(nu,11) + 6279701549056.*std::pow(nu,12) + 112402769472.*std::pow(nu,13) + 1541817312.*std::pow(nu,14) + 15642720.*std::pow(nu,15) + 110568.*std::pow(nu,16) + 486.*std::pow(nu,17) + std::pow(nu,18)) + 8855.*std::pow(lambda,4)*(98216682260844395888640000. + 91217757401244877455360000.*nu + 39419827954398334550016000.*std::pow(nu,2) + 10543639228847434078617600.*std::pow(nu,3) + 1958124914434833106599936.*std::pow(nu,4) + 268450269390350169145344.*std::pow(nu,5) + 28191025363158318841856.*std::pow(nu,6) + 2321860817706125492224.*std::pow(nu,7) + 152281017742402977792.*std::pow(nu,8) + 8027288865217210368.*std::pow(nu,9) + 341665596940242432.*std::pow(nu,10) + 11747269115881728.*std::pow(nu,11) + 325064121195008.*std::pow(nu,12) + 7178923704832.*std::pow(nu,13) + 124737307968.*std::pow(nu,14) + 1666959072.*std::pow(nu,15) + 16527264.*std::pow(nu,16) + 114456.*std::pow(nu,17) + 494.*std::pow(nu,18) + std::pow(nu,19)) + 1771.*std::pow(lambda,3)*(589300093565066375331840000. + 645523226668313660620800000.*nu + 327736725127634884755456000.*std::pow(nu,2) + 102681663327482939021721600.*std::pow(nu,3) + 22292388715456432718217216.*std::pow(nu,4) + 3568826530776934121472000.*std::pow(nu,5) + 437596421569300082196480.*std::pow(nu,6) + 42122190269395071795200.*std::pow(nu,7) + 3235546924160543358976.*std::pow(nu,8) + 200444750933706240000.*std::pow(nu,9) + 10077282446858664960.*std::pow(nu,10) + 412149211635532800.*std::pow(nu,11) + 13697653843051776.*std::pow(nu,12) + 368137663424000.*std::pow(nu,13) + 7927347552640.*std::pow(nu,14) + 134739062400.*std::pow(nu,15) + 1766122656.*std::pow(nu,16) + 17214000.*std::pow(nu,17) + 117420.*std::pow(nu,18) + 500.*std::pow(nu,19) + std::pow(nu,20)) + 253.*std::pow(lambda,2)*(2357200374260265501327360000. + 3171393000238321017815040000.*nu + 1956470127178853199642624000.*std::pow(nu,2) + 738463378437566640842342400.*std::pow(nu,3) + 191851218189308669894590464.*std::pow(nu,4) + 36567694838564169204105216.*std::pow(nu,5) + 5319212217054134450257920.*std::pow(nu,6) + 606085182646880369377280.*std::pow(nu,7) + 55064377966037245231104.*std::pow(nu,8) + 4037325927895368318976.*std::pow(nu,9) + 240753880721140899840.*std::pow(nu,10) + 11725879293400796160.*std::pow(nu,11) + 466939827007739904.*std::pow(nu,12) + 15170204496747776.*std::pow(nu,13) + 399847053634560.*std::pow(nu,14) + 8466303802240.*std::pow(nu,15) + 141803553024.*std::pow(nu,16) + 1834978656.*std::pow(nu,17) + 17683680.*std::pow(nu,18) + 119420.*std::pow(nu,19) + 504.*std::pow(nu,20) + std::pow(nu,21)) + 23.*lambda*(4714400748520531002654720000. + 8699986374736907536957440000.*nu + 7084333254596027417100288000.*std::pow(nu,2) + 3433396884053986481327308800.*std::pow(nu,3) + 1122165814816183980631523328.*std::pow(nu,4) + 264986607866437008302800896.*std::pow(nu,5) + 47206119272672438104621056.*std::pow(nu,6) + 6531382582347895189012480.*std::pow(nu,7) + 716213938578954859839488.*std::pow(nu,8) + 63139029821827981869056.*std::pow(nu,9) + 4518833689337650118656.*std::pow(nu,10) + 264205639307942492160.*std::pow(nu,11) + 12659758947416275968.*std::pow(nu,12) + 497280236001235456.*std::pow(nu,13) + 15969898604016896.*std::pow(nu,14) + 416779661239040.*std::pow(nu,15) + 8749910908288.*std::pow(nu,16) + 145473510336.*std::pow(nu,17) + 1870346016.*std::pow(nu,18) + 17922520.*std::pow(nu,19) + 120428.*std::pow(nu,20) + 506.*std::pow(nu,21) + std::pow(nu,22)) + nu*(4714400748520531002654720000. + 8699986374736907536957440000.*nu + 7084333254596027417100288000.*std::pow(nu,2) + 3433396884053986481327308800.*std::pow(nu,3) + 1122165814816183980631523328.*std::pow(nu,4) + 264986607866437008302800896.*std::pow(nu,5) + 47206119272672438104621056.*std::pow(nu,6) + 6531382582347895189012480.*std::pow(nu,7) + 716213938578954859839488.*std::pow(nu,8) + 63139029821827981869056.*std::pow(nu,9) + 4518833689337650118656.*std::pow(nu,10) + 264205639307942492160.*std::pow(nu,11) + 12659758947416275968.*std::pow(nu,12) + 497280236001235456.*std::pow(nu,13) + 15969898604016896.*std::pow(nu,14) + 416779661239040.*std::pow(nu,15) + 8749910908288.*std::pow(nu,16) + 145473510336.*std::pow(nu,17) + 1870346016.*std::pow(nu,18) + 17922520.*std::pow(nu,19) + 120428.*std::pow(nu,20) + 506.*std::pow(nu,21) + std::pow(nu,22)));
        moment_(24, std::pow(lambda,24) + 24.*std::pow(lambda,23)*(46. + nu) + 276.*std::pow(lambda,22)*(2024. + 90.*nu + std::pow(nu,2)) + 2024.*std::pow(lambda,21)*(85008. + 5804.*nu + 132.*std::pow(nu,2) + std::pow(nu,3)) + 10626.*std::pow(lambda,20)*(3400320. + 317168.*nu + 11084.*std::pow(nu,2) + 172.*std::pow(nu,3) + std::pow(nu,4)) + 42504.*std::pow(lambda,19)*(129212160. + 15452704.*nu + 738360.*std::pow(nu,2) + 17620.*std::pow(nu,3) + 210.*std::pow(nu,4) + std::pow(nu,5)) + 134596.*std::pow(lambda,18)*(4651637760. + 685509504.*nu + 42033664.*std::pow(nu,2) + 1372680.*std::pow(nu,3) + 25180.*std::pow(nu,4) + 246.*std::pow(nu,5) + std::pow(nu,6)) + 346104.*std::pow(lambda,17)*(158155683840. + 27958960896.*nu + 2114654080.*std::pow(nu,2) + 88704784.*std::pow(nu,3) + 2228800.*std::pow(nu,4) + 33544.*std::pow(nu,5) + 280.*std::pow(nu,6) + std::pow(nu,7)) + 735471.*std::pow(lambda,16)*(5060981882880. + 1052842432512.*nu + 95627891456.*std::pow(nu,2) + 4953207168.*std::pow(nu,3) + 160026384.*std::pow(nu,4) + 3302208.*std::pow(nu,5) + 42504.*std::pow(nu,6) + 312.*std::pow(nu,7) + std::pow(nu,8)) + 1307504.*std::pow(lambda,15)*(151829456486400. + 36646254858240.*nu + 3921679176192.*std::pow(nu,2) + 244224106496.*std::pow(nu,3) + 9753998688.*std::pow(nu,4) + 259092624.*std::pow(nu,5) + 4577328.*std::pow(nu,6) + 51864.*std::pow(nu,7) + 342.*std::pow(nu,8) + std::pow(nu,9)) + 1961256.*std::pow(lambda,14)*(4251224781619200. + 1177924592517120.*nu + 146453271791616.*std::pow(nu,2) + 10759954158080.*std::pow(nu,3) + 517336069760.*std::pow(nu,4) + 17008592160.*std::pow(nu,5) + 387257808.*std::pow(nu,6) + 6029520.*std::pow(nu,7) + 61440.*std::pow(nu,8) + 370.*std::pow(nu,9) + std::pow(nu,10)) + 2496144.*std::pow(lambda,13)*(110531844322099200. + 34877264187064320.*nu + 4985709659099136.*std::pow(nu,2) + 426212079901696.*std::pow(nu,3) + 24210691971840.*std::pow(nu,4) + 959559465920.*std::pow(nu,5) + 27077295168.*std::pow(nu,6) + 544025328.*std::pow(nu,7) + 7626960.*std::pow(nu,8) + 71060.*std::pow(nu,9) + 396.*std::pow(nu,10) + std::pow(nu,11)) + 2704156.*std::pow(lambda,12)*(2652764263730380800. + 947586184811642880.*nu + 154534296005443584.*std::pow(nu,2) + 15214799576739840.*std::pow(nu,3) + 1007268687225856.*std::pow(nu,4) + 47240119153920.*std::pow(nu,5) + 1609414549952.*std::pow(nu,6) + 40133903040.*std::pow(nu,7) + 727072368.*std::pow(nu,8) + 9332400.*std::pow(nu,9) + 80564.*std::pow(nu,10) + 420.*std::pow(nu,11) + std::pow(nu,12)) + 2496144.*std::pow(lambda,11)*(58360813802068377600. + 23499660329586524160.*nu + 4347340696931401728.*std::pow(nu,2) + 489259886693720064.*std::pow(nu,3) + 37374710695708672.*std::pow(nu,4) + 2046551308612096.*std::pow(nu,5) + 82647239252864.*std::pow(nu,6) + 2492360416832.*std::pow(nu,7) + 56129495136.*std::pow(nu,8) + 932385168.*std::pow(nu,9) + 11104808.*std::pow(nu,10) + 89804.*std::pow(nu,11) + 442.*std::pow(nu,12) + std::pow(nu,13)) + 1961256.*std::pow(lambda,10)*(1167216276041367552000. + 528354020393798860800.*nu + 110446474268214558720.*std::pow(nu,2) + 14132538430805803008.*std::pow(nu,3) + 1236754100607893504.*std::pow(nu,4) + 78305736867950592.*std::pow(nu,5) + 3699496093669376.*std::pow(nu,6) + 132494447589504.*std::pow(nu,7) + 3614950319552.*std::pow(nu,8) + 74777198496.*std::pow(nu,9) + 1154481328.*std::pow(nu,10) + 12900888.*std::pow(nu,11) + 98644.*std::pow(nu,12) + 462.*std::pow(nu,13) + std::pow(nu,14)) + 1307504.*std::pow(lambda,9)*(21009892968744615936000. + 10677588643129747046400.*nu + 2516390557221660917760.*std::pow(nu,2) + 364832166022719012864.*std::pow(nu,3) + 36394112241747886080.*std::pow(nu,4) + 2646257364231004160.*std::pow(nu,5) + 144896666553999360.*std::pow(nu,6) + 6084396150280448.*std::pow(nu,7) + 197563553341440.*std::pow(nu,8) + 4960939892480.*std::pow(nu,9) + 95557862400.*std::pow(nu,10) + 1386697312.*std::pow(nu,11) + 14676480.*std::pow(nu,12) + 106960.*std::pow(nu,13) + 480.*std::pow(nu,14) + std::pow(nu,15)) + 735471.*std::pow(lambda,8)*(336158287499913854976000. + 191851311258820568678400.*nu + 50939837558676321730560.*std::pow(nu,2) + 8353705213585165123584.*std::pow(nu,3) + 947137961890685190144.*std::pow(nu,4) + 78734230069443952640.*std::pow(nu,5) + 4964604029094993920.*std::pow(nu,6) + 242247004958486528.*std::pow(nu,7) + 9245413003743488.*std::pow(nu,8) + 276938591621120.*std::pow(nu,9) + 6489865690880.*std::pow(nu,10) + 117745019392.*std::pow(nu,11) + 1621520992.*std::pow(nu,12) + 16387840.*std::pow(nu,13) + 114640.*std::pow(nu,14) + 496.*std::pow(nu,15) + std::pow(nu,16)) + 346104.*std::pow(lambda,7)*(4706216024998793969664000. + 3022076645123401816473600.*nu + 905009037080289072906240.*std::pow(nu,2) + 167891710548868633460736.*std::pow(nu,3) + 21613636680054757785600.*std::pow(nu,4) + 2049417182862900527104.*std::pow(nu,5) + 148238686476773867520.*std::pow(nu,6) + 8356062098513805312.*std::pow(nu,7) + 371682787010895360.*std::pow(nu,8) + 13122553286439168.*std::pow(nu,9) + 367796711293440.*std::pow(nu,10) + 8138295962368.*std::pow(nu,11) + 140446313280.*std::pow(nu,12) + 1850950752.*std::pow(nu,13) + 17992800.*std::pow(nu,14) + 121584.*std::pow(nu,15) + 510.*std::pow(nu,16) + std::pow(nu,17)) + 134596.*std::pow(lambda,6)*(56474592299985527635968000. + 40971135766479615767347200.*nu + 13882185090086870691348480.*std::pow(nu,2) + 2919709563666712674435072.*std::pow(nu,3) + 427255350709525726887936.*std::pow(nu,4) + 46206642874409564110848.*std::pow(nu,5) + 3828281420584186937344.*std::pow(nu,6) + 248511431658939531264.*std::pow(nu,7) + 12816255542644549632.*std::pow(nu,8) + 529153426448165376.*std::pow(nu,9) + 17536113821960448.*std::pow(nu,10) + 465456262841856.*std::pow(nu,11) + 9823651721728.*std::pow(nu,12) + 162657722304.*std::pow(nu,13) + 2066864352.*std::pow(nu,14) + 19451808.*std::pow(nu,15) + 127704.*std::pow(nu,16) + 522.*std::pow(nu,17) + std::pow(nu,18)) + 42504.*std::pow(lambda,5)*(564745922999855276359680000. + 466185949964781685309440000.*nu + 179792986667348322680832000.*std::pow(nu,2) + 43079280726753997435699200.*std::pow(nu,3) + 7192263070761969943314432.*std::pow(nu,4) + 889321779453621367996416.*std::pow(nu,5) + 84489457080251433484288.*std::pow(nu,6) + 6313395737173582249984.*std::pow(nu,7) + 376673987085385027584.*std::pow(nu,8) + 18107789807126203392.*std::pow(nu,9) + 704514564667769856.*std::pow(nu,10) + 22190676450379008.*std::pow(nu,11) + 563692780059136.*std::pow(nu,12) + 11450228944768.*std::pow(nu,13) + 183326365824.*std::pow(nu,14) + 2261382432.*std::pow(nu,15) + 20728848.*std::pow(nu,16) + 132924.*std::pow(nu,17) + 532.*std::pow(nu,18) + std::pow(nu,19)) + 10626.*std::pow(lambda,4)*(4517967383998842210877440000. + 4294233522718108758835200000.*nu + 1904529843303568266756096000.*std::pow(nu,2) + 524427232481380302166425600.*std::pow(nu,3) + 100617385292849756982214656.*std::pow(nu,4) + 14306837306390940887285760.*std::pow(nu,5) + 1565237436095632835870720.*std::pow(nu,6) + 134996622977640091484160.*std::pow(nu,7) + 9326787633856662470656.*std::pow(nu,8) + 521536305542394654720.*std::pow(nu,9) + 23743906324468362240.*std::pow(nu,10) + 882039976270801920.*std::pow(nu,11) + 26700218690852096.*std::pow(nu,12) + 655294611617280.*std::pow(nu,13) + 12916839871360.*std::pow(nu,14) + 201417425280.*std::pow(nu,15) + 2427213216.*std::pow(nu,16) + 21792240.*std::pow(nu,17) + 137180.*std::pow(nu,18) + 540.*std::pow(nu,19) + std::pow(nu,20)) + 2024.*std::pow(lambda,3)*(27107804303993053265264640000. + 30283368520307494763888640000.*nu + 15721412582539518359371776000.*std::pow(nu,2) + 5051093238191850079754649600.*std::pow(nu,3) + 1128131544238478844059713536.*std::pow(nu,4) + 186458409131195402305929216.*std::pow(nu,5) + 23698261922964737902510080.*std::pow(nu,6) + 2375217173961473384775680.*std::pow(nu,7) + 190957348780780066308096.*std::pow(nu,8) + 12456005467111030398976.*std::pow(nu,9) + 663999743489204828160.*std::pow(nu,10) + 29036146182093173760.*std::pow(nu,11) + 1042241288415914496.*std::pow(nu,12) + 30631986360555776.*std::pow(nu,13) + 732795650845440.*std::pow(nu,14) + 14125344423040.*std::pow(nu,15) + 215980704576.*std::pow(nu,16) + 2557966656.*std::pow(nu,17) + 22615320.*std::pow(nu,18) + 140420.*std::pow(nu,19) + 546.*std::pow(nu,20) + std::pow(nu,21)) + 276.*std::pow(lambda,2)*(108431217215972213061058560000. + 148241278385223032320819200000.*nu + 93169018850465568201375744000.*std::pow(nu,2) + 35925785535306918678390374400.*std::pow(nu,3) + 9563619415145765455993503744.*std::pow(nu,4) + 1873965180763260453283430400.*std::pow(nu,5) + 281251456823054353915969536.*std::pow(nu,6) + 33199130618810631441612800.*std::pow(nu,7) + 3139046569084593650008064.*std::pow(nu,8) + 240781370649224187904000.*std::pow(nu,9) + 15112004441067849711616.*std::pow(nu,10) + 780144328217577523200.*std::pow(nu,11) + 33205111335756831744.*std::pow(nu,12) + 1164769233858137600.*std::pow(nu,13) + 33563168963937536.*std::pow(nu,14) + 789297028537600.*std::pow(nu,15) + 14989267241344.*std::pow(nu,16) + 226212571200.*std::pow(nu,17) + 2648427936.*std::pow(nu,18) + 23177000.*std::pow(nu,19) + 142604.*std::pow(nu,20) + 550.*std::pow(nu,21) + std::pow(nu,22)) + 24.*lambda*(216862434431944426122117120000. + 404913773986418277702696960000.*nu + 334579316086154168723570688000.*std::pow(nu,2) + 165020589921079405558156492800.*std::pow(nu,3) + 55053024365598449590377381888.*std::pow(nu,4) + 13311549776672286362560364544.*std::pow(nu,5) + 2436468094409369161115369472.*std::pow(nu,6) + 347649718060675616799195136.*std::pow(nu,7) + 39477223756979818741628928.*std::pow(nu,8) + 3620609310383042025816064.*std::pow(nu,9) + 271005379531359887327232.*std::pow(nu,10) + 16672293097503004758016.*std::pow(nu,11) + 846554550889091186688.*std::pow(nu,12) + 35534649803473106944.*std::pow(nu,13) + 1231895571786012672.*std::pow(nu,14) + 35141763021012736.*std::pow(nu,15) + 819275563020288.*std::pow(nu,16) + 15441692383744.*std::pow(nu,17) + 231509427072.*std::pow(nu,18) + 2694781936.*std::pow(nu,19) + 23462208.*std::pow(nu,20) + 143704.*std::pow(nu,21) + 552.*std::pow(nu,22) + std::pow(nu,23)) + nu*(216862434431944426122117120000. + 404913773986418277702696960000.*nu + 334579316086154168723570688000.*std::pow(nu,2) + 165020589921079405558156492800.*std::pow(nu,3) + 55053024365598449590377381888.*std::pow(nu,4) + 13311549776672286362560364544.*std::pow(nu,5) + 2436468094409369161115369472.*std::pow(nu,6) + 347649718060675616799195136.*std::pow(nu,7) + 39477223756979818741628928.*std::pow(nu,8) + 3620609310383042025816064.*std::pow(nu,9) + 271005379531359887327232.*std::pow(nu,10) + 16672293097503004758016.*std::pow(nu,11) + 846554550889091186688.*std::pow(nu,12) + 35534649803473106944.*std::pow(nu,13) + 1231895571786012672.*std::pow(nu,14) + 35141763021012736.*std::pow(nu,15) + 819275563020288.*std::pow(nu,16) + 15441692383744.*std::pow(nu,17) + 231509427072.*std::pow(nu,18) + 2694781936.*std::pow(nu,19) + 23462208.*std::pow(nu,20) + 143704.*std::pow(nu,21) + 552.*std::pow(nu,22) + std::pow(nu,23)));
        moment_(25, std::pow(lambda,25) + 25.*std::pow(lambda,24)*(48. + nu) + 300.*std::pow(lambda,23)*(2208. + 94.*nu + std::pow(nu,2)) + 2300.*std::pow(lambda,22)*(97152. + 6344.*nu + 138.*std::pow(nu,2) + std::pow(nu,3)) + 12650.*std::pow(lambda,21)*(4080384. + 363600.*nu + 12140.*std::pow(nu,2) + 180.*std::pow(nu,3) + std::pow(nu,4)) + 53130.*std::pow(lambda,20)*(163215360. + 18624384.*nu + 849200.*std::pow(nu,2) + 19340.*std::pow(nu,3) + 220.*std::pow(nu,4) + std::pow(nu,5)) + 177100.*std::pow(lambda,19)*(6202183680. + 870941952.*nu + 50893984.*std::pow(nu,2) + 1584120.*std::pow(nu,3) + 27700.*std::pow(nu,4) + 258.*std::pow(nu,5) + std::pow(nu,6)) + 480700.*std::pow(lambda,18)*(223278612480. + 37556093952.*nu + 2703125376.*std::pow(nu,2) + 107922304.*std::pow(nu,3) + 2581320.*std::pow(nu,4) + 36988.*std::pow(nu,5) + 294.*std::pow(nu,6) + std::pow(nu,7)) + 1081575.*std::pow(lambda,17)*(7591472824320. + 1500185806848.*nu + 129462356736.*std::pow(nu,2) + 6372483712.*std::pow(nu,3) + 195687184.*std::pow(nu,4) + 3838912.*std::pow(nu,5) + 46984.*std::pow(nu,6) + 328.*std::pow(nu,7) + std::pow(nu,8)) + 2042975.*std::pow(lambda,16)*(242927130378240. + 55597418643456.*nu + 5642981222400.*std::pow(nu,2) + 333381835520.*std::pow(nu,3) + 12634473600.*std::pow(nu,4) + 318532368.*std::pow(nu,5) + 5342400.*std::pow(nu,6) + 57480.*std::pow(nu,7) + 360.*std::pow(nu,8) + std::pow(nu,9)) + 3268760.*std::pow(lambda,15)*(7287813911347200. + 1910849689681920.*nu + 224886855315456.*std::pow(nu,2) + 15644436288000.*std::pow(nu,3) + 712416043520.*std::pow(nu,4) + 22190444640.*std::pow(nu,5) + 478804368.*std::pow(nu,6) + 7066800.*std::pow(nu,7) + 68280.*std::pow(nu,8) + 390.*std::pow(nu,9) + std::pow(nu,10)) + 4457400.*std::pow(lambda,14)*(204058789517721600. + 60791605222440960.*nu + 8207681638514688.*std::pow(nu,2) + 662931071379456.*std::pow(nu,3) + 35592085506560.*std::pow(nu,4) + 1333748493440.*std::pow(nu,5) + 35596966944.*std::pow(nu,6) + 676674768.*std::pow(nu,7) + 8978640.*std::pow(nu,8) + 79200.*std::pow(nu,9) + 418.*std::pow(nu,10) + std::pow(nu,11)) + 5200300.*std::pow(lambda,13)*(5305528527460761600. + 1784640525301186560.*nu + 274191327823822848.*std::pow(nu,2) + 25443889494380544.*std::pow(nu,3) + 1588325294550016.*std::pow(nu,4) + 70269546336000.*std::pow(nu,5) + 2259269633984.*std::pow(nu,6) + 53190510912.*std::pow(nu,7) + 910119408.*std::pow(nu,8) + 11037840.*std::pow(nu,9) + 90068.*std::pow(nu,10) + 444.*std::pow(nu,11) + std::pow(nu,12)) + 5200300.*std::pow(lambda,12)*(127332684659058278400. + 48136901134689239040.*nu + 8365232393072934912.*std::pow(nu,2) + 884844675688955904.*std::pow(nu,3) + 63563696563580928.*std::pow(nu,4) + 3274794406614016.*std::pow(nu,5) + 124492017551616.*std::pow(nu,6) + 3535841895872.*std::pow(nu,7) + 75033376704.*std::pow(nu,8) + 1175027568.*std::pow(nu,9) + 13199472.*std::pow(nu,10) + 100724.*std::pow(nu,11) + 468.*std::pow(nu,12) + std::pow(nu,13)) + 4457400.*std::pow(lambda,11)*(2801319062499282124800. + 1186344509622221537280.*nu + 232172013782293807104.*std::pow(nu,2) + 27831815258229964800.*std::pow(nu,3) + 2283246000087736320.*std::pow(nu,4) + 135609173509089280.*std::pow(nu,5) + 6013618792749568.*std::pow(nu,6) + 202280539260800.*std::pow(nu,7) + 5186576183360.*std::pow(nu,8) + 100883983200.*std::pow(nu,9) + 1465415952.*std::pow(nu,10) + 15415400.*std::pow(nu,11) + 111020.*std::pow(nu,12) + 490.*std::pow(nu,13) + std::pow(nu,14)) + 3268760.*std::pow(lambda,10)*(56026381249985642496000. + 26528209254943712870400.*nu + 5829784785268097679360.*std::pow(nu,2) + 788808318946893103104.*std::pow(nu,3) + 73496735259984691200.*std::pow(nu,4) + 4995429470269521920.*std::pow(nu,5) + 255881549364080640.*std::pow(nu,6) + 10059229577965568.*std::pow(nu,7) + 306012062928000.*std::pow(nu,8) + 7204255847360.*std::pow(nu,9) + 130192302240.*std::pow(nu,10) + 1773723952.*std::pow(nu,11) + 17635800.*std::pow(nu,12) + 120820.*std::pow(nu,13) + 510.*std::pow(nu,14) + std::pow(nu,15)) + 2042975.*std::pow(lambda,9)*(1008474862499741564928000. + 533534147838972474163200.*nu + 131464335389769471098880.*std::pow(nu,2) + 20028334526312173535232.*std::pow(nu,3) + 2111749553626617544704.*std::pow(nu,4) + 163414465724836085760.*std::pow(nu,5) + 9601297358822973440.*std::pow(nu,6) + 436947681767460864.*std::pow(nu,7) + 15567446710669568.*std::pow(nu,8) + 435688668180480.*std::pow(nu,9) + 9547717287680.*std::pow(nu,10) + 162119333376.*std::pow(nu,11) + 2091168352.*std::pow(nu,12) + 19810560.*std::pow(nu,13) + 130000.*std::pow(nu,14) + 528.*std::pow(nu,15) + std::pow(nu,16)) + 1081575.*std::pow(lambda,8)*(16135597799995865038848000. + 9545021227923301151539200.*nu + 2636963514075284011745280.*std::pow(nu,2) + 451917687810764247662592.*std::pow(nu,3) + 53816327384338054250496.*std::pow(nu,4) + 4726381005223994916864.*std::pow(nu,5) + 317035223466003660800.*std::pow(nu,6) + 16592460267102347264.*std::pow(nu,7) + 686026829138173952.*std::pow(nu,8) + 22538465401557248.*std::pow(nu,9) + 588452144783360.*std::pow(nu,10) + 12141626621696.*std::pow(nu,11) + 195578027008.*std::pow(nu,12) + 2408137312.*std::pow(nu,13) + 21890560.*std::pow(nu,14) + 138448.*std::pow(nu,15) + 544.*std::pow(nu,16) + std::pow(nu,17)) + 480700.*std::pow(lambda,7)*(225898369199942110543872000. + 149765894990922081160396800.*nu + 46462510424977277315973120.*std::pow(nu,2) + 8963811143425983479021568.*std::pow(nu,3) + 1205346271191497007169536.*std::pow(nu,4) + 119985661457473983086592.*std::pow(nu,5) + 9164874133748046168064.*std::pow(nu,6) + 549329667205436522496.*std::pow(nu,7) + 26196835875036782592.*std::pow(nu,8) + 1001565344759975424.*std::pow(nu,9) + 30776795428524288.*std::pow(nu,10) + 758434917487104.*std::pow(nu,11) + 14879718999808.*std::pow(nu,12) + 229291949376.*std::pow(nu,13) + 2714605152.*std::pow(nu,14) + 23828832.*std::pow(nu,15) + 146064.*std::pow(nu,16) + 558.*std::pow(nu,17) + std::pow(nu,18)) + 177100.*std::pow(lambda,6)*(2710780430399305326526464000. + 2023089109091007084468633600.*nu + 707316020090649408952074240.*std::pow(nu,2) + 154028244146089079064231936.*std::pow(nu,3) + 23427966397723947565056000.*std::pow(nu,4) + 2645174208681184804208640.*std::pow(nu,5) + 229964151062450537103360.*std::pow(nu,6) + 15756830140213284438016.*std::pow(nu,7) + 863691697705877913600.*std::pow(nu,8) + 38215620012156487680.*std::pow(nu,9) + 1370886889902266880.*std::pow(nu,10) + 39878014438369536.*std::pow(nu,11) + 936991545484800.*std::pow(nu,12) + 17631222392320.*std::pow(nu,13) + 261867211200.*std::pow(nu,14) + 3000551136.*std::pow(nu,15) + 25581600.*std::pow(nu,16) + 152760.*std::pow(nu,17) + 570.*std::pow(nu,18) + std::pow(nu,19)) + 53130.*std::pow(lambda,5)*(27107804303993053265264640000. + 22941671521309376171212800000.*nu + 9096249309997501173989376000.*std::pow(nu,2) + 2247598461551540199594393600.*std::pow(nu,3) + 388307908123328554714791936.*std::pow(nu,4) + 49879708484535795607142400.*std::pow(nu,5) + 4944815719305690175242240.*std::pow(nu,6) + 387532452464583381483520.*std::pow(nu,7) + 24393747117272063574016.*std::pow(nu,8) + 1245847897827442790400.*std::pow(nu,9) + 51924488911179156480.*std::pow(nu,10) + 1769667034285962240.*std::pow(nu,11) + 49247929893217536.*std::pow(nu,12) + 1113303769408000.*std::pow(nu,13) + 20249894504320.*std::pow(nu,14) + 291872722560.*std::pow(nu,15) + 3256367136.*std::pow(nu,16) + 27109200.*std::pow(nu,17) + 158460.*std::pow(nu,18) + 580.*std::pow(nu,19) + std::pow(nu,20)) + 12650.*std::pow(lambda,4)*(216862434431944426122117120000. + 210641176474468062634967040000.*nu + 95711666001289385563127808000.*std::pow(nu,2) + 27077037002409822770744524800.*std::pow(nu,3) + 5354061726538168637312729088.*std::pow(nu,4) + 787345575999614919571931136.*std::pow(nu,5) + 89438234238981317009080320.*std::pow(nu,6) + 8045075339022357227110400.*std::pow(nu,7) + 582682429402759890075648.*std::pow(nu,8) + 34360530299891605897216.*std::pow(nu,9) + 1661243809116876042240.*std::pow(nu,10) + 66081825185466854400.*std::pow(nu,11) + 2163650473431702528.*std::pow(nu,12) + 58154360048481536.*std::pow(nu,13) + 1275302925442560.*std::pow(nu,14) + 22584876284800.*std::pow(nu,15) + 317923659648.*std::pow(nu,16) + 3473240736.*std::pow(nu,17) + 28376880.*std::pow(nu,18) + 163100.*std::pow(nu,19) + 588.*std::pow(nu,20) + std::pow(nu,21)) + 2300.*std::pow(lambda,3)*(1301174606591666556732702720000. + 1480709493278752801931919360000.*nu + 784911172482204376013733888000.*std::pow(nu,2) + 258173888015748322187594956800.*std::pow(nu,3) + 59201407361638834594620899328.*std::pow(nu,4) + 10078135182535858154744315904.*std::pow(nu,5) + 1323974981433502821626413056.*std::pow(nu,6) + 137708686273115460371742720.*std::pow(nu,7) + 11541169915438916567564288.*std::pow(nu,8) + 788845611202109525458944.*std::pow(nu,9) + 44327993154592862150656.*std::pow(nu,10) + 2057734760229677168640.*std::pow(nu,11) + 79063728026057069568.*std::pow(nu,12) + 2512576633722591744.*std::pow(nu,13) + 65806177601136896.*std::pow(nu,14) + 1410812183151360.*std::pow(nu,15) + 24492418242688.*std::pow(nu,16) + 338763104064.*std::pow(nu,17) + 3643502016.*std::pow(nu,18) + 29355480.*std::pow(nu,19) + 166628.*std::pow(nu,20) + 594.*std::pow(nu,21) + std::pow(nu,22)) + 300.*std::pow(lambda,2)*(5204698426366666226930810880000. + 7224012579706677764460380160000.*nu + 4620354183207570305986854912000.*std::pow(nu,2) + 1817606724545197664764113715200.*std::pow(nu,3) + 494979517462303660566078554112.*std::pow(nu,4) + 99513948091782267213598162944.*std::pow(nu,5) + 15374035108269869441249968128.*std::pow(nu,6) + 1874809726525964663113383936.*std::pow(nu,7) + 183873365934871126641999872.*std::pow(nu,8) + 14696552360247354669400064.*std::pow(nu,9) + 966157583820480974061568.*std::pow(nu,10) + 52558932195511570825216.*std::pow(nu,11) + 2373989672333905446912.*std::pow(nu,12) + 89114034560947436544.*std::pow(nu,13) + 2775801344127139328.*std::pow(nu,14) + 71449426333742336.*std::pow(nu,15) + 1508781856122112.*std::pow(nu,16) + 25847470658944.*std::pow(nu,17) + 353337112128.*std::pow(nu,18) + 3760923936.*std::pow(nu,19) + 30021992.*std::pow(nu,20) + 169004.*std::pow(nu,21) + 598.*std::pow(nu,22) + std::pow(nu,23)) + 25.*lambda*(10409396852733332453861621760000. + 19652723585780021755851571200000.*nu + 16464720946121818376434089984000.*std::pow(nu,2) + 8255567632297965635515082342400.*std::pow(nu,3) + 2807565759469804985896270823424.*std::pow(nu,4) + 694007413645868194993274880000.*std::pow(nu,5) + 130262018308322006096098099200.*std::pow(nu,6) + 19123654561321798767476736000.*std::pow(nu,7) + 2242556458395706916397383680.*std::pow(nu,8) + 213266470655365835980800000.*std::pow(nu,9) + 16628867527888316617523200.*std::pow(nu,10) + 1071275448211504115712000.*std::pow(nu,11) + 57306911540179381719040.*std::pow(nu,12) + 2552217741455800320000.*std::pow(nu,13) + 94665637249201715200.*std::pow(nu,14) + 2918700196794624000.*std::pow(nu,15) + 74466990045986560.*std::pow(nu,16) + 1560476797440000.*std::pow(nu,17) + 26554144883200.*std::pow(nu,18) + 360858960000.*std::pow(nu,19) + 3820967920.*std::pow(nu,20) + 30360000.*std::pow(nu,21) + 170200.*std::pow(nu,22) + 600.*std::pow(nu,23) + std::pow(nu,24)) + nu*(10409396852733332453861621760000. + 19652723585780021755851571200000.*nu + 16464720946121818376434089984000.*std::pow(nu,2) + 8255567632297965635515082342400.*std::pow(nu,3) + 2807565759469804985896270823424.*std::pow(nu,4) + 694007413645868194993274880000.*std::pow(nu,5) + 130262018308322006096098099200.*std::pow(nu,6) + 19123654561321798767476736000.*std::pow(nu,7) + 2242556458395706916397383680.*std::pow(nu,8) + 213266470655365835980800000.*std::pow(nu,9) + 16628867527888316617523200.*std::pow(nu,10) + 1071275448211504115712000.*std::pow(nu,11) + 57306911540179381719040.*std::pow(nu,12) + 2552217741455800320000.*std::pow(nu,13) + 94665637249201715200.*std::pow(nu,14) + 2918700196794624000.*std::pow(nu,15) + 74466990045986560.*std::pow(nu,16) + 1560476797440000.*std::pow(nu,17) + 26554144883200.*std::pow(nu,18) + 360858960000.*std::pow(nu,19) + 3820967920.*std::pow(nu,20) + 30360000.*std::pow(nu,21) + 170200.*std::pow(nu,22) + 600.*std::pow(nu,23) + std::pow(nu,24)));
        moment_(26, std::pow(lambda,26) + 26.*std::pow(lambda,25)*(50. + nu) + 325.*std::pow(lambda,24)*(2400. + 98.*nu + std::pow(nu,2)) + 2600.*std::pow(lambda,23)*(110400. + 6908.*nu + 144.*std::pow(nu,2) + std::pow(nu,3)) + 14950.*std::pow(lambda,22)*(4857600. + 414352.*nu + 13244.*std::pow(nu,2) + 188.*std::pow(nu,3) + std::pow(nu,4)) + 65780.*std::pow(lambda,21)*(204019200. + 22260384.*nu + 970600.*std::pow(nu,2) + 21140.*std::pow(nu,3) + 230.*std::pow(nu,4) + std::pow(nu,5)) + 230230.*std::pow(lambda,20)*(8160768000. + 1094434560.*nu + 61084384.*std::pow(nu,2) + 1816200.*std::pow(nu,3) + 30340.*std::pow(nu,4) + 270.*std::pow(nu,5) + std::pow(nu,6)) + 657800.*std::pow(lambda,19)*(310109184000. + 49749281280.*nu + 3415641152.*std::pow(nu,2) + 130099984.*std::pow(nu,3) + 2969120.*std::pow(nu,4) + 40600.*std::pow(nu,5) + 308.*std::pow(nu,6) + std::pow(nu,7)) + 1562275.*std::pow(lambda,18)*(11163930624000. + 2101083310080.*nu + 172712362752.*std::pow(nu,2) + 8099240576.*std::pow(nu,3) + 236988304.*std::pow(nu,4) + 4430720.*std::pow(nu,5) + 51688.*std::pow(nu,6) + 344.*std::pow(nu,7) + std::pow(nu,8)) + 3124550.*std::pow(lambda,17)*(379573641216000. + 82600763166720.*nu + 7973303643648.*std::pow(nu,2) + 448086542336.*std::pow(nu,3) + 16156842912.*std::pow(nu,4) + 387632784.*std::pow(nu,5) + 6188112.*std::pow(nu,6) + 63384.*std::pow(nu,7) + 378.*std::pow(nu,8) + std::pow(nu,9)) + 5311735.*std::pow(lambda,16)*(12146356518912000. + 3022798062551040.*nu + 337746479763456.*std::pow(nu,2) + 22312072998400.*std::pow(nu,3) + 965105515520.*std::pow(nu,4) + 28561092000.*std::pow(nu,5) + 585652368.*std::pow(nu,6) + 8216400.*std::pow(nu,7) + 75480.*std::pow(nu,8) + 410.*std::pow(nu,9) + std::pow(nu,10)) + 7726160.*std::pow(lambda,15)*(364390695567360000. + 102830298395443200.*nu + 13155192455454720.*std::pow(nu,2) + 1007108669715456.*std::pow(nu,3) + 51265238464000.*std::pow(nu,4) + 1821938275520.*std::pow(nu,5) + 46130663040.*std::pow(nu,6) + 832144368.*std::pow(nu,7) + 10480800.*std::pow(nu,8) + 87780.*std::pow(nu,9) + 440.*std::pow(nu,10) + std::pow(nu,11)) + 9657700.*std::pow(lambda,14)*(10202939475886080000. + 3243639050639769600.*nu + 471175687148175360.*std::pow(nu,2) + 41354235207487488.*std::pow(nu,3) + 2442535346707456.*std::pow(nu,4) + 102279510178560.*std::pow(nu,5) + 3113596840640.*std::pow(nu,6) + 69430705344.*std::pow(nu,7) + 1125606768.*std::pow(nu,8) + 12938640.*std::pow(nu,9) + 100100.*std::pow(nu,10) + 468.*std::pow(nu,11) + std::pow(nu,12)) + 10400600.*std::pow(lambda,13)*(265276426373038080000. + 94537554792520089600.*nu + 15494206916492328960.*std::pow(nu,2) + 1546385802542850048.*std::pow(nu,3) + 104860154221881344.*std::pow(nu,4) + 5101802611350016.*std::pow(nu,5) + 183233028035200.*std::pow(nu,6) + 4918795179584.*std::pow(nu,7) + 98696481312.*std::pow(nu,8) + 1462011408.*std::pow(nu,9) + 15541240.*std::pow(nu,10) + 112268.*std::pow(nu,11) + 494.*std::pow(nu,12) + std::pow(nu,13)) + 9657700.*std::pow(lambda,12)*(6366634232952913920000. + 2534177741393520230400.*nu + 466398520788335984640.*std::pow(nu,2) + 52607466177520730112.*std::pow(nu,3) + 4063029503868002304.*std::pow(nu,4) + 227303416894281728.*std::pow(nu,5) + 9499395284194816.*std::pow(nu,6) + 301284112345216.*std::pow(nu,7) + 7287510731072.*std::pow(nu,8) + 133784755104.*std::pow(nu,9) + 1835001168.*std::pow(nu,10) + 18235672.*std::pow(nu,11) + 124124.*std::pow(nu,12) + 518.*std::pow(nu,13) + std::pow(nu,14)) + 7726160.*std::pow(lambda,11)*(140065953124964106240000. + 62118544543610358988800.*nu + 12794945198736911892480.*std::pow(nu,2) + 1623762776693792047104.*std::pow(nu,3) + 141994115262616780800.*std::pow(nu,4) + 9063704675542200320.*std::pow(nu,5) + 436290113146567680.*std::pow(nu,6) + 16127645755789568.*std::pow(nu,7) + 461609348428800.*std::pow(nu,8) + 10230775343360.*std::pow(nu,9) + 174154780800.*std::pow(nu,10) + 2236185952.*std::pow(nu,11) + 20966400.*std::pow(nu,12) + 135520.*std::pow(nu,13) + 540.*std::pow(nu,14) + std::pow(nu,15)) + 5311735.*std::pow(lambda,10)*(2801319062499282124800000. + 1382436843997171286016000.*nu + 318017448518348596838400.*std::pow(nu,2) + 45270200732612752834560.*std::pow(nu,3) + 4463645081946127663104.*std::pow(nu,4) + 323268208773460787200.*std::pow(nu,5) + 17789506938473553920.*std::pow(nu,6) + 758843028262359040.*std::pow(nu,7) + 25359832724365568.*std::pow(nu,8) + 666224855296000.*std::pow(nu,9) + 13713870959360.*std::pow(nu,10) + 218878499840.*std::pow(nu,11) + 2655513952.*std::pow(nu,12) + 23676800.*std::pow(nu,13) + 146320.*std::pow(nu,14) + 560.*std::pow(nu,15) + std::pow(nu,16)) + 3124550.*std::pow(lambda,9)*(50423743124987078246400000. + 27685182254448365273088000.*nu + 7106750917327446029107200.*std::pow(nu,2) + 1132881061705378147860480.*std::pow(nu,3) + 125615812207643050770432.*std::pow(nu,4) + 10282472839868421832704.*std::pow(nu,5) + 643479333665984757760.*std::pow(nu,6) + 31448681447196016640.*std::pow(nu,7) + 1215320017300939264.*std::pow(nu,8) + 37351880119693568.*std::pow(nu,9) + 913074532564480.*std::pow(nu,10) + 17653683956480.*std::pow(nu,11) + 266677750976.*std::pow(nu,12) + 3081696352.*std::pow(nu,13) + 26310560.*std::pow(nu,14) + 156400.*std::pow(nu,15) + 578.*std::pow(nu,16) + std::pow(nu,17)) + 1562275.*std::pow(lambda,8)*(806779889999793251942400000. + 493386659196160922615808000.*nu + 141393196931687501738803200.*std::pow(nu,2) + 25232847904613496394874880.*std::pow(nu,3) + 3142734057027666960187392.*std::pow(nu,4) + 290135377645537800093696.*std::pow(nu,5) + 20578142178524177956864.*std::pow(nu,6) + 1146658236821121024000.*std::pow(nu,7) + 50893801724011044864.*std::pow(nu,8) + 1812950099216036352.*std::pow(nu,9) + 51961072640725248.*std::pow(nu,10) + 1195533475868160.*std::pow(nu,11) + 21920527972096.*std::pow(nu,12) + 315984892608.*std::pow(nu,13) + 3502665312.*std::pow(nu,14) + 28812960.*std::pow(nu,15) + 165648.*std::pow(nu,16) + 594.*std::pow(nu,17) + std::pow(nu,18)) + 657800.*std::pow(lambda,7)*(11294918459997105527193600000. + 7714193118746046168563712000.*nu + 2472891416239785946959052800.*std::pow(nu,2) + 494653067596276451267051520.*std::pow(nu,3) + 69231124703000833837498368.*std::pow(nu,4) + 7204629344065196161499136.*std::pow(nu,5) + 578229368144876291489792.*std::pow(nu,6) + 36631357494019872292864.*std::pow(nu,7) + 1859171460957275652096.*std::pow(nu,8) + 76275103113035553792.*std::pow(nu,9) + 2540405116186189824.*std::pow(nu,10) + 68698541302879488.*std::pow(nu,11) + 1502420867477504.*std::pow(nu,12) + 26344316468608.*std::pow(nu,13) + 365022206976.*std::pow(nu,14) + 3906046752.*std::pow(nu,15) + 31132032.*std::pow(nu,16) + 173964.*std::pow(nu,17) + 608.*std::pow(nu,18) + std::pow(nu,19)) + 230230.*std::pow(lambda,6)*(135539021519965266326323200000. + 103865235884949659549958144000.*nu + 37388890113623477532072345600.*std::pow(nu,2) + 8408728227395103362163671040.*std::pow(nu,3) + 1325426564032286457317031936.*std::pow(nu,4) + 155686676831783187775488000.*std::pow(nu,5) + 14143381761803711659376640.*std::pow(nu,6) + 1017805658073114759004160.*std::pow(nu,7) + 58941415025507180118016.*std::pow(nu,8) + 2774472698313702297600.*std::pow(nu,9) + 106759964507269831680.*std::pow(nu,10) + 3364787611820743680.*std::pow(nu,11) + 86727591712609536.*std::pow(nu,12) + 1818552665100800.*std::pow(nu,13) + 30724582952320.*std::pow(nu,14) + 411894768000.*std::pow(nu,15) + 4279631136.*std::pow(nu,16) + 33219600.*std::pow(nu,17) + 181260.*std::pow(nu,18) + 620.*std::pow(nu,19) + std::pow(nu,20)) + 65780.*std::pow(lambda,5)*(1355390215199652663263232000000. + 1174191380369461861825904640000.*nu + 477754137021184434870681600000.*std::pow(nu,2) + 121476172387574511153709056000.*std::pow(nu,3) + 21662993867717967935333990400.*std::pow(nu,4) + 2882293332350118335071911936.*std::pow(nu,5) + 297120494449820304369254400.*std::pow(nu,6) + 24321438342534859249418240.*std::pow(nu,7) + 1607219808328186560184320.*std::pow(nu,8) + 86686142008644203094016.*std::pow(nu,9) + 3842072343386400614400.*std::pow(nu,10) + 140407840625477268480.*std::pow(nu,11) + 4232063528946839040.*std::pow(nu,12) + 104913118363617536.*std::pow(nu,13) + 2125798494624000.*std::pow(nu,14) + 34843530632320.*std::pow(nu,15) + 454691079360.*std::pow(nu,16) + 4611827136.*std::pow(nu,17) + 35032200.*std::pow(nu,18) + 187460.*std::pow(nu,19) + 630.*std::pow(nu,20) + std::pow(nu,21)) + 14950.*std::pow(lambda,4)*(10843121721597221306105856000000. + 10748921258155347557870469120000.*nu + 4996224476538937340791357440000.*std::pow(nu,2) + 1449563516121780524100354048000.*std::pow(nu,3) + 294780123329318254636380979200.*std::pow(nu,4) + 44721340526518914615909285888.*std::pow(nu,5) + 5259257287948680770025947136.*std::pow(nu,6) + 491692001190099178364600320.*std::pow(nu,7) + 37179196809160351730892800.*std::pow(nu,8) + 2300708944397340184936448.*std::pow(nu,9) + 117422720755735408009216.*std::pow(nu,10) + 4965335068390218762240.*std::pow(nu,11) + 174264348857051980800.*std::pow(nu,12) + 5071368475855779328.*std::pow(nu,13) + 121919506320609536.*std::pow(nu,14) + 2404546739682560.*std::pow(nu,15) + 38481059267200.*std::pow(nu,16) + 491585696448.*std::pow(nu,17) + 4892084736.*std::pow(nu,18) + 36531880.*std::pow(nu,19) + 192500.*std::pow(nu,20) + 638.*std::pow(nu,21) + std::pow(nu,22)) + 2600.*std::pow(lambda,3)*(65058730329583327836635136000000. + 75336649270529306653328670720000.*nu + 40726268117388971602618613760000.*std::pow(nu,2) + 13693605573269620485393481728000.*std::pow(nu,3) + 3218244256097690051918639923200.*std::pow(nu,4) + 563108166488431742331836694528.*std::pow(nu,5) + 76276884254210999236064968704.*std::pow(nu,6) + 8209409295089275840213549056.*std::pow(nu,7) + 714767182045061288749957120.*std::pow(nu,8) + 50983450475544392840511488.*std::pow(nu,9) + 3005245268931752632991744.*std::pow(nu,10) + 147214731166076720582656.*std::pow(nu,11) + 6010921161532530647040.*std::pow(nu,12) + 204692559712186656768.*std::pow(nu,13) + 5802885513779436544.*std::pow(nu,14) + 136346786758704896.*std::pow(nu,15) + 2635433095285760.*std::pow(nu,16) + 41430573445888.*std::pow(nu,17) + 520938204864.*std::pow(nu,18) + 5111276016.*std::pow(nu,19) + 37686880.*std::pow(nu,20) + 196328.*std::pow(nu,21) + 644.*std::pow(nu,22) + std::pow(nu,23)) + 325.*std::pow(lambda,2)*(260234921318333311346540544000000. + 366405327411700554449949818880000.*nu + 238241721740085193063803125760000.*std::pow(nu,2) + 95500690410467453544192540672000.*std::pow(nu,3) + 26566582597660380693068041420800.*std::pow(nu,4) + 5470676922051417021245986701312.*std::pow(nu,5) + 868215703505275739276096569344.*std::pow(nu,6) + 109114521434568102596919164928.*std::pow(nu,7) + 11068478023269520995213377536.*std::pow(nu,8) + 918700983947238860112003072.*std::pow(nu,9) + 63004431551271403372478464.*std::pow(nu,10) + 3594104193596059515322368.*std::pow(nu,11) + 171258415812206843170816.*std::pow(nu,12) + 6829691400381277274112.*std::pow(nu,13) + 227904101767304402944.*std::pow(nu,14) + 6348272660814256128.*std::pow(nu,15) + 146888519139847936.*std::pow(nu,16) + 2801155389069312.*std::pow(nu,17) + 43514326265344.*std::pow(nu,18) + 541383308928.*std::pow(nu,19) + 5262023536.*std::pow(nu,20) + 38472192.*std::pow(nu,21) + 198904.*std::pow(nu,22) + 648.*std::pow(nu,23) + std::pow(nu,24)) + 26.*lambda*(520469842636666622693081088000000. + 993045576141734420246440181760000.*nu + 842888770891870940577556070400000.*std::pow(nu,2) + 429243102561020100152188207104000.*std::pow(nu,3) + 148633855605788214930328623513600.*std::pow(nu,4) + 37507936441763214735560014823424.*std::pow(nu,5) + 7207108329061968499798179840000.*std::pow(nu,6) + 1086444746374411944469934899200.*std::pow(nu,7) + 131251477481107144587345920000.*std::pow(nu,8) + 12905879991163998715437383680.*std::pow(nu,9) + 1044709847049781666856960000.*std::pow(nu,10) + 70192639938463522403123200.*std::pow(nu,11) + 3936621025220473201664000.*std::pow(nu,12) + 184917798612969397719040.*std::pow(nu,13) + 7285499603915886080000.*std::pow(nu,14) + 240600647088932915200.*std::pow(nu,15) + 6642049699093952000.*std::pow(nu,16) + 152490829917986560.*std::pow(nu,17) + 2888184041600000.*std::pow(nu,18) + 44597092883200.*std::pow(nu,19) + 551907356000.*std::pow(nu,20) + 5338967920.*std::pow(nu,21) + 38870000.*std::pow(nu,22) + 200200.*std::pow(nu,23) + 650.*std::pow(nu,24) + std::pow(nu,25)) + nu*(520469842636666622693081088000000. + 993045576141734420246440181760000.*nu + 842888770891870940577556070400000.*std::pow(nu,2) + 429243102561020100152188207104000.*std::pow(nu,3) + 148633855605788214930328623513600.*std::pow(nu,4) + 37507936441763214735560014823424.*std::pow(nu,5) + 7207108329061968499798179840000.*std::pow(nu,6) + 1086444746374411944469934899200.*std::pow(nu,7) + 131251477481107144587345920000.*std::pow(nu,8) + 12905879991163998715437383680.*std::pow(nu,9) + 1044709847049781666856960000.*std::pow(nu,10) + 70192639938463522403123200.*std::pow(nu,11) + 3936621025220473201664000.*std::pow(nu,12) + 184917798612969397719040.*std::pow(nu,13) + 7285499603915886080000.*std::pow(nu,14) + 240600647088932915200.*std::pow(nu,15) + 6642049699093952000.*std::pow(nu,16) + 152490829917986560.*std::pow(nu,17) + 2888184041600000.*std::pow(nu,18) + 44597092883200.*std::pow(nu,19) + 551907356000.*std::pow(nu,20) + 5338967920.*std::pow(nu,21) + 38870000.*std::pow(nu,22) + 200200.*std::pow(nu,23) + 650.*std::pow(nu,24) + std::pow(nu,25)));
        moment_(27, std::pow(lambda,27) + 27.*std::pow(lambda,26)*(52. + nu) + 351.*std::pow(lambda,25)*(2600. + 102.*nu + std::pow(nu,2)) + 2925.*std::pow(lambda,24)*(124800. + 7496.*nu + 150.*std::pow(nu,2) + std::pow(nu,3)) + 17550.*std::pow(lambda,23)*(5740800. + 469616.*nu + 14396.*std::pow(nu,2) + 196.*std::pow(nu,3) + std::pow(nu,4)) + 80730.*std::pow(lambda,22)*(252595200. + 26403904.*nu + 1103040.*std::pow(nu,2) + 23020.*std::pow(nu,3) + 240.*std::pow(nu,4) + std::pow(nu,5)) + 296010.*std::pow(lambda,21)*(10608998400. + 1361559168.*nu + 72731584.*std::pow(nu,2) + 2069880.*std::pow(nu,3) + 33100.*std::pow(nu,4) + 282.*std::pow(nu,5) + std::pow(nu,6)) + 888030.*std::pow(lambda,20)*(424359936000. + 65071365120.*nu + 4270822528.*std::pow(nu,2) + 155526784.*std::pow(nu,3) + 3393880.*std::pow(nu,4) + 44380.*std::pow(nu,5) + 322.*std::pow(nu,6) + std::pow(nu,7)) + 2220075.*std::pow(lambda,19)*(16125677568000. + 2897071810560.*nu + 227362621184.*std::pow(nu,2) + 10180840320.*std::pow(nu,3) + 284494224.*std::pow(nu,4) + 5080320.*std::pow(nu,5) + 56616.*std::pow(nu,6) + 360.*std::pow(nu,7) + std::pow(nu,8)) + 4686825.*std::pow(lambda,18)*(580524392448000. + 120420262748160.*nu + 11082126173184.*std::pow(nu,2) + 593872872704.*std::pow(nu,3) + 20422632384.*std::pow(nu,4) + 467385744.*std::pow(nu,5) + 7118496.*std::pow(nu,6) + 69576.*std::pow(nu,7) + 396.*std::pow(nu,8) + std::pow(nu,9)) + 8436285.*std::pow(lambda,17)*(19737829343232000. + 4674813325885440.*nu + 497212552636416.*std::pow(nu,2) + 31273803845120.*std::pow(nu,3) + 1288242373760.*std::pow(nu,4) + 36313747680.*std::pow(nu,5) + 709414608.*std::pow(nu,6) + 9484080.*std::pow(nu,7) + 83040.*std::pow(nu,8) + 430.*std::pow(nu,9) + std::pow(nu,10)) + 13037895.*std::pow(lambda,16)*(631610538983424000. + 169331855771566080.*nu + 20585615010250752.*std::pow(nu,2) + 1497974275680256.*std::pow(nu,3) + 72497559805440.*std::pow(nu,4) + 2450282299520.*std::pow(nu,5) + 59015015136.*std::pow(nu,6) + 1012905168.*std::pow(nu,7) + 12141360.*std::pow(nu,8) + 96800.*std::pow(nu,9) + 462.*std::pow(nu,10) + std::pow(nu,11)) + 17383860.*std::pow(lambda,15)*(18948316169502720000. + 5711566212130406400.*nu + 786900306079088640.*std::pow(nu,2) + 65524843280658432.*std::pow(nu,3) + 3672901069843456.*std::pow(nu,4) + 146006028791040.*std::pow(nu,5) + 4220732753600.*std::pow(nu,6) + 89402170176.*std::pow(nu,7) + 1377145968.*std::pow(nu,8) + 15045360.*std::pow(nu,9) + 110660.*std::pow(nu,10) + 492.*std::pow(nu,11) + std::pow(nu,12)) + 20058300.*std::pow(lambda,14)*(530552852746076160000. + 178872170109154099200.*nu + 27744774782344888320.*std::pow(nu,2) + 2621595917937524736.*std::pow(nu,3) + 168366073236275200.*std::pow(nu,4) + 7761069875992576.*std::pow(nu,5) + 264186545891840.*std::pow(nu,6) + 6723993518528.*std::pow(nu,7) + 127962257280.*std::pow(nu,8) + 1798416048.*std::pow(nu,9) + 18143840.*std::pow(nu,10) + 124436.*std::pow(nu,11) + 520.*std::pow(nu,12) + std::pow(nu,13)) + 20058300.*std::pow(lambda,13)*(13794374171397980160000. + 5181229275584082739200.*nu + 900236314450121195520.*std::pow(nu,2) + 95906268648720531456.*std::pow(nu,3) + 6999113822080679936.*std::pow(nu,4) + 370153890012082176.*std::pow(nu,5) + 14629920069180416.*std::pow(nu,6) + 439010377373568.*std::pow(nu,7) + 10051012207808.*std::pow(nu,8) + 174721074528.*std::pow(nu,9) + 2270155888.*std::pow(nu,10) + 21379176.*std::pow(nu,11) + 137956.*std::pow(nu,12) + 546.*std::pow(nu,13) + std::pow(nu,14)) + 17383860.*std::pow(lambda,12)*(331064980113551523840000. + 138143876785415965900800.*nu + 26786900822386991431680.*std::pow(nu,2) + 3201986762019413950464.*std::pow(nu,3) + 263885000378656849920.*std::pow(nu,4) + 15882807182370652160.*std::pow(nu,5) + 721271971672412160.*std::pow(nu,6) + 25166169126146048.*std::pow(nu,7) + 680234670360960.*std::pow(nu,8) + 14244317996480.*std::pow(nu,9) + 229204815840.*std::pow(nu,10) + 2783256112.*std::pow(nu,11) + 24690120.*std::pow(nu,12) + 151060.*std::pow(nu,13) + 570.*std::pow(nu,14) + std::pow(nu,15)) + 13037895.*std::pow(lambda,11)*(7283429562498133524480000. + 3370230269392702773657600.*nu + 727455694877929777397760.*std::pow(nu,2) + 97230609586814098341888.*std::pow(nu,3) + 9007456770349864648704.*std::pow(nu,4) + 613306758390811197440.*std::pow(nu,5) + 31750790559163719680.*std::pow(nu,6) + 1274927692447625216.*std::pow(nu,7) + 40131331874087168.*std::pow(nu,8) + 993609666283520.*std::pow(nu,9) + 19286823944960.*std::pow(nu,10) + 290436450304.*std::pow(nu,11) + 3326438752.*std::pow(nu,12) + 28013440.*std::pow(nu,13) + 163600.*std::pow(nu,14) + 592.*std::pow(nu,15) + std::pow(nu,16)) + 8436285.*std::pow(lambda,10)*(145668591249962670489600000. + 74688034950352188997632000.*nu + 17919344166951298321612800.*std::pow(nu,2) + 2672067886614211744235520.*std::pow(nu,3) + 277379744993811391315968.*std::pow(nu,4) + 21273591938166088597504.*std::pow(nu,5) + 1248322569574085591040.*std::pow(nu,6) + 57249344408116224000.*std::pow(nu,7) + 2077554329929368576.*std::pow(nu,8) + 60003525199757568.*std::pow(nu,9) + 1379346145182720.*std::pow(nu,10) + 25095552951040.*std::pow(nu,11) + 356965225344.*std::pow(nu,12) + 3886707552.*std::pow(nu,13) + 31285440.*std::pow(nu,14) + 175440.*std::pow(nu,15) + 612.*std::pow(nu,16) + std::pow(nu,17)) + 4686825.*std::pow(lambda,9)*(2622034642499328068812800000. + 1490053220356302072446976000.*nu + 397236229955475558786662400.*std::pow(nu,2) + 66016566126007109717852160.*std::pow(nu,3) + 7664903296502816787922944.*std::pow(nu,4) + 660304399880800986071040.*std::pow(nu,5) + 43743398190499629236224.*std::pow(nu,6) + 2278810768920177623040.*std::pow(nu,7) + 94645322346844858368.*std::pow(nu,8) + 3157617783525004800.*std::pow(nu,9) + 84831755813046528.*std::pow(nu,10) + 1831066098301440.*std::pow(nu,11) + 31520927007232.*std::pow(nu,12) + 426925961280.*std::pow(nu,13) + 4449845472.*std::pow(nu,14) + 34443360.*std::pow(nu,15) + 186456.*std::pow(nu,16) + 630.*std::pow(nu,17) + std::pow(nu,18)) + 2220075.*std::pow(lambda,8)*(41952554279989249101004800000. + 26462886168200161227964416000.*nu + 7845832899643911013033574400.*std::pow(nu,2) + 1453501287971589314272296960.*std::pow(nu,3) + 188655018870052178324619264.*std::pow(nu,4) + 18229773694595632565059584.*std::pow(nu,5) + 1360198770928795053850624.*std::pow(nu,6) + 80204370493222471204864.*std::pow(nu,7) + 3793135926469695356928.*std::pow(nu,8) + 145167206883244935168.*std::pow(nu,9) + 4514925876533749248.*std::pow(nu,10) + 114128813385869568.*std::pow(nu,11) + 2335400930417152.*std::pow(nu,12) + 38351742387712.*std::pow(nu,13) + 498123488832.*std::pow(nu,14) + 5000939232.*std::pow(nu,15) + 37426656.*std::pow(nu,16) + 196536.*std::pow(nu,17) + 646.*std::pow(nu,18) + std::pow(nu,19)) + 888030.*std::pow(lambda,7)*(587335759919849487414067200000. + 412432960634791506292506624000.*nu + 136304546763214915410434457600.*std::pow(nu,2) + 28194850931246161412845731840.*std::pow(nu,3) + 4094671552152319810816966656.*std::pow(nu,4) + 443871850594391034235453440.*std::pow(nu,5) + 37272556487598763318968320.*std::pow(nu,6) + 2483059957833909650718720.*std::pow(nu,7) + 133308273463798206201856.*std::pow(nu,8) + 5825476822835124449280.*std::pow(nu,9) + 208376169154717424640.*std::pow(nu,10) + 6112729263935923200.*std::pow(nu,11) + 146824426411709696.*std::pow(nu,12) + 2872325323845120.*std::pow(nu,13) + 45325471231360.*std::pow(nu,14) + 568136638080.*std::pow(nu,15) + 5524912416.*std::pow(nu,16) + 40178160.*std::pow(nu,17) + 205580.*std::pow(nu,18) + 660.*std::pow(nu,19) + std::pow(nu,20)) + 296010.*std::pow(lambda,6)*(7048029119038193848968806400000. + 5536531287537347562924146688000.*nu + 2048087521793370491217720115200.*std::pow(nu,2) + 474642757938168852364583239680.*std::pow(nu,3) + 77330909557073999142649331712.*std::pow(nu,4) + 9421133759285012221642407936.*std::pow(nu,5) + 891142528445576194063073280.*std::pow(nu,6) + 67069275981605679127592960.*std::pow(nu,7) + 4082759239399488125140992.*std::pow(nu,8) + 203213995337819699593216.*std::pow(nu,9) + 8325990852691733544960.*std::pow(nu,10) + 281728920321948503040.*std::pow(nu,11) + 7874622380876439552.*std::pow(nu,12) + 181292330297851136.*std::pow(nu,13) + 3416230978621440.*std::pow(nu,14) + 52143110888320.*std::pow(nu,15) + 634435587072.*std::pow(nu,16) + 6007050336.*std::pow(nu,17) + 42645120.*std::pow(nu,18) + 213500.*std::pow(nu,19) + 672.*std::pow(nu,20) + std::pow(nu,21)) + 80730.*std::pow(lambda,5)*(70480291190381938489688064000000. + 62413341994411669478210273280000.*nu + 26017406505471052475101347840000.*std::pow(nu,2) + 6794515101175059014863552512000.*std::pow(nu,3) + 1247951853508908843791076556800.*std::pow(nu,4) + 171542247149924121359073411072.*std::pow(nu,5) + 18332559043740774162273140736.*std::pow(nu,6) + 1561835288261632985339002880.*std::pow(nu,7) + 107896868375600560379002880.*std::pow(nu,8) + 6114899192777685121073152.*std::pow(nu,9) + 286473903864737035042816.*std::pow(nu,10) + 11143280055911218575360.*std::pow(nu,11) + 360475144130712898560.*std::pow(nu,12) + 9687545683854950912.*std::pow(nu,13) + 215454640084065536.*std::pow(nu,14) + 3937662087504640.*std::pow(nu,15) + 58487466759040.*std::pow(nu,16) + 694506090432.*std::pow(nu,17) + 6433501536.*std::pow(nu,18) + 44780120.*std::pow(nu,19) + 220220.*std::pow(nu,20) + 682.*std::pow(nu,21) + std::pow(nu,22)) + 17550.*std::pow(lambda,4)*(563842329523055507917504512000000. + 569787027145675294315370250240000.*nu + 270552594038180089279021056000000.*std::pow(nu,2) + 80373527314871524594009767936000.*std::pow(nu,3) + 16778129929246329765192164966400.*std::pow(nu,4) + 2620289830708301814663663845376.*std::pow(nu,5) + 318202719499850314657258536960.*std::pow(nu,6) + 30827241349833838044985163776.*std::pow(nu,7) + 2425010235266437468371025920.*std::pow(nu,8) + 156816061917822041347588096.*std::pow(nu,9) + 8406690423695581401415680.*std::pow(nu,10) + 375620144312026783645696.*std::pow(nu,11) + 14027081208956921763840.*std::pow(nu,12) + 437975509601552505856.*std::pow(nu,13) + 11411182804527475200.*std::pow(nu,14) + 246955936784102656.*std::pow(nu,15) + 4405561821576960.*std::pow(nu,16) + 64043515482496.*std::pow(nu,17) + 745974102720.*std::pow(nu,18) + 6791742496.*std::pow(nu,19) + 46541880.*std::pow(nu,20) + 225676.*std::pow(nu,21) + 690.*std::pow(nu,22) + std::pow(nu,23)) + 2925.*std::pow(lambda,3)*(3383053977138333047505027072000000. + 3982564492397107273809726013440000.*nu + 2193102591374755829989496586240000.*std::pow(nu,2) + 752793757927409236843079663616000.*std::pow(nu,3) + 181042306890349503185162757734400.*std::pow(nu,4) + 32499868913496140653174148038656.*std::pow(nu,5) + 4529506147707403702607215067136.*std::pow(nu,6) + 503166167598853342927169519616.*std::pow(nu,7) + 45377302761432462855211319296.*std::pow(nu,8) + 3365906606773369716456554496.*std::pow(nu,9) + 207256204459995529756082176.*std::pow(nu,10) + 10660411289567742103289856.*std::pow(nu,11) + 459782631565768314228736.*std::pow(nu,12) + 16654934266566236798976.*std::pow(nu,13) + 506442606428717357056.*std::pow(nu,14) + 12892918425232091136.*std::pow(nu,15) + 273389307713564416.*std::pow(nu,16) + 4789822914471936.*std::pow(nu,17) + 68519360098816.*std::pow(nu,18) + 786724557696.*std::pow(nu,19) + 7070993776.*std::pow(nu,20) + 47895936.*std::pow(nu,21) + 229816.*std::pow(nu,22) + 696.*std::pow(nu,23) + std::pow(nu,24)) + 351.*std::pow(lambda,2)*(13532215908553332190020108288000000. + 19313311946726762142743931125760000.*nu + 12754974857896130593767712358400000.*std::pow(nu,2) + 5204277623084392777361815240704000.*std::pow(nu,3) + 1476962985488807249583730694553600.*std::pow(nu,4) + 311041782544334065797859349889024.*std::pow(nu,5) + 50617893504325755463603008307200.*std::pow(nu,6) + 6542170818102817074315893145600.*std::pow(nu,7) + 684675378644583194348014796800.*std::pow(nu,8) + 58840929188525941721037537280.*std::pow(nu,9) + 4194931424613351835480883200.*std::pow(nu,10) + 249897849618266498169241600.*std::pow(nu,11) + 12499541815830815360204800.*std::pow(nu,12) + 526402368632033261424640.*std::pow(nu,13) + 18680704692281106227200.*std::pow(nu,14) + 558014280129645721600.*std::pow(nu,15) + 13986475656086348800.*std::pow(nu,16) + 292548599371452160.*std::pow(nu,17) + 5063900354867200.*std::pow(nu,18) + 71666258329600.*std::pow(nu,19) + 815008532800.*std::pow(nu,20) + 7262577520.*std::pow(nu,21) + 48815200.*std::pow(nu,22) + 232600.*std::pow(nu,23) + 700.*std::pow(nu,24) + std::pow(nu,25)) + 27.*lambda*(27064431817106664380040216576000000. + 52158839802006856475507970539520000.*nu + 44823261662519023330279355842560000.*std::pow(nu,2) + 23163530104064916148491342839808000.*std::pow(nu,3) + 8158203594062007276529276629811200.*std::pow(nu,4) + 2099046550577475381179449394331648.*std::pow(nu,5) + 412277569552985576725065366503424.*std::pow(nu,6) + 63702235140531389612234794598400.*std::pow(nu,7) + 7911521575391983463011922739200.*std::pow(nu,8) + 802357237021635077790089871360.*std::pow(nu,9) + 67230792037752645391999303680.*std::pow(nu,10) + 4694727123849884831819366400.*std::pow(nu,11) + 274896933249928128889651200.*std::pow(nu,12) + 13552346553094881883054080.*std::pow(nu,13) + 563763778016595473879040.*std::pow(nu,14) + 19796733252540397670400.*std::pow(nu,15) + 585987231441818419200.*std::pow(nu,16) + 14571572854829253120.*std::pow(nu,17) + 302676400081186560.*std::pow(nu,18) + 5207232871526400.*std::pow(nu,19) + 73296275395200.*std::pow(nu,20) + 829533687840.*std::pow(nu,21) + 7360207920.*std::pow(nu,22) + 49280400.*std::pow(nu,23) + 234000.*std::pow(nu,24) + 702.*std::pow(nu,25) + std::pow(nu,26)) + nu*(27064431817106664380040216576000000. + 52158839802006856475507970539520000.*nu + 44823261662519023330279355842560000.*std::pow(nu,2) + 23163530104064916148491342839808000.*std::pow(nu,3) + 8158203594062007276529276629811200.*std::pow(nu,4) + 2099046550577475381179449394331648.*std::pow(nu,5) + 412277569552985576725065366503424.*std::pow(nu,6) + 63702235140531389612234794598400.*std::pow(nu,7) + 7911521575391983463011922739200.*std::pow(nu,8) + 802357237021635077790089871360.*std::pow(nu,9) + 67230792037752645391999303680.*std::pow(nu,10) + 4694727123849884831819366400.*std::pow(nu,11) + 274896933249928128889651200.*std::pow(nu,12) + 13552346553094881883054080.*std::pow(nu,13) + 563763778016595473879040.*std::pow(nu,14) + 19796733252540397670400.*std::pow(nu,15) + 585987231441818419200.*std::pow(nu,16) + 14571572854829253120.*std::pow(nu,17) + 302676400081186560.*std::pow(nu,18) + 5207232871526400.*std::pow(nu,19) + 73296275395200.*std::pow(nu,20) + 829533687840.*std::pow(nu,21) + 7360207920.*std::pow(nu,22) + 49280400.*std::pow(nu,23) + 234000.*std::pow(nu,24) + 702.*std::pow(nu,25) + std::pow(nu,26)));

        std::vector<std::function<Real(Real, Real)> > initMoments() {
            std::vector<std::function<Real(Real, Real)> > retVal(NM);

            #define BOOST_PP_LOCAL_MACRO(n) \
                retVal[n] = std::function<Real(Real, Real)>(f_##n);
            #define BOOST_PP_LOCAL_LIMITS (0, (NM-1))
            #include BOOST_PP_LOCAL_ITERATE()

            return retVal;
        }
    }

    std::vector<std::function<Real(Real, Real)> >
    GaussNonCentralChiSquaredPolynomial::moments = {};

    GaussNonCentralChiSquaredPolynomial::GaussNonCentralChiSquaredPolynomial(
        Real nu, Real lambda)
    : nu_(nu), lambda_(lambda) {
        if (moments.empty())
            moments = initMoments();
    }


    Real GaussNonCentralChiSquaredPolynomial::moment(Size i) const {
        QL_REQUIRE(i < moments.size() , "only moments up to "
                << moments.size() << " are supported.");
        return moments[i](nu_, lambda_);
    }

    Real GaussNonCentralChiSquaredPolynomial::w(Real x) const {
        return boost::math::pdf(
            boost::math::non_central_chi_squared_distribution<Real>
                (nu_, lambda_), x);    }

}
