
# NAME

osmium-renumber - renumber object IDs


# SYNOPSIS

**osmium renumber** \[*OPTIONS*\] *INPUT-FILE*


# DESCRIPTION

The objects (nodes, ways, and relations) in an OSM file often have very large
IDs. This can make some kinds of postprocessing difficult. This command will
renumber all objects using IDs starting at 1. Referential integrity will be
kept.

This command can only be run on OSM files sorted in the usual way (nodes first,
then ways, then IDs). It will read the input file twice, so it will not work
with STDIN.

This command needs quite a bit of main memory to keep the mapping between old
and new IDs. It is intended for small extracts. Don't try to run this on a full
planet!

You must never upload the data generated by this command to OSM! This would
really confuse the OSM database because it knows the objects under different
IDs.


# OPTIONS

-f, --output-format=FORMAT
:   The format of the output file. Can be used to set the output file format
    if it can't be autodetected from the output file name.
    **See osmium-file-formats**(5) or the libosmium manual for details.

-F, --input-format=FORMAT
:   The format of the input file. Can be used to set the input format if it
    can't be autodetected from the file name. See **osmium-file-formats**(5)
    or the libosmium manual for details.

--generator=NAME
:   The name and version of the program generating the output file. It will be
    added to the header of the output file. Default is "*osmium/*" and the
    version of osmium.

-i, --index-directory=DIR
:   Directory where the index files for mapping between old and news IDs are
    read from and written to, respectively. Use this if you want to map IDs
    in several OSM files. Without this option, the indexes are not read from
    or written to disk. The directory must exist. Use '.' for the current
    directory. The files written will be named `nodes.idx`, `ways.idx`, and
    `relations.idx`.

-o, --output=FILE
:   Name of the output file. Default is '-' (*stdout*).

--output-header=OPTION
:   Add output header option. This option can be given several times. See the
    *libosmium manual* for a list of allowed header options.

-O, --overwrite
:   Allow an existing output file to be overwritten. Normally **osmium** will
    refuse to write over an existing file.

--fsync
:   Call fsync after writing the output file to force the OS to flush buffers
    to disk.

-v, --verbose
:   Set verbose mode. The program will output information about what it is
    doing to *stderr*.


# DIAGNOSTICS

**osmium renumber** exits with exit code

0
  ~ if everything went alright,

1
  ~ if there was an error processing the data, or

2
  ~ if there was a problem with the command line arguments.


# EXAMPLES

Renumber a PBF file and output to a compressed XML file:

    osmium renumber -o ch.osm.bz2 switzerland.osm.pbf

Renumbering Switzerland currently (summer 2015) takes only about a minute and
needs a bit more than 2 GB RAM.

Renumber an OSM file storing the indexes on disk:

    osmium renumber -i. -o renumbered.osm data.osm

then rewrite a change file, too:

    osmium renumber -i. -o renumbered.osc changes.osc


# SEE ALSO

* **osmium**(1), **osmium-file-formats**(5)
* [Osmium website](http://osmcode.org/osmium)

