%feature("docstring") OT::GumbelMuSigma
R"RAW(Gumbel distribution parameters.

Parameters
----------
mu : float
    Mean.

    Default value is :math:`\gamma_e`.
sigma : float
    Standard deviation :math:`\sigma > 0`.

    Default value is :math:`\frac{\pi}{\sqrt{6}}`.

Notes
-----
Let :math:`X` be a random variable that follows a Gumbel distribution
such that:

.. math::

    \Expect{X} &= \mu \\
    \Var{X} &= \sigma^2

The native parameters  :math:`(\beta, \gamma)` are defined as follows:

.. math::
    :nowrap:

    \begin{eqnarray*}
        \mu & = & \gamma + \gamma_e \beta \\
        \sigma^2 & = & \frac{1}{6} \pi^2 \beta^2
    \end{eqnarray*}

where :math:`\gamma_e` is the Euler-Mascheroni constant.

The default values of :math:`(\mu, \sigma)` are defined so that the associated native parameters
have the default values: :math:`(\beta, \gamma) = (1.0, 0.0)`.


See also
--------
Gumbel

Examples
--------
Create the parameters :math:`(\mu, \sigma)` of the Gumbel distribution:

>>> import openturns as ot
>>> parameters = ot.GumbelMuSigma(1.5, 1.3)

Convert parameters into the native parameters :math:`(\beta, \gamma)`:

>>> print(parameters.evaluate())
[1.01361,0.914931])RAW"
