// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003-2007 - Steve Merrony

/* This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> or
    write to the Free Software Foundation, 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA
*/

#ifndef MIDITHREAD_H
#define MIDITHREAD_H

#include <QThread>

#include "application.h"
#include "console.h"

class MidiThread : public QThread {
Q_OBJECT

	public:

		MidiThread( QObject * );
		~MidiThread();
		
	signals:
		void pistonChangeSignal( int , int );
		void toePistonChangeSignal( int );
	
	protected:
		void run();

	private:
		Console *tconsole;

		void connectDefaultPorts( midi_seq *, midi_port *, midi_port *, midi_port *, Console * );
};

#endif
