#include <stdio.h>

// ------------------------- Marker classes ----------------------------

struct HighPriority {};
struct MediumPriority {};
struct LowPriority {};

// --------------------------- Aspect code -----------------------------

aspect A1 : MediumPriority {
  advice execution("void run()") : before() {
    printf("A1 (medium)\n");
  }
};

aspect A2 : HighPriority {
  advice execution("void run()") : before() {
    printf("A2 (high)\n");
  }
};

aspect A3 : LowPriority {
  advice execution("void run()") : before() {
    printf("A3 (low)\n");
  }
};

aspect WeNeedOrder {
  advice execution("void run()") :
    // order("A2", "A1", "A3");
    order(derived("HighPriority"), derived("MediumPriority"), derived("LowPriority"));
};

// ------------------------------- normal C++ ---------------------------- 

void run()  { printf("run\n"); }

int main () { 
  run();
}
