#! /bin/bash

TMP=tmp
RFC=$TMP/usr/share/doc/RFC

rm -rf $RFC
mkdir -p $RFC/queue
mkdir -p $RFC/links
ln -i $( sed -e 's,^,extra/,' rfc-queue.txt | grep -v '\[missing]' ) \
    $RFC/queue 2>ln-failed.log

#ln -i .keepdir $TMP 2>>ln-failed.log

mkdir -p                    $TMP/usr/lib/doc-rfc
ln -i register-doc-rfc-docs $TMP/usr/lib/doc-rfc 2>>ln-failed.log
ln -i doc-rfc-docs          $TMP/usr/lib/doc-rfc 2>>ln-failed.log

echo "- $(date) linking RFCs"
perl makelinks.pl $RFC
# what were they smoking?!
ln -i ../rfc17a.* $RFC/unclassified 2>>ln-failed.log

echo "- $(date) linking extra files"
ln -i extra/{rfc-*.html,queue.html,rfcxx00.*} rfc-*.txt ../rfc-index.txt \
    $RFC 2>>ln-failed.log

find .. -links 1 > unused-files

echo "- $(date) compressing..."
find $RFC -type f -size +4k -print0 > files-to-compress
# don't work on a dir find is running on
cat files-to-compress | xargs -0 gzip --best -N -r -f
echo "- $(date) finished compressing"

chmod -R a-wx,a+rX,u+w $RFC
