/*
** Copyright (c) 2015-2019 The Khronos Group Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a copy
** of this software and/or associated documentation files (the "Materials"),
** to deal in the Materials without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Materials, and to permit persons to whom the
** Materials are furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Materials.
**
** MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS KHRONOS
** STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS SPECIFICATIONS AND
** HEADER INFORMATION ARE LOCATED AT https://www.khronos.org/registry/ 
**
** THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
** OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
** THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
** IN THE MATERIALS.
*/

#ifndef OPENCLstd_H
#define OPENCLstd_H

#ifdef __cplusplus
namespace OpenCLLIB {

enum Entrypoints {

    // Section 2.1: Math extended instructions
    Acos = 0,
    Acosh = 1,
    Acospi = 2,
    Asin = 3,
    Asinh = 4,
    Asinpi = 5,
    Atan = 6,
    Atan2 = 7,
    Atanh = 8,
    Atanpi = 9,
    Atan2pi = 10,
    Cbrt = 11,
    Ceil = 12,
    Copysign = 13,
    Cos = 14,
    Cosh = 15,
    Cospi = 16,
    Erfc = 17,
    Erf = 18,
    Exp = 19,
    Exp2 = 20,
    Exp10 = 21,
    Expm1 = 22,
    Fabs = 23,
    Fdim = 24,
    Floor = 25,
    Fma = 26,
    Fmax = 27,
    Fmin = 28,
    Fmod = 29,
    Fract = 30, 
    Frexp = 31,
    Hypot = 32,
    Ilogb = 33,
    Ldexp = 34,
    Lgamma = 35,
    Lgamma_r = 36,
    Log = 37,
    Log2 = 38,
    Log10 = 39,
    Log1p = 40,
    Logb = 41,
    Mad = 42,
    Maxmag = 43,
    Minmag = 44,
    Modf = 45,
    Nan = 46,
    Nextafter = 47,
    Pow = 48,
    Pown = 49,
    Powr = 50,
    Remainder = 51,
    Remquo = 52,
    Rint = 53,
    Rootn = 54,
    Round = 55,
    Rsqrt = 56,
    Sin = 57,
    Sincos = 58,
    Sinh = 59,
    Sinpi = 60,
    Sqrt = 61,
    Tan = 62,
    Tanh = 63,
    Tanpi = 64,
    Tgamma = 65,
    Trunc = 66,
    Half_cos = 67,
    Half_divide = 68,
    Half_exp = 69,
    Half_exp2 = 70,
    Half_exp10 = 71,
    Half_log = 72,
    Half_log2 = 73,
    Half_log10 = 74,
    Half_powr = 75,
    Half_recip = 76,
    Half_rsqrt = 77,
    Half_sin = 78,
    Half_sqrt = 79,
    Half_tan = 80,
    Native_cos = 81,
    Native_divide = 82,
    Native_exp = 83,
    Native_exp2 = 84,
    Native_exp10 = 85,
    Native_log = 86,
    Native_log2 = 87,
    Native_log10 = 88,
    Native_powr = 89,
    Native_recip = 90,
    Native_rsqrt = 91,
    Native_sin = 92,
    Native_sqrt = 93,
    Native_tan = 94,
    
    // Section 2.2: Integer instructions
    SAbs = 141,
    SAbs_diff = 142,
    SAdd_sat = 143,
    UAdd_sat = 144,
    SHadd = 145,
    UHadd = 146,
    SRhadd = 147,
    URhadd = 148,
    SClamp = 149,
    UClamp = 150, 
    Clz = 151,
    Ctz = 152,    
    SMad_hi = 153,
    UMad_sat = 154,
    SMad_sat = 155,
    SMax = 156,
    UMax = 157,
    SMin = 158,
    UMin = 159,
    SMul_hi = 160,
    Rotate = 161,
    SSub_sat = 162,
    USub_sat = 163,
    U_Upsample = 164,
    S_Upsample = 165,
    Popcount = 166,
    SMad24 = 167,
    UMad24 = 168,
    SMul24 = 169,
    UMul24 = 170,
    UAbs = 201,
    UAbs_diff = 202,
    UMul_hi = 203,
    UMad_hi = 204,

    // Section 2.3: Common instructions
    FClamp = 95,
    Degrees = 96,
    FMax_common = 97,
    FMin_common = 98, 
    Mix = 99,
    Radians = 100,
    Step = 101,
    Smoothstep = 102,
    Sign = 103,

    // Section 2.4: Geometric instructions
    Cross = 104,
    Distance = 105, 
    Length = 106,
    Normalize = 107,
    Fast_distance = 108,
    Fast_length = 109,
    Fast_normalize = 110,

    // Section 2.5: Relational instructions
    Bitselect = 186,
    Select = 187,

    // Section 2.6: Vector Data Load and Store instructions
    Vloadn = 171,
    Vstoren = 172,
    Vload_half = 173,
    Vload_halfn = 174,
    Vstore_half = 175,
    Vstore_half_r = 176,
    Vstore_halfn = 177,
    Vstore_halfn_r = 178,
    Vloada_halfn = 179,
    Vstorea_halfn = 180,
    Vstorea_halfn_r = 181,

    // Section 2.7: Miscellaneous Vector instructions
    Shuffle = 182,
    Shuffle2 = 183,

    // Section 2.8: Misc instructions 
    Printf = 184,
    Prefetch = 185,
};

} // end namespace OpenCLLIB

#else

enum OpenCLstd_Entrypoints {

    // Section 2.1: Math extended instructions
    OpenCLstd_Acos = 0,
    OpenCLstd_Acosh = 1,
    OpenCLstd_Acospi = 2,
    OpenCLstd_Asin = 3,
    OpenCLstd_Asinh = 4,
    OpenCLstd_Asinpi = 5,
    OpenCLstd_Atan = 6,
    OpenCLstd_Atan2 = 7,
    OpenCLstd_Atanh = 8,
    OpenCLstd_Atanpi = 9,
    OpenCLstd_Atan2pi = 10,
    OpenCLstd_Cbrt = 11,
    OpenCLstd_Ceil = 12,
    OpenCLstd_Copysign = 13,
    OpenCLstd_Cos = 14,
    OpenCLstd_Cosh = 15,
    OpenCLstd_Cospi = 16,
    OpenCLstd_Erfc = 17,
    OpenCLstd_Erf = 18,
    OpenCLstd_Exp = 19,
    OpenCLstd_Exp2 = 20,
    OpenCLstd_Exp10 = 21,
    OpenCLstd_Expm1 = 22,
    OpenCLstd_Fabs = 23,
    OpenCLstd_Fdim = 24,
    OpenCLstd_Floor = 25,
    OpenCLstd_Fma = 26,
    OpenCLstd_Fmax = 27,
    OpenCLstd_Fmin = 28,
    OpenCLstd_Fmod = 29,
    OpenCLstd_Fract = 30, 
    OpenCLstd_Frexp = 31,
    OpenCLstd_Hypot = 32,
    OpenCLstd_Ilogb = 33,
    OpenCLstd_Ldexp = 34,
    OpenCLstd_Lgamma = 35,
    OpenCLstd_Lgamma_r = 36,
    OpenCLstd_Log = 37,
    OpenCLstd_Log2 = 38,
    OpenCLstd_Log10 = 39,
    OpenCLstd_Log1p = 40,
    OpenCLstd_Logb = 41,
    OpenCLstd_Mad = 42,
    OpenCLstd_Maxmag = 43,
    OpenCLstd_Minmag = 44,
    OpenCLstd_Modf = 45,
    OpenCLstd_Nan = 46,
    OpenCLstd_Nextafter = 47,
    OpenCLstd_Pow = 48,
    OpenCLstd_Pown = 49,
    OpenCLstd_Powr = 50,
    OpenCLstd_Remainder = 51,
    OpenCLstd_Remquo = 52,
    OpenCLstd_Rint = 53,
    OpenCLstd_Rootn = 54,
    OpenCLstd_Round = 55,
    OpenCLstd_Rsqrt = 56,
    OpenCLstd_Sin = 57,
    OpenCLstd_Sincos = 58,
    OpenCLstd_Sinh = 59,
    OpenCLstd_Sinpi = 60,
    OpenCLstd_Sqrt = 61,
    OpenCLstd_Tan = 62,
    OpenCLstd_Tanh = 63,
    OpenCLstd_Tanpi = 64,
    OpenCLstd_Tgamma = 65,
    OpenCLstd_Trunc = 66,
    OpenCLstd_Half_cos = 67,
    OpenCLstd_Half_divide = 68,
    OpenCLstd_Half_exp = 69,
    OpenCLstd_Half_exp2 = 70,
    OpenCLstd_Half_exp10 = 71,
    OpenCLstd_Half_log = 72,
    OpenCLstd_Half_log2 = 73,
    OpenCLstd_Half_log10 = 74,
    OpenCLstd_Half_powr = 75,
    OpenCLstd_Half_recip = 76,
    OpenCLstd_Half_rsqrt = 77,
    OpenCLstd_Half_sin = 78,
    OpenCLstd_Half_sqrt = 79,
    OpenCLstd_Half_tan = 80,
    OpenCLstd_Native_cos = 81,
    OpenCLstd_Native_divide = 82,
    OpenCLstd_Native_exp = 83,
    OpenCLstd_Native_exp2 = 84,
    OpenCLstd_Native_exp10 = 85,
    OpenCLstd_Native_log = 86,
    OpenCLstd_Native_log2 = 87,
    OpenCLstd_Native_log10 = 88,
    OpenCLstd_Native_powr = 89,
    OpenCLstd_Native_recip = 90,
    OpenCLstd_Native_rsqrt = 91,
    OpenCLstd_Native_sin = 92,
    OpenCLstd_Native_sqrt = 93,
    OpenCLstd_Native_tan = 94,
    
    // Section 2.2: Integer instructions
    OpenCLstd_SAbs = 141,
    OpenCLstd_SAbs_diff = 142,
    OpenCLstd_SAdd_sat = 143,
    OpenCLstd_UAdd_sat = 144,
    OpenCLstd_SHadd = 145,
    OpenCLstd_UHadd = 146,
    OpenCLstd_SRhadd = 147,
    OpenCLstd_URhadd = 148,
    OpenCLstd_SClamp = 149,
    OpenCLstd_UClamp = 150, 
    OpenCLstd_Clz = 151,
    OpenCLstd_Ctz = 152,    
    OpenCLstd_SMad_hi = 153,
    OpenCLstd_UMad_sat = 154,
    OpenCLstd_SMad_sat = 155,
    OpenCLstd_SMax = 156,
    OpenCLstd_UMax = 157,
    OpenCLstd_SMin = 158,
    OpenCLstd_UMin = 159,
    OpenCLstd_SMul_hi = 160,
    OpenCLstd_Rotate = 161,
    OpenCLstd_SSub_sat = 162,
    OpenCLstd_USub_sat = 163,
    OpenCLstd_U_Upsample = 164,
    OpenCLstd_S_Upsample = 165,
    OpenCLstd_Popcount = 166,
    OpenCLstd_SMad24 = 167,
    OpenCLstd_UMad24 = 168,
    OpenCLstd_SMul24 = 169,
    OpenCLstd_UMul24 = 170,
    OpenCLstd_UAbs = 201,
    OpenCLstd_UAbs_diff = 202,
    OpenCLstd_UMul_hi = 203,
    OpenCLstd_UMad_hi = 204,

    // Section 2.3: Common instructions
    OpenCLstd_FClamp = 95,
    OpenCLstd_Degrees = 96,
    OpenCLstd_FMax_common = 97,
    OpenCLstd_FMin_common = 98, 
    OpenCLstd_Mix = 99,
    OpenCLstd_Radians = 100,
    OpenCLstd_Step = 101,
    OpenCLstd_Smoothstep = 102,
    OpenCLstd_Sign = 103,

    // Section 2.4: Geometric instructions
    OpenCLstd_Cross = 104,
    OpenCLstd_Distance = 105, 
    OpenCLstd_Length = 106,
    OpenCLstd_Normalize = 107,
    OpenCLstd_Fast_distance = 108,
    OpenCLstd_Fast_length = 109,
    OpenCLstd_Fast_normalize = 110,

    // Section 2.5: Relational instructions
    OpenCLstd_Bitselect = 186,
    OpenCLstd_Select = 187,

    // Section 2.6: Vector Data Load and Store instructions
    OpenCLstd_Vloadn = 171,
    OpenCLstd_Vstoren = 172,
    OpenCLstd_Vload_half = 173,
    OpenCLstd_Vload_halfn = 174,
    OpenCLstd_Vstore_half = 175,
    OpenCLstd_Vstore_half_r = 176,
    OpenCLstd_Vstore_halfn = 177,
    OpenCLstd_Vstore_halfn_r = 178,
    OpenCLstd_Vloada_halfn = 179,
    OpenCLstd_Vstorea_halfn = 180,
    OpenCLstd_Vstorea_halfn_r = 181,

    // Section 2.7: Miscellaneous Vector instructions
    OpenCLstd_Shuffle = 182,
    OpenCLstd_Shuffle2 = 183,

    // Section 2.8: Misc instructions 
    OpenCLstd_Printf = 184,
    OpenCLstd_Prefetch = 185,
};

#endif

#endif  // #ifndef OPENCLstd_H
