# Contributing

Contributions of all kinds are very welcome. Check the

- [Welcome to GNOME: Loupe](https://welcome.gnome.org/app/Loupe/)

pages for more information. If you are manually building Loupe on your system with Builder, make sure that you also have installed the [nightly version](https://welcome.gnome.org/app/Loupe/#installing-a-nightly-build) for all features to work. Otherwise, the development version will not have the required Flatpak permissions.

Documentation of Loupe's code is available online:

- [Loupe Code Documentation](https://gnome.pages.gitlab.gnome.org/loupe/doc/loupe/)

## Issue Tracker

Issues labeled as ~"1. Feature" or ~"1. Enhancement" are accepted for implementation. Feature requests that still need a decission are labeld as ~"2. RFC".

## Code of Conduct

When interacting with the project, the [GNOME Code Of Conduct](https://conduct.gnome.org/) applies.

## Help format

The help pages are currently written in [ducktype](http://projectmallard.org/ducktype/1.0/index.html). The files are stored in `help/C/duck` and the corresponding `.page`-files can be generated via `make -C help/C/`. Afterwards, you can preview the generated help pages via `yelp help/C/index.page`. The generated `.page`-files have to be committed to the repository as well. The `ducktype` program required for running `make` is probably packaged in you distro and is also [availabe on GitHub](https://github.com/projectmallard/mallard-ducktype).

## Use of Generative AI

This project does not allow contributions generated by large languages models (LLMs) and chatbots. This ban includes tools like ChatGPT, Claude, Copilot, DeepSeek, and Devin AI. We are taking these steps as precaution due to the potential negative influence of AI generated content on quality, as well as likely copyright violations.

This ban of AI generated content applies to all parts of the projects, including, but not limited to, code, documentation, issues, and artworks. An exception applies for purely translating texts for issues and comments to English.

AI tools can be used to answer questions and find information. However, we encourage contributors to avoid them in favor of using [existing documentation](https://developer.gnome.org) and our [chats and forums](https://welcome.gnome.org). Since AI generated information is frequently misleading or false, we cannot supply support on anything referencing AI output.
