/***************************************************************************
                          usercommands.h  -  description
                             -------------------
    begin                : Tue Sep 19 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef USERCOMMANDS_H
#define USERCOMMANDS_H


/**
  *@author Henrik Stormer
  */
#include <qobject.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <qlist.h>
#include <kaction.h>

class UserDialog;
class KConfig;
class QPopupMenu;
class KActionCollection;

class UserCommandEntry
{
 public:
  UserCommandEntry(const QString& Name, const QString& Command, const QString& IconName)
   : _Name(Name), _Command(Command), _IconName(IconName)  {}

  UserCommandEntry(const QString& Name)
  : _Name(Name) {}

  UserCommandEntry() {}

  bool operator == (const QString& EntryName) const {return _Name == EntryName;}
  bool operator == (const UserCommandEntry& Entry) const {return _Name == Entry._Name;}

  QString _Name;
  QString _Command;
  QString _IconName;
};

class UserCommands : public QObject
{
  Q_OBJECT

  friend UserDialog;
public: 
	UserCommands(KConfig* Config, KActionCollection*, QPopupMenu*);
	virtual ~UserCommands();

  void loadEntries();
  void saveEntries();

  void addEntry(const QString& Name, const QString& Command, const QString& IconName);
  void removeEntry(const QString& Name);

  KActionCollection* actionCollection() {return _Coll;}
  void createActions();
  void removeActions();

 public:
  signals:

  void executeCommand(const QString&);

 protected slots:

  virtual void slotCommandSelected();

 private:
  KConfig*                     _Config;
  QValueList<UserCommandEntry> _Commands;
  KActionCollection*           _Coll;
  QPopupMenu*                  _Menu;
  QList<KAction>               _Actions;
};

#endif
