/***************************************************************************
                          kncfilecommand.cpp  -  description
                             -------------------
    begin                : Tue Aug 29 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include <klocale.h>
#include <kio/jobclasses.h>
#include <kio/job.h>

#include "kncfilecommand.h"
#include "selectdialog.h"

KNCFileCommand* KNCFileCommand::_instance;

KNCFileCommand::KNCFileCommand() : QObject(), _bShowDeleteMessageBox(true) {
}
KNCFileCommand::~KNCFileCommand(){
}

void KNCFileCommand::copy(const KURL::List& SourceList, const KURL& Dest)
{
  KURL XDest = Dest;

  if (XDest.path().left(1) != "/")
     XDest.setPath(SourceList.first().directory(0) + XDest.path());

  KIO::CopyJob* CJob = KIO::copy (SourceList, XDest);
}

void KNCFileCommand::move(const KURL::List& SourceList, const KURL& Dest)
{
  KURL XDest = Dest;

  if (XDest.path().left(1) != "/")
     XDest.setPath(SourceList.first().directory(0) + XDest.path());

  KIO::CopyJob* CJob = KIO::move (SourceList, XDest);
}

void KNCFileCommand::link(const KURL::List& SourceList, const KURL& Dest)
{
  KURL XDest = Dest;

  if (XDest.path().left(1) != "/")
     XDest.setPath(SourceList.first().directory(0) + XDest.path());

  KIO::CopyJob* CJob = KIO::link (SourceList, XDest);
}

void KNCFileCommand::newDir(const KURL& NewDir)
{
 SelectDialog Dialog(NULL, i18n("New Directory"), i18n("New Directory Name:"));
 if (Dialog.exec())
 {
   KURL NewDirName;
   NewDirName.setPath (NewDir.path(1) + Dialog.getText());
   KIO::mkdir(NewDirName);
 }
}

void KNCFileCommand::deleteFiles(const KURL::List& SourceList)
{
  if (SourceList.isEmpty()) return;
  if (_bShowDeleteMessageBox)
  {
    QString D1;
    int clicked = QMessageBox::warning( NULL, i18n("KNC"), i18n("Really delete ") + D1.setNum(SourceList.count()) + i18n(" files/directories?"),
                                       QMessageBox::Ok|QMessageBox::Default, QMessageBox::Cancel);
    if (clicked == QMessageBox::Cancel) return;
  }

  KIO::DeleteJob* DelJob = KIO::del (SourceList, false);
}

