/***************************************************************************
                          knc.h  -  description
                             -------------------
    begin                : Tue Aug 29 14:51:43 CEST 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNC_H
#define KNC_H
 

// include files for Qt
#include <qstrlist.h>

// include files for KDE 
#include <kparts/mainwindow.h>
#include <kurl.h>
#include <kbookmark.h>

#include "kncview.h"

class KNCFileCommand;
class KNCDirectoryToolBar;
class KNCCommandToolBar;
class KNCCursorToolBar;
class QSplitter;
class KAction;
class KToggleAction;
class KActionMenu;
class KBookmarkMenu;
class UserCommands;

class KNCApp : public KParts::MainWindow, KBookmarkOwner
{
  Q_OBJECT

  public:
    /** construtor of KNCApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    KNCApp();
    ~KNCApp();

  protected:
    void saveSettings(KConfig*);
    void readSettings(KConfig*);

    void initKeyAccel();
    void initMenuBar();
    void initToolBar();
    void initStatusBar();
    void initView();

    void select(bool Selection, QString Text);

    virtual void    openBookmarkURL(const QString& _url);
    virtual QString currentTitle() const;
    virtual QString currentURL() const;

  public slots:

    void slotLeftViewFocusIn();
    void slotRightViewFocusIn();
    void slotCommandLineFocusIn();
    void slotCommandLineFocusOut();

    void slotCommandUp();
    void slotCommandHome();
    void slotCommandRefresh();
    void slotCommandView();
    void slotCommandEdit();
    void slotCommandCopy();
    void slotCommandMove();
    void slotCommandNewDir();
    void slotCommandDelete();
    void slotCommandSelect();
    void slotCommandUnselect();
    void slotCommandOpenTerminal();
    void slotCommandOpenFindUtility();
    void slotCommandOpenUserMenu();
    void slotCommandChangeAttributes();
    void slotCommandQuit();

    void slotViewToolBar();
    void slotViewCursorLine();
    void slotViewDirectoryLine();
    void slotViewCommandLine();

    void slotBookmarkAdd();
    void slotBookmarkRemove();
    void slotBookmarkChosen(int id);

    void slotOptionsPreferences();
    void slotOptionsEditKeys();
    void slotOptionsEditToolBar();

    void slotSelectionChanged(KNCListView*);
    void slotLeftSelectionChanged();
    void slotRightSelectionChanged();
    void slotCursorChanged(KNCListView*);
    void slotLeftCursorChanged();
    void slotRightCursorChanged();
    void slotDirectoryChanged (KNCListView*, const KURL&);
    void slotLeftDirectoryChanged (const KURL&);
    void slotRightDirectoryChanged (const KURL&);

    void slotLeftReturnPressed();
    void slotRightReturnPressed();

    void slotExecute(const QString&);
    void slotExecuteFile(const KURL&);
    void slotExecuteCommandLine();
    void slotExecuteCommand(const QString&);

    void slotRemovePart();

   protected:
    signals:
     void directoryChanged(const KURL&);
   protected:

     void setActListView(bool);
     KNCListView* getInactiveListView();
     void addPart(KParts::ReadOnlyPart*);

  private:
    KParts::ReadOnlyPart* _Part;
    KNCListView         *_LeftListView, *_RightListView, *_ActListView;
    QSplitter*           _LRSplitter;
    KNCDirectoryToolBar* _DirectoryToolBar;
    KNCCommandToolBar*   _CommandToolBar;
    KNCCursorToolBar*    _CursorToolBar;
    QString              _Edit, _View, _Terminal, _Find;
    KActionMenu*         _Bookmarks;
    KBookmarkMenu*       _BookmarkMenu;
    UserCommands*        _UserCommands;
    bool                 _bShowPartComplete, _bUseParts;
    KToggleAction*          _ViewToolBarAction, *_ViewCursorAction, *_ViewCommandAction, *_ViewDirectoryAction;
};
 
#endif // KNC_H
