/****************************************************************************************
 * Copyright (c) 2008 Daniel Caleb Jones <danielcjones@gmail.com>                       *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) version 3 or        *
 * any later version accepted by the membership of KDE e.V. (or its successor approved  *
 * by the membership of KDE e.V.), which shall act as a proxy defined in Section 14 of  *
 * version 3 of the license.                                                            *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef AMAROK_BIASEDPLAYLIST_H
#define AMAROK_BIASEDPLAYLIST_H

#include "Bias.h"
#include "DynamicPlaylist.h"
#include "core/meta/Meta.h"

#include "amarok_export.h" // we are exporting it for the tests

#include <QObject>
#include <QMutex>
#include <QPointer>

class QXmlStreamWriter;
class QXmlStreamReader;

namespace Dynamic
{
    class BiasSolver;

    /** A concrete implementation of the DynamicPlaylist that uses a bias structure to determine new tracks.
    */
    class AMAROK_EXPORT BiasedPlaylist : public DynamicPlaylist
    {
        Q_OBJECT

        public:
            /** Creates a new random playlist */
            BiasedPlaylist( QObject *parent = 0 );

            /** Creates a new playlist from an xml stream */
            BiasedPlaylist( QXmlStreamReader *reader, QObject *parent = 0 );

            ~BiasedPlaylist();

            void toXml( QXmlStreamWriter *writer ) const;

            void requestTracks(int);

            BiasPtr bias() const;

        signals:
            void totalSteps( int );
            void endProgressOperation( QObject * );

        public slots:
            virtual void repopulate();
            virtual void requestAbort();

        private slots:
            void solverFinished();
            void biasChanged();
            void biasReplaced( Dynamic::BiasPtr oldBias, Dynamic::BiasPtr newBias );
            void updateStatus( int progress );

        private:
            /** Starts the BiasSolver (if not already running) and requests a couple of new tracks. */
            void startSolver();
            void handleRequest();

            /** Returns all the tracks that will come before the newly generated ones. */
            Meta::TrackList getContext();

            Meta::TrackList m_buffer;
            QMutex m_bufferMutex;

            int m_numRequested;

            /** The bias this playlist uses */
            BiasPtr m_bias;

            /** A currently running BiasSolver */
            QPointer<BiasSolver> m_solver;

            static const int BUFFER_SIZE;
    };
}

// Q_DECLARE_METATYPE( Dynamic::BiasedPlaylistPtr )

#endif

