/***************************************************************************
                          kstlogtable.cpp -  description
                             -------------------
    begin                : Thu Mar 4 2004
    copyright            : (C) 2004 The University of British Columbia 
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>


#include "kstlogtable.h"

KstLogTable::KstLogTable(QWidget *parent, const char *name )
: QTable(parent, name) {
  _moveToLast = false;
  _last = 0;
}

void KstLogTable::setDebug(KstDebug *debug) {
  _debug = debug;
}

void KstLogTable::clear() {
  setNumRows(0);
  _last = 0;
}

void KstLogTable::hideRows(KstDebug::LogLevel level, bool doHide, int start) {
  const QValueList<KstDebug::LogMessage>& messages = KstDebug::self()->messages();
  int numRows = messages.count();

  setUpdatesEnabled(false);

  for (int i = start; i < numRows; i++) {
    if (messages[i].level == level) {
      if (doHide) {
        hideRow(i);
      } else {
        showRow(i);
      }
    }
  }

  hide();
  show();

  setUpdatesEnabled(true);
}

void KstLogTable::paintEvent(QPaintEvent *e) {
  int rowCount = KstDebug::self()->messages().count();
  _last = rowCount;
  
  if (rowCount != numRows()) {
    setNumRows(rowCount);
  }

  if (_moveToLast) {
    ensureCellVisible(rowCount - 1, 0);
    _moveToLast = false;
  }
  
  QTable::paintEvent(e);
}

void KstLogTable::paintCell(QPainter *painter, int row, int col, const QRect& cr, bool selected, const QColorGroup& cg) {
  int margin;
  int height;
  int step;
  
  if (selected) {
    painter->eraseRect( 0, 0, cr.width(), cr.height() );
    painter->fillRect( 0, 0, cr.width(), cr.height(), cg.highlight() );
    painter->setPen(cg.highlightedText());
  } else {
    painter->eraseRect( 0, 0, cr.width(), cr.height() );
    painter->fillRect( 0, 0, cr.width(), cr.height(), cg.base() );
    painter->setPen(cg.text());
  }

  if (_debug->messages().count() > (unsigned int)row) {
    margin = cr.height()/5;
    if (margin == 0) {
      margin = 1;
    }
    height = cr.height() - ( 2 * margin );
    step   = height / 4;
    if (step == 0) {
      step = 1;
    }
    if (col == 0) {
      QPointArray pointArray;
      QColor color;
      switch (_debug->messages()[row].level) {
        case KstDebug::Notice:
          color.setNamedColor("LightSeaGreen");
          painter->setBrush(color);
          painter->drawEllipse(margin, margin, height, height);
          break;
        case KstDebug::Warning:
          pointArray.putPoints(0, 3, margin, margin, 
              margin + height, margin, 
              margin + ( height / 2 ), margin + height);
          color.setNamedColor("DarkOrange");
          painter->setBrush(color);
          painter->drawPolygon(pointArray);
          break;
        case KstDebug::Error:
          color.setNamedColor("Red");
          painter->setBrush(color);
          pointArray.putPoints(0, 8, 
              margin + ( 0 * step ), margin + ( 1 * step ), 
              margin + ( 0 * step ), margin + ( 3 * step ), 
              margin + ( 1 * step ), margin + ( 4 * step ), 
              margin + ( 3 * step ), margin + ( 4 * step ), 
              margin + ( 4 * step ), margin + ( 3 * step ), 
              margin + ( 4 * step ), margin + ( 1 * step ), 
              margin + ( 3 * step ), margin + ( 0 * step ), 
              margin + ( 1 * step ), margin + ( 0 * step )); 
          painter->drawPolygon(pointArray);
          break;
        case KstDebug::Debug:
          color.setNamedColor("DeepSkyBlue");
          painter->setBrush(color);
          painter->drawRoundRect(margin, margin, 
              height, height, 
              height / 3, height / 3);
          break;
        default:
          break;
      }
      painter->drawText(height + 2*margin, 0, 
          cr.width() - height - 2*margin, cr.height(), 
          AlignLeft, 
          _debug->label(_debug->messages()[row].level));
    } else if (col == 1) {    
      QString str = _debug->messages()[row].date.toString();
      painter->drawText(0, 0, cr.width(), cr.height(), AlignLeft, str);
    } else if (col == 2) {
      QString str = _debug->messages()[row].msg;
      painter->drawText(0, 0, cr.width(), cr.height(), AlignLeft, str);
    }
  }
}
// vim: ts=2 sw=2 et
