/***************************************************************************
                          ksteventmonitorentry.h  -  description
                             -------------------
    begin                : Tue Apr 6 2004
    copyright            : (C) 2000 by The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTEVENTMONITORENTRY_H
#define KSTEVENTMONITORENTRY_H

#include <qtimer.h>

#include "kstdebug.h"

namespace Equation {
  class Node;
  class Context;
}

class EventMonitorEntry : public KstDataObject {
  public:
    EventMonitorEntry(const QString &in_tag);
    EventMonitorEntry(QDomElement &e);
    virtual ~EventMonitorEntry();

    virtual UpdateType update(int updateCounter = -1);
    virtual void save(QTextStream &ts, const QString& indent = QString::null);
    virtual QString propertyString() const;
    virtual void _showDialog();

    bool needToEvaluate();
    bool isValid() const { return _bIsValid; }

    void log(const int& iIndex);
    const QString& getEvent() const { return _strEvent; }
    const QString& getDescription() const { return _strDescription; }
    KstDebug::LogLevel getLevel() const { return _level; }
    Equation::Node* getExpression() const { return _pExpression; }
    bool getLogKstDebug() const { return _bLogKstDebug; }
    bool getLogEMail() const { return _bLogEMail; }
    bool getLogELOG() const { return _bLogELOG; }
    const QString& getEMailRecipients() const { return _strEMailRecipients; }
    const QString& getEMailSender() const { return _strEMailSender; }
    const QString& getSMTPServer() const { return _strSMTPServer; }

    void setEvent(const QString& str);
    void setDescription(const QString& str) { _strDescription = str; }
    void setLevel(KstDebug::LogLevel level) { _level = level; }
    void setExpression(Equation::Node* pExpression) { _pExpression = pExpression; }
    void setLogKstDebug(bool bLogKstDebug) { _bLogKstDebug = bLogKstDebug; }
    void setLogEMail(bool bLogEMail) { _bLogEMail = bLogEMail; }
    void setLogELOG(bool bLogELOG) { _bLogELOG = bLogELOG; }
    void setEMailRecipients(const QString& str) { _strEMailRecipients = str; }
    void setEMailSender(const QString& str) { _strEMailSender = str; }
    void setSMTPServer(const QString& str) { _strSMTPServer = str; }

    void logImmediately();

  public slots:
    void  slotUpdate();
      
  private:
    void commonConstructor(const QString &in_tag);

    static const QString OUTXVECTOR;
    static const QString OUTYVECTOR;

    KstVectorList       _vectorsUsed;
    QValueList<int>     _indexArray;
    QString             _strEvent;
    QString             _strDescription;
    QString             _strEMailRecipients;
    QString             _strEMailSender;
    QString             _strSMTPServer;
    KstDebug::LogLevel  _level;
    Equation::Node*     _pExpression;
    KstVectorMap::Iterator _xVector;
    KstVectorMap::Iterator _yVector;
    bool                _bLogKstDebug;
    bool                _bLogEMail;
    bool                _bLogELOG;
    bool                _bIsValid;
    int                 _iNumDone;
};

typedef KstSharedPtr<EventMonitorEntry> EventMonitorEntryPtr;
typedef KstObjectList<EventMonitorEntryPtr> KstEventMonitorEntryList;

#endif
// vim: ts=2 sw=2 et
