/**************************************************************************
        kstchangefiledialog_i.cpp - source file: inherits designer dialog
                             -------------------
    begin                :  2001
    copyright            : (C) 2000-2003 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qcombobox.h>
#include <qfontdatabase.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qwidget.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kurl.h>
#include <kurlrequester.h>

#include "kst.h"
#include "kstchangefiledialog_i.h"
#include "kstdatacollection.h"
#include "kstrvector.h"
#include "kstvectordefaults.h"

KstChangeFileDialogI::KstChangeFileDialogI(QWidget* parent,
                                           const char* name,
                                           bool modal,
                                           WFlags fl)
: KstChangeFileDialog(parent, name, modal, fl) {

    connect(ChangeFileClear,     SIGNAL(clicked()),
            ChangeFileCurveList, SLOT(clearSelection()));
    connect(ChangeFileSelectAll, SIGNAL(clicked()),
            this,                SLOT(selectAll()));
    connect(ChangeFileApply,     SIGNAL(clicked()),
            this,                SLOT(applyFileChange()));
}

KstChangeFileDialogI::~KstChangeFileDialogI() {
}

void KstChangeFileDialogI::selectAll() {
  ChangeFileCurveList->selectAll(true);
}

void KstChangeFileDialogI::updateChangeFileDialog() {
  ChangeFileCurveList->clear();

  KstRVectorList rvl = kstObjectSubList<KstVector,KstRVector>(KST::vectorList);
  /* insert vectors into ChangeFileCurveList */
  for (int i = 0; i < (int)rvl.count(); i++) {
    rvl[i]->readLock();
    ChangeFileCurveList->insertItem(rvl[i]->tagName(), -1);
    rvl[i]->readUnlock();
  }

  _dataFile->setURL(KST::vectorDefaults.dataSource());
}

void KstChangeFileDialogI::showChangeFileDialog() {
  updateChangeFileDialog();

  show();
  raise();
}

void KstChangeFileDialogI::applyFileChange() {
  KstDataSourcePtr file;
  KstWriteLocker ml(&KST::dataSourceList.lock());

  KstDataSourceList::Iterator it = KST::dataSourceList.findFileName(_dataFile->url());

  if (it == KST::dataSourceList.end()) {
    file = KstDataSource::loadSource(_dataFile->url());
    if (!file || !file->isValid()) {
      KMessageBox::sorry(0L, i18n("The file could not be loaded."));
      return;
    }
    if (file->isEmpty()) {
      KMessageBox::sorry(0L, i18n("The file does not contain data."));
      return;
    }
    KST::dataSourceList.append(file);
  } else {
    file = *it;
  }

  file->writeLock();

  KstRVectorList rvl = kstObjectSubList<KstVector,KstRVector>(KST::vectorList);
  for (int i = 0; i < (int)ChangeFileCurveList->count(); i++) {
    if (ChangeFileCurveList->isSelected(i)) {
      KstRVectorPtr vector = rvl[i];
      vector->writeLock();
      if (!file->isValidField(vector->field())) {
        KMessageBox::sorry(0L, i18n("%1: Field is not defined for the requested file.").arg(vector->field()));
      } else {
        vector->changeFile(file);
      }
      vector->writeUnlock();
    }
  }

  file->writeUnlock();
  file = 0L;
  emit docChanged();
  // Force an update in case we're in paused mode
  KstApp::inst()->forceUpdate();
}

#include "kstchangefiledialog_i.moc"
// vim: ts=2 sw=2 et
