/***************************************************************************
                          kstfitcurve.h: defines a fit curve for kst
                             -------------------
    begin                : Tue Apr 28 2004
    copyright            : (C) 2004 The University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTFITCURVE_H
#define KSTFITCURVE_H

#include <qstring.h>
#include <qcolor.h>

#include "kstrvector.h"
#include "kstplugin.h"
#include "kstpoint.h"
#include "kstbasecurve.h"

class KstFitCurve: public KstBaseCurve {
public:
  KstFitCurve(const QString &in_tag, KstVectorPtr in_X, KstVectorPtr in_Y,
	   KstVectorPtr in_Weight, const QColor &in_color);
  KstFitCurve(QDomElement &e);
  virtual ~KstFitCurve();

  virtual UpdateType update(int update_counter = -1);
  virtual QString propertyString() const;

  virtual bool hasWeight() const;

  virtual void getPoint(int i, double &x1, double &y1);

  QString getXVTag() const;
  QString getYVTag() const;
  QString getWVTag() const;

  void setPlugin(KstPluginPtr plugin);
  KstPluginPtr getPlugin();
  
  void setXVector(KstVectorPtr new_vx);
  void setYVector(KstVectorPtr new_vy);
  void setWVector(KstVectorPtr new_ex);

  /** Save curve information */
  void save(QTextStream &ts);

  QString getXLabel() const;
  QString getYLabel() const;
  QString getTopLabel() const;

  virtual KstCurveType type() const;

  virtual bool loadInputs();

  virtual bool xIsRising() const {return VX->isRising(); }

  virtual double ns_maxX()    const { return _ns_maxx; }
  virtual double ns_minX()    const { return _ns_minx; }
  virtual double ns_maxY()    const { return _ns_maxy; }
  virtual double ns_minY()    const { return _ns_miny; }

  virtual int samplesPerFrame() const;

  virtual void _showDialog();

private:
  inline void commonConstructor(const QString &in_tag,
                                const QColor &in_color);
  KstPluginPtr _plugin;
  KstVectorPtr VX;
  KstVectorPtr VY;
  KstVectorPtr VW;

  double _ns_maxx;
  double _ns_minx;
  double _ns_maxy;
  double _ns_miny;
};

typedef KstSharedPtr<KstFitCurve> KstFitCurvePtr;
typedef KstObjectList<KstFitCurvePtr> KstFitCurveList;

#endif
