/***************************************************************************
                          kst.h  -  description
                             -------------------
    begin                : Tue Aug 22 13:46:13 CST 2000
    copyright            : (C) 2000 by Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KST_H
#define KST_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstrlist.h>

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>

#include "kstmouse.h"
#include "kstdataobject.h"

// forward declaration of the Kst classes
class KstIfaceImpl;
class KstDoc;
class KstView;
class KstPlotDialogI;
class KstChangeFileDialogI;
class KstChangeNptsDialogI;
class KstQuickCurvesDialogI;
class KstQuickPSDDialogI;
class KstGraphFileDialogI;
class KstDataManagerI;

/** The base class for Kst application windows. It sets up the main
  * window and reads the config file as well as providing a menubar,
  * toolbar and statusbar. An instance of KstView creates the
  * view.  KstApp
  * reimplements the methods that KMainWindow provides for main
  * window handling  @see KMainWindow @see KApplication @see KConfig
  *
  * @author original Source Framework automatically generated by
  * KDevelop, (c) The KDevelop Team.  Modified by C. Barth Netterfield
  */

/** Modified by cbn: moved to XML stuff, move to KMainWindow */

class KstApp : public KMainWindow
{
  Q_OBJECT

  friend class KstView;

public:
  KstApp(QWidget* parent=0, const char* name=0);
  virtual ~KstApp();

  /** add a file to the recent file list */
  void addRecentFile(const KURL &file);

  /** opens a file specified by commandline option */
  void openDocumentFile(const QString& _cmdl = QString::null,
			const QString& o_file = "|",
                        int o_n = -2, int o_f = -2,
                        int o_s = -1,
                        bool o_ave = false);

  /** returns a pointer to the current document connected to the
   * KMainWindow instance and is used by the View class to access
   * the document object's methods */
  KstDoc *getDocument() const;

  /** pause the updating of data */
  void setPaused(bool paused);
  void togglePaused();

  /** Get XY zoom radio button state */
  KstMouseModeType getMouseZoomRadio();

  /** Get tie zoom button state */
  bool getTieZoom();

  /** Update everything */
  void forcedUpdate();

protected:
  /** save options to the configuration file
   *  Geometry, Toolbar status, Statusbar status */
  void saveOptions();

  /** read options from configuration file
   *  Geometry, Toolbar status, Statusbar status */
  void readOptions();

  /** setup kde2 actions and build the GUI */
  void initActions();

  /** sets up the statusbar for the main window */
  void initStatusBar();

  /** initializes the document object of the main window that is
   * connected to the view in initView().  @see initView(); */
  void initDocument();

  /** creates the centerwidget of the KMainWindow instance and sets it as
   *  the view */
  void initView();

  /** queryClose is called by KMainWindow on each closeEvent of a
   * window. This calles saveModified() on the document object to ask
   * if the document should be saved if Modified; on cancel the
   * closeEvent is rejected.
   * @see saveModified()
   * @see KMainWindow#queryClose
   * @see KMainWindow#closeEvent */
  virtual bool queryClose();

  /** Calls queryClose */
  virtual bool queryExit();

  /** saves the window properties for each open window during session
   * end to the session config file, including saving the currently
   * opened file by a temporary filename provided by KApplication.
   * @see KMainWindow#saveProperties */
  virtual void saveProperties(KConfig *_cfg);

  /** reads the session config file and restores the application's
   * state including the last opened files and documents by reading
   * the temporary files saved by saveProperties()
   * @see KMainWindow#readProperties */
  virtual void readProperties(KConfig *_cfg);

private slots:
  // Hack to update KStdActions
  void updateActions();

public slots:

  /** open a new application window by creating a new instance of KstApp */
  void slotFileNewWindow();

  /** clears the document in the view and creates a new document */
  void slotFileNew();

  /** open a file and load it into the document*/
  void slotFileOpen();

  /** opens a file from the recent files menu */
  void slotFileOpenRecent(const KURL &);

  /** save a document */
  void slotFileSave();

  /** save a document by a new filename*/
  void slotFileSaveAs();

  /** asks for saving if the file is modified, then closes the actual
      file and window*/
  void slotFileClose();

  /** closes all windows and exits program: not used */
  void slotFileQuit();

  /** print the actual file */
  void slotFilePrint();

  /** print without querrying */
  void immediatePrintToFile(const QString &filename);

  /** export to png without querrying */
  void immediatePrintToPng(const QString &filename);

  /** toggles the toolbar */
  void slotViewToolBar();

  //void slotEditCut() {}
  //void slotEditCopy() {}
  //void slotEditPaste() {}

  /** toggles the statusbar */
  void slotViewStatusBar();

  /** changes the statusbar contents */
  void slotUpdateStatusMsg(const QString &msg);
  void slotUpdateDataMsg(const QString &msg);
  void slotUpdateFrameMsg(int frame);

  /** The timer handler: re-check files and all that.... */
  void slotTimer();

  /** just calls plotDialog->show_I(0) */
  void showPlotDialog();

  /** just calls dataManager->show_I(0) */
  void showDataManager();

  /** just calls changeFileDialog->showChangeFileDialog(0) */
  void showChangeFileDialog();

  /** just calls changeNptsDialog->showChangeNptsDialog(0) */
  void showChangeNptsDialog();

  /** just calls quickCurvesDialog->showQuickCurvesDialog(0) */
  void showQuickCurvesDialog();

  /** just calls quickPSDDialog->showQuickCurvesDialog(0) */
  void showQuickPSDDialog();

  /** just calls graphFileDialog->showGraphFileDialog(0) */
  void showGraphFileDialog();

  /** creates the plugin manager */
  void showPluginManager();

  /** calls doc->samplesDown */
  void samplesDown();

  /** calls doc->samplesUp */
  void samplesUp();

  /** calls doc->samplesEnd */
  void samplesEnd();

  /** calls update on all the dialogs */
  void updateDialogs();

  /*** shows doc as modified, updates doc and dialogs */
  void registerDocChange();

private:
  /** the configuration object of the application */
  KConfig *config;

  /** The view (SDI) */
  KstView *view;

  /** The document (SDI) */
  KstDoc *doc;

  /* Dialog for editing the document properties */
  KstPlotDialogI *plotDialog;

  /* Dialog for changing the data files from Vectors */
  KstChangeFileDialogI *changeFileDialog;

  /* Dialog for changing the Sample ranges for Vectors */
  KstChangeNptsDialogI *changeNptsDialog;

  /* Dialog for creating a quick data curve and putting it in a plot */
  KstQuickCurvesDialogI *quickCurvesDialog;

  /* Dialog for creating a quick psd curve and putting it in a plot */
  KstQuickPSDDialogI *quickPSDDialog;

  /* Dialog for exporting to a graphics file */
  KstGraphFileDialogI *graphFileDialog;

  /* Dialog for looking at data */
  KstDataManagerI *dataManager;

  /** contains the recently used filenames */
  KRecentFilesAction *recent;

  KToggleAction *StatusBarAction;
  KToggleAction *ToolBarAction;

  /** The Pause Button */
  KToggleAction *PauseAction;

  /** The Reduce samples Button */
  KAction *SamplesDownAction;
  /** The Increase samples Button */
  KAction *SamplesUpAction;
  /** The 'read data from end of file' Button */
  KAction *SamplesFromEndAction;

  /** TiedZoom Button */
  KAction *TiedZoomAction;

  /** Radio Collection: XY, X, Y zoom */
  KRadioAction *XYZoomAction;
  KRadioAction *XZoomAction;
  KRadioAction *YZoomAction;
  KRadioAction *TextAction;

  /* Plot Edit Action */
  KAction *PlotDialogAction;
  /* Vector Edit Action */
  KAction *VectorDialogAction;
  /* Curve Edit Action */
  KAction *CurveDialogAction;
  /* Equation Edit Action */
  KAction *EqDialogAction;
  /* Histogram Edit Action */
  KAction *HsDialogAction;
  /* Power Spectrum Edit Action */
  KAction *PsdDialogAction;
  /* Data Manager Action */
  KAction *DataManagerAction;
  /* Plugin Plot Edit Action */
  KAction *PluginDialogAction;

  /** Change File Action: brings up the change file dialog box */
  KAction *ChangeFileDialogAction;
  /** Change npts Action: brings up the change data range dialog box */
  KAction *ChangeNptsDialogAction;
  /** QuickCurvesDialogAction: Brings up the quick plot window */
  KAction *QuickCurvesDialogAction;
  /** QuickPSDDialogAction: Brings up the quick plot window */
  KAction *QuickPSDDialogAction;
  /** GraphFileDialogAction: Brings up the graphics file export window */
  KAction *GraphFileDialogAction;
  /** PluginManagerAction: Brings up the plugin manager window */
  KAction *PluginManagerAction;

  KAction* fileNewWindow;
  KRecentFilesAction* fileOpenRecent;
  KAction* filePrint;
  KToggleAction* viewToolBar;
  KToggleAction* viewStatusBar;

  /** Timer for re-checking file status etc */
  QTimer *timer;

  bool stopping;
  KstIfaceImpl *_dcopIface;
};

#endif // KST_H
