/***************************************************************************
                          brushdlg.h  -  description
                             -------------------
    begin                : Mit Mai 14 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BRUSHDLG_H
#define BRUSHDLG_H

#include <qpushbutton.h>
#include <qradiobutton.h>
#include <kdialogbase.h>

class QButtonGroup;
class QPainter;

/**
  * Brush button. Provides a button which shows the current
  * brush fill pattern and opens a dialog to select a pattern.
  * @author Werner Stille
  */
class BrushButton : public QPushButton
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param brush pattern number.
   */
  BrushButton(QWidget* parent, int brush);
  /** Destructor. */
  ~BrushButton();
  int value();

protected slots:
  /** Displays the dialog for selection of a pattern. */
  void slotBrush();


signals:
  /**
   * Emitted when brush changed.
   * @param filled true for brush pattern.
   */
  void valueChanged(bool filled);

protected:
  virtual void drawButtonLabel(QPainter* p);
  int brush;
};

/**
  * Brush radio button. Provides a radio button which shows a
  * brush fill pattern.
  * @author Werner Stille
  */
class BrushRadioButton : public QRadioButton
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param brush pattern number.
   */
  BrushRadioButton(QWidget* parent, int brush);
  /** Destructor. */
  ~BrushRadioButton();

protected:
  virtual void drawButtonLabel(QPainter* p);
  int brush;
};

/**
  * Brush dialog. Provides a dialog to select a brush fill pattern.
  * @author Werner Stille
  */
class BrushDlg : public KDialogBase
{
  Q_OBJECT
public: 
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param brush pointer to pattern number.
   */
  BrushDlg(QWidget* parent, int* brush);
  /** Destructor. */
  ~BrushDlg();

protected slots:
  /** Accepts selection and leaves the dialog. */
  virtual void slotOk();

protected:
  int* brush;
  QButtonGroup* bg;
};

#endif
