/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mlist.h"


// ClearList deletes the whole Movielist and frees memory
// It sets the chain's root to NULL

void ClearList(Pointer *Anker)
{
	Pointer Hilf=*Anker;
	Pointer Loescher;

	if (*Anker==NULL) return;
	
	while (Hilf!=NULL) {
		Loescher=Hilf;

		Hilf=Hilf->next;
		free(Loescher);
		};
	*Anker=NULL;
	
	};


// AddMovie goes from root to the end of the list, adding a new struct

void AddMovie(Pointer *Anker,Element Datensatz)
{
        Pointer Neuer;
        Pointer Hilf=*Anker;                                                            Pointer Nachhangler=NULL;
if ( *Anker==NULL ) {
                                                Neuer=(Pointer) malloc(sizeof(Element));

                                                Neuer->before=NULL;
                                                Neuer->next=NULL;
                                                Neuer->Age=Datensatz.Age;
						strcpy(Neuer->Name,Datensatz.Name);
  						strcpy(Neuer->Producer,Datensatz.Producer);
						strcpy(Neuer->Cast1,Datensatz.Cast1);
						strcpy(Neuer->Cast2,Datensatz.Cast2);
						strcpy(Neuer->Cast3,Datensatz.Cast3);
						strcpy(Neuer->Cast4,Datensatz.Cast4);
						strcpy(Neuer->Cast5,Datensatz.Cast5);
       						Neuer->Genre1=Datensatz.Genre1;
						Neuer->Genre2=Datensatz.Genre2;
						strcpy(Neuer->Nr,Datensatz.Nr);
						strcpy(Neuer->Age,Datensatz.Age);
						strcpy(Neuer->Hours,Datensatz.Hours);
						strcpy(Neuer->Minutes,Datensatz.Minutes);
						strcpy(Neuer->Rating,Datensatz.Rating);
     						strcpy(Neuer->Director,Datensatz.Director);
						Neuer->LP=Datensatz.LP;
						Neuer->Stereo=Datensatz.Stereo;
						Neuer->Surround=Datensatz.Surround;
						Neuer->AutoShow=Datensatz.AutoShow;
						Neuer->MovieText=Datensatz.MovieText;

						Neuer->Color=Datensatz.Color;
						Neuer->Number=Datensatz.Number;
						strcpy(Neuer->BeginHours,Datensatz.BeginHours);
						strcpy(Neuer->BeginMinutes,Datensatz.BeginMinutes);
						strcpy(Neuer->Comments,Datensatz.Comments);
						strcpy(Neuer->LinkURL,Datensatz.LinkURL);
						strcpy(Neuer->MadeIn,Datensatz.MadeIn);
						Neuer->SubClass=Datensatz.SubClass;
						Neuer->TapeType=Datensatz.TapeType;
						strcpy(Neuer->OriginalName,Datensatz.OriginalName);
						Neuer->PreTaped=Datensatz.PreTaped;

                                                *Anker=Neuer;
                                            } else {
        while(Hilf!=NULL) { Nachhangler=Hilf;
                Hilf=Hilf->next;
                          };

        Neuer=(Pointer) malloc(sizeof(Element));
        Neuer->before=Nachhangler;
        Nachhangler->next=Neuer;
        Neuer->next=NULL;
	                                               Neuer->Age=Datensatz.Age;
                                                strcpy(Neuer->Name,Datensatz.Name);
                                                strcpy(Neuer->Producer,Datensatz.Producer);
                                                strcpy(Neuer->Cast1,Datensatz.Cast1);
                                                strcpy(Neuer->Cast2,Datensatz.Cast2);
                                                strcpy(Neuer->Cast3,Datensatz.Cast3);
                                                strcpy(Neuer->Cast4,Datensatz.Cast4);
                                                strcpy(Neuer->Cast5,Datensatz.Cast5);
                                                Neuer->Genre1=Datensatz.Genre1;
						Neuer->Genre2=Datensatz.Genre2;
                                                strcpy(Neuer->Nr,Datensatz.Nr);
                                                strcpy(Neuer->Age,Datensatz.Age);
						strcpy(Neuer->Hours,Datensatz.Hours);
						strcpy(Neuer->Minutes,Datensatz.Minutes);
						strcpy(Neuer->Rating,Datensatz.Rating);
						strcpy(Neuer->Director,Datensatz.Director);
                                                Neuer->LP=Datensatz.LP;
						Neuer->Stereo=Datensatz.Stereo;
						Neuer->Surround=Datensatz.Surround;
						Neuer->Color=Datensatz.Color;
						Neuer->AutoShow=Datensatz.AutoShow;
						Neuer->MovieText=Datensatz.MovieText;


						Neuer->Number=Datensatz.Number;
						strcpy(Neuer->BeginHours,Datensatz.BeginHours);
						strcpy(Neuer->BeginMinutes,Datensatz.BeginMinutes);
						strcpy(Neuer->Comments,Datensatz.Comments);
						strcpy(Neuer->LinkURL,Datensatz.LinkURL);
						strcpy(Neuer->MadeIn,Datensatz.MadeIn);
						Neuer->SubClass=Datensatz.SubClass;
						Neuer->TapeType=Datensatz.TapeType;
						Neuer->PreTaped=Datensatz.PreTaped;
						strcpy(Neuer->OriginalName,Datensatz.OriginalName);

};
 
                  
};
 

// LoadMovies loads a file from disk and sets the root to the beginning of list
// return -1 if not succesful

int LoadMovies(char *Filename,Pointer *Anker)
{

   FILE *Datei;
   Element Daten;
  if ((Datei=fopen(Filename,"rb"))==NULL) return (-1);
  ClearList(Anker);

  *Anker=0;
  
  fread(&Daten, sizeof(Element),1,Datei);
   while(!feof(Datei)) {
			AddMovie(Anker,Daten);
                       fread(&Daten,sizeof(Element),1,Datei);
		 }
  fclose(Datei);
  return 0;
};

                   

// URLCheck checks a database for local URLs if they exist. If not, it returns 
// the number of the failing Entry

int URLCheck(char *Filename) 
{
	FILE *File; FILE *Test;
	Element Check;
	char URL[255];
	int Counter=0;
	if ((File=fopen(Filename,"rb"))==NULL) return (-1);
	while (!feof(File)) {
	fread(&Check,sizeof(Check),1,File);
	strcpy(URL,Check.LinkURL);
	Counter++;	
	if ( strlen(URL)!=0 && strstr(URL,"http:")==NULL) {
		printf("Checking URL...\n");	
		if ((Test=fopen(URL,"rb"))==NULL) { printf("\n FALSE");fclose(File); return Counter;};
		fclose(Test);

		};};
	fclose(File);
	return -100;
	// -100 means success!

};
			
	


// Convert converts a database from version 0.91 into 0.92
void Converter(char *FilenameOld, char *FilenameNew)
{
	FILE *Old; FILE *New;
	ElementOld DatenOld; Element DatenNew;
	if ((Old=fopen(FilenameOld,"rb"))==NULL) return;
	if ((New=fopen(FilenameNew,"wb"))==NULL) return;

	while(!feof(Old)) {
		fread(&DatenOld,sizeof(ElementOld),1,Old);
		
		strcpy(DatenNew.Name,DatenOld.Name);
		strcpy(DatenNew.Producer,DatenOld.Producer);
		strcpy(DatenNew.Cast1,DatenOld.Cast1);
		strcpy(DatenNew.Cast2,DatenOld.Cast2);
		strcpy(DatenNew.Cast3,DatenOld.Cast3);
		strcpy(DatenNew.Cast4,DatenOld.Cast4);
		strcpy(DatenNew.Cast5,DatenOld.Cast5);
		DatenNew.Genre1=DatenOld.Genre1;
		DatenNew.Genre2=DatenOld.Genre2;
		strcpy(DatenNew.Nr,DatenOld.Nr);
		strcpy(DatenNew.Age,DatenOld.Age);
		strcpy(DatenNew.Hours,DatenOld.Hours);
		strcpy(DatenNew.Minutes,DatenOld.Minutes);
		DatenNew.LP=DatenOld.LP;
		strcpy(DatenNew.Rating,DatenOld.Rating);
		strcpy(DatenNew.Director,DatenOld.Director);
		
		// setting the new things to a default configuration
		
		strcpy(DatenNew.MadeIn,"\0");
		strcpy(DatenNew.Comments,"\0");
		strcpy(DatenNew.LinkURL,"\0");
		DatenNew.Number=1;
		strcpy(DatenNew.BeginHours,"0\0");
		strcpy(DatenNew.BeginMinutes,"0\0");
		DatenNew.Stereo=0;
		DatenNew.Surround=0;
		DatenNew.Color=1;
		DatenNew.AutoShow=0;
		DatenNew.MovieText=0;
	     fwrite(&DatenNew,sizeof(Element),1,New);     	
		};
fclose(New);
fclose(Old);
return;
};


// Convert980907 for Converting databases from snapshot-versions from 0.91 until 980907

void Convert980907(char *FilenameOld, char *FilenameNew)
{
        FILE *Old; FILE *New;
        Element980907 DatenOld; Element DatenNew;
        if ((Old=fopen(FilenameOld,"rb"))==NULL) return;
        if ((New=fopen(FilenameNew,"wb"))==NULL) return;

        while(!feof(Old)) {
                fread(&DatenOld,sizeof(Element980907),1,Old);

                strcpy(DatenNew.Name,DatenOld.Name);
                strcpy(DatenNew.Producer,DatenOld.Producer);
                strcpy(DatenNew.Cast1,DatenOld.Cast1);
                strcpy(DatenNew.Cast2,DatenOld.Cast2);
                strcpy(DatenNew.Cast3,DatenOld.Cast3);
                strcpy(DatenNew.Cast4,DatenOld.Cast4);
                strcpy(DatenNew.Cast5,DatenOld.Cast5);
                DatenNew.Genre1=DatenOld.Genre1;
                DatenNew.Genre2=DatenOld.Genre2;
                strcpy(DatenNew.Nr,DatenOld.Nr);
                strcpy(DatenNew.Age,DatenOld.Age);
                strcpy(DatenNew.Hours,DatenOld.Hours);
                strcpy(DatenNew.Minutes,DatenOld.Minutes);
                DatenNew.LP=DatenOld.LP;
                strcpy(DatenNew.Rating,DatenOld.Rating);
                strcpy(DatenNew.Director,DatenOld.Director);
		strcpy(DatenNew.MadeIn,DatenOld.MadeIn);
		strcpy(DatenNew.Comments,DatenOld.Comments);
		strcpy(DatenNew.LinkURL,DatenOld.LinkURL);
		DatenNew.Number=DatenOld.Number;
		strcpy(DatenNew.BeginHours,DatenOld.BeginHours);
		strcpy(DatenNew.BeginMinutes,DatenOld.BeginMinutes);
		DatenNew.Stereo=DatenOld.Stereo;
		DatenNew.Surround=DatenOld.Surround;
		DatenNew.Color=DatenOld.Color;
		DatenNew.AutoShow=DatenOld.AutoShow;
		DatenNew.MovieText=DatenOld.MovieText;

                // setting the new things to a default configuration

		DatenNew.SubClass=0;
		DatenNew.TapeType=5;
               
 
             fwrite(&DatenNew,sizeof(Element),1,New);
                };
fclose(New);
fclose(Old);
return;
};
     


// Convert980909 for Converting databases from snapshot-versions from 0.91 until 980909

void Convert980909(char *FilenameOld, char *FilenameNew)
{
        FILE *Old; FILE *New;
        Element980909 DatenOld; Element DatenNew;
        if ((Old=fopen(FilenameOld,"rb"))==NULL) return;
        if ((New=fopen(FilenameNew,"wb"))==NULL) return;

        while(!feof(Old)) {
                fread(&DatenOld,sizeof(Element980909),1,Old);

                strcpy(DatenNew.Name,DatenOld.Name);
                strcpy(DatenNew.Producer,DatenOld.Producer);
                strcpy(DatenNew.Cast1,DatenOld.Cast1);
                strcpy(DatenNew.Cast2,DatenOld.Cast2);
                strcpy(DatenNew.Cast3,DatenOld.Cast3);
                strcpy(DatenNew.Cast4,DatenOld.Cast4);
                strcpy(DatenNew.Cast5,DatenOld.Cast5);
                DatenNew.Genre1=DatenOld.Genre1;
                DatenNew.Genre2=DatenOld.Genre2;
                strcpy(DatenNew.Nr,DatenOld.Nr);
                strcpy(DatenNew.Age,DatenOld.Age);
                strcpy(DatenNew.Hours,DatenOld.Hours);
                strcpy(DatenNew.Minutes,DatenOld.Minutes);
                DatenNew.LP=DatenOld.LP;
                strcpy(DatenNew.Rating,DatenOld.Rating);
                strcpy(DatenNew.Director,DatenOld.Director);
                strcpy(DatenNew.MadeIn,DatenOld.MadeIn);
                strcpy(DatenNew.Comments,DatenOld.Comments);
                strcpy(DatenNew.LinkURL,DatenOld.LinkURL);
                DatenNew.Number=DatenOld.Number;
                strcpy(DatenNew.BeginHours,DatenOld.BeginHours);
                strcpy(DatenNew.BeginMinutes,DatenOld.BeginMinutes);
                DatenNew.Stereo=DatenOld.Stereo;
                DatenNew.Surround=DatenOld.Surround;
                DatenNew.Color=DatenOld.Color;
                DatenNew.AutoShow=DatenOld.AutoShow;
                DatenNew.MovieText=DatenOld.MovieText;
		DatenNew.SubClass=DatenOld.SubClass;
		DatenNew.TapeType=DatenOld.TapeType;
		
                // setting the new things to a default configuration

		strcpy(DatenNew.OriginalName," ");
		DatenNew.PreTaped=0;
	

             fwrite(&DatenNew,sizeof(Element),1,New);
                };
fclose(New);
fclose(Old);
return;
};
            


















































void ShowMovie(Pointer Anker, int Position, int Lines)
{
        Pointer Hilf=Anker;
        int Zaehler=1;
 
        while( (Position!=Zaehler) ) {
	Hilf=Hilf->next;
        Zaehler++;
        }
        Zaehler=0;
        while((Zaehler<=Lines) || (Hilf!=NULL) ) { 
        // printf("%d\n",Hilf->Age);
        Hilf=Hilf->next;
        Zaehler++;
        }
};

// SaveMovies creates a new File and saves the complete list to disc

int SaveMovies(char *Filename,Pointer *Anker)
{
        Pointer hilf;
        Element Daten;
	FILE *Datei;
        
           if ( ( Datei=fopen(Filename,"wb") ) ==NULL) return (-1);
  
        hilf=*Anker;
 
        while (hilf!=NULL) {
                     strcpy(Daten.Name,hilf->Name);
		strcpy(Daten.Producer,hilf->Producer);
		strcpy(Daten.Cast1,hilf->Cast1);
		strcpy(Daten.Cast2,hilf->Cast2);
		strcpy(Daten.Cast3,hilf->Cast3);
		strcpy(Daten.Cast4,hilf->Cast4);
		strcpy(Daten.Cast5,hilf->Cast5);
		strcpy(Daten.Age,hilf->Age);
		strcpy(Daten.Nr,hilf->Nr);
		strcpy(Daten.Hours,hilf->Hours);
		strcpy(Daten.Minutes,hilf->Minutes);
		strcpy(Daten.Rating,hilf->Rating);
		strcpy(Daten.Director,hilf->Director);
		strcpy(Daten.Comments,hilf->Comments);
		strcpy(Daten.LinkURL,hilf->LinkURL);
		strcpy(Daten.MadeIn,hilf->MadeIn);
		Daten.LP=hilf->LP;
		Daten.Stereo=hilf->Stereo;
		Daten.Surround=hilf->Surround;
		Daten.Color=hilf->Color;
                Daten.AutoShow=hilf->AutoShow;
		Daten.MovieText=hilf->MovieText;

		Daten.Genre1=hilf->Genre1;
	        Daten.Genre2=hilf->Genre2;
                Daten.Number=hilf->Number;
		strcpy(Daten.BeginHours,hilf->BeginHours);
		strcpy(Daten.BeginMinutes,hilf->BeginMinutes);
		Daten.TapeType=hilf->TapeType;
		Daten.SubClass=hilf->SubClass;
		strcpy(Daten.OriginalName,hilf->OriginalName);
		Daten.PreTaped=hilf->PreTaped;


 
                    fwrite(&Daten,sizeof(Element),1,Datei);
                    hilf=hilf->next;
                     };

        fclose(Datei);
	return (0);
};
      

// DeleteMovie, searches a movie by it's name, and deletes the struct out of
// the list. 

void DeleteMovie(char Name[50],Pointer *Anker)
{
      Pointer Hilf=*Anker;
      Pointer nachhangler=0;
if (*Anker==0) { return; } else {
	if (!strcmp(Name,Hilf->Name)) { 
			// Hier ist der Hilf erstes Element!
			*Anker=Hilf->next; }
	else
	{ while (strcmp(Hilf->Name,Name) ) { nachhangler=Hilf;
					Hilf=Hilf->next;}
       if (!strcmp(Hilf->Name,Name)) { nachhangler->next=Hilf->next;}

                                  }
}
};


// EditMovie, seeks the struct with "Name" as movie name, and returns it's data
// in Element *Data


void EditMovie(char Name[50],Pointer Anker,Element *Data)
{
	Pointer Hilf=Anker;
	
	if (Anker==0) {return;} else
			{
		while ( strcmp(Hilf->Name,Name)) {
			Hilf=Hilf->next;}
	strcpy(Data->Name,Hilf->Name);
	strcpy(Data->Producer,Hilf->Producer);
	strcpy(Data->Cast1,Hilf->Cast1);
	strcpy(Data->Cast2,Hilf->Cast2);
	strcpy(Data->Cast3,Hilf->Cast3);
	strcpy(Data->Cast4,Hilf->Cast4);
	strcpy(Data->Cast5,Hilf->Cast5);
        strcpy(Data->Nr,Hilf->Nr);
	strcpy(Data->Age,Hilf->Age);
	strcpy(Data->Comments,Hilf->Comments);
	strcpy(Data->LinkURL,Hilf->LinkURL);
	strcpy(Data->MadeIn,Hilf->MadeIn);
	Data->Genre1=Hilf->Genre1;
	Data->Genre2=Hilf->Genre2;
	Data->LP=Hilf->LP;
	Data->Stereo=Hilf->Stereo;
	Data->Surround=Hilf->Surround;
	Data->Color=Hilf->Color;
	Data->AutoShow=Hilf->AutoShow;
	Data->MovieText=Hilf->MovieText;
	strcpy(Data->Hours,Hilf->Hours);
	strcpy(Data->Minutes,Hilf->Minutes);
	strcpy(Data->Rating,Hilf->Rating);
	strcpy(Data->Director,Hilf->Director);
        strcpy(Data->BeginHours,Hilf->BeginHours);
	strcpy(Data->BeginMinutes,Hilf->BeginMinutes);
	Data->Number=Hilf->Number;
	Data->SubClass=Hilf->SubClass;
	Data->TapeType=Hilf->TapeType;
	Data->PreTaped=Hilf->PreTaped;
	strcpy(Data->OriginalName,Hilf->OriginalName);


}; };


// Counts simply all movies

int CountMovies(Pointer *Anker) {

	Pointer Hilf=*Anker;
        int Zaehler=0;
      if (Anker==NULL) return(-1);

      while (Hilf!=NULL) {
		Zaehler++;
		Hilf=Hilf->next;	
	};
return(Zaehler);
};


// used by statistics.cpp: counts all LP-movies

int CountLP(Pointer *Anker) {

	Pointer Hilf=*Anker;
	int Zaehler=0;
      if (Anker==NULL) return(-1);
	while(Hilf!=NULL) { if (Hilf->LP==1) Zaehler++;
		Hilf=Hilf->next;
				};
return(Zaehler);
};


// used by statistics.cpp: counts a single genre

int CountGenre(Pointer *Anker,int Genre) {
	Pointer Hilf=*Anker;
	int Zaehler=0;
	if (Anker==NULL) return(-1);
	while(Hilf!=NULL) { if ( (Hilf->Genre1==Genre) || (Hilf->Genre2==Genre) ) Zaehler++;
		Hilf=Hilf->next;
	};
return(Zaehler);
};


// Statistikmake the whole statistic and returns it in struct Statpointer *stat

void Statistik( StatPointer *Stat,Pointer *Anker ) {
 
	int Zaehler=0;
	while (Zaehler<=21) {
		(*Stat)->Percent[Zaehler]=0;Zaehler++; };
	printf("%i",CountMovies(Anker));
	(*Stat)->TotalMovies=CountMovies(Anker);		  
	(*Stat)->TotalLP=CountLP(Anker);
	(*Stat)->TotalNormal=(*Stat)->TotalMovies-(*Stat)->TotalLP;

	Zaehler=0;
	while (Zaehler<=21) {
		(*Stat)->Percent[Zaehler]=CountGenre(Anker,Zaehler);
	
Zaehler++;

		};
	};




// TapeContents returns the movies on tape x in struct tapemovies

void TapeContents( TapeMoviesPointer *tm, Pointer *Anker, int VideoNum) {
	
	int TapeCounter=0;
	Pointer Hilf=*Anker;


	while (Hilf!=NULL) { 
		if (atoi(Hilf->Nr)==VideoNum) {
					TapeCounter++; if (TapeCounter>=10) TapeCounter--;
					strcpy((*tm)->Name[TapeCounter],Hilf->Name);
					};
			Hilf=Hilf->next;
		};

	

	};	
	

// CheckMovie checks for already used Name, already used position on same tape
	
int CheckMovie(Pointer Anker, char *Name, int Position, int Tape)
{
	Pointer Hilf=Anker;
	
	while (Hilf!=NULL) {
	
	if ( strcmp(Hilf->Name,Name) == 0 ) return -1;
	if ( atoi(Hilf->Nr)==Tape && Hilf->Number==Position) return -2;
	Hilf=Hilf->next;
	};
return 0;
};
	
// kvl2csd : converts a kvl file to csd format (kdb)
// TODO: does not convert all data until now.

			
		
void kvl2csd(char *FilenameOld, char *FilenameNew)
{
        FILE *Old; FILE *New;
        Element DatenOld; 
        if ((Old=fopen(FilenameOld,"r"))==NULL) return;
        if ((New=fopen(FilenameNew,"w"))==NULL) return;
	fprintf(New,"Title:Director:Producer:Cast1:Cast2:Cast3:Cast4:Cast5:Tape-Number:Release-Year:Surround:Stereo:MovieText:Color:LP\n");
        while(!feof(Old)) {
                fread(&DatenOld,sizeof(Element),1,Old);
		
                
		fprintf(New,"%s:%s:%s:%s:%s:%s:%s:%s:%s:%s",DatenOld.Name,DatenOld.Director,DatenOld.Producer,DatenOld.Cast1,DatenOld.Cast2,DatenOld.Cast3,DatenOld.Cast4,DatenOld.Cast5,DatenOld.Nr,DatenOld.Age);
		
	if (DatenOld.Surround==1) { 	fprintf(New,":Y"); } else fprintf(New,":N");
	if (DatenOld.Stereo==1)   {  fprintf(New,":Y"); } else fprintf(New,":N");
	if (DatenOld.MovieText==1){ fprintf(New,":Y"); } else fprintf(New,":N");
	if (DatenOld.Color==1)    { fprintf(New,":Y"); } else fprintf(New,":N");
	if (DatenOld.LP==1)       { fprintf(New,":Y"); } else fprintf(New,":N");

fprintf(New,"\n");



                };
fclose(New);
fclose(Old);
return;
};                                       		
	
		
// asc2kvl : ASCII Import... very complex that is...

void asc2kvl(char *FilenameOld, char *FilenameNew,char *Positions, char *Separator)		
{
	FILE *Old; FILE *New;
	Element Daten;
	char *Searcher;
	char InputString[300];
	char TextMaker[80];
	int POSITION=0;
if ((Old=fopen(FilenameOld,"r"))==NULL) return;
if ((New=fopen(FilenameNew,"w"))==NULL) return;

while (!feof(Old)) {

	fscanf(Old,"%s",InputString);
	Searcher=InputString;


	POSITION=0;
	while (Positions[POSITION]!='X') {
	int PosCount=0;
	while (PosCount<=POSITION) { // We are scanning through InputString...
	// and set *Searcher to the PosCount'th position of Separator
	Searcher=strstr(Searcher, Separator);
	PosCount++;
	}; Searcher++;

	// Now we are on the position of the item
	// let's read it out.
 	int PosCount2=0;
	while (Searcher[PosCount2]!=Separator[0]) { TextMaker[PosCount2]=Searcher[PosCount2]; PosCount2++; };TextMaker[PosCount2]='\0';
	// Now choose at which item to save the string...

	if (Positions[POSITION]=='T') strcpy(Daten.Name,TextMaker);
	if (Positions[POSITION]=='M') strcpy(Daten.MadeIn,TextMaker);
	if (Positions[POSITION]=='R') strcpy(Daten.Age,TextMaker);
	if (Positions[POSITION]=='1') strcpy(Daten.Cast1,TextMaker);
	if (Positions[POSITION]=='2') strcpy(Daten.Cast2,TextMaker);
	if (Positions[POSITION]=='3') strcpy(Daten.Cast3,TextMaker);
	if (Positions[POSITION]=='4') strcpy(Daten.Cast4,TextMaker);
	if (Positions[POSITION]=='5') strcpy(Daten.Cast5,TextMaker);
	if (Positions[POSITION]=='D') strcpy(Daten.Director,TextMaker);
	if (Positions[POSITION]=='C') strcpy(Daten.Comments,TextMaker);
	if (Positions[POSITION]=='N') strcpy(Daten.Nr,TextMaker);
	if (Positions[POSITION]=='O') Daten.Number=atoi(TextMaker);
	
	POSITION++; };

	// Now we have a complete Element *Daten... 
		
	   fwrite(&Daten,sizeof(Element),1,New);
       // write it and go on...

};

fclose(New);            
fclose(Old);

};




// kvl2asc : converts a kvl file to asc format (ascii)
// TODO: does not convert all data until now.



void kvl2asc(char *FilenameOld, char *FilenameNew)
{
        FILE *Old; FILE *New;
        Element DatenOld;
        if ((Old=fopen(FilenameOld,"r"))==NULL) return;
        if ((New=fopen(FilenameNew,"w"))==NULL) return;
     
        while(!feof(Old)) {
                fread(&DatenOld,sizeof(Element),1,Old);

	fprintf(New,"Title		: %s\n",DatenOld.Name);
	fprintf(New,"Director		: %s\n",DatenOld.Director);
	fprintf(New,"Producer		: %s\n",DatenOld.Producer);
	fprintf(New,"Cast (1) 		: %s\n",DatenOld.Cast1);
	fprintf(New,"Cast (2)		: %s\n",DatenOld.Cast2);
	fprintf(New,"Cast (3)		: %s\n",DatenOld.Cast3);
	fprintf(New,"Cast (4)		: %s\n",DatenOld.Cast4);
	fprintf(New,"Cast (5)		: %s\n",DatenOld.Cast5);
	fprintf(New,"Tape No.		: %s\n",DatenOld.Nr);
	fprintf(New,"Release year	: %s\n",DatenOld.Age);
	
      

        if (DatenOld.Surround==1) {     fprintf(New,"Surround Sound	:Yes\n"); } else fprintf(New,"Surround Sound 	:No\n");
        if (DatenOld.Stereo==1)   {  fprintf(New,"Stereo            :Yes\n"); } else fprintf(New,"Stereo	No\n");
        if (DatenOld.MovieText==1){ fprintf(New,"MovieText	:Yes\n"); } else fprintf(New,"MovieText		No\n");
        if (DatenOld.Color==1)    { fprintf(New,"Color		:Yes\n"); } else fprintf(New,"Color		No\n");
        if (DatenOld.LP==1)       { fprintf(New,"LongPlay	:Yes\n"); } else fprintf(New,"LongPlay		No\n");

fprintf(New,"\n\n\n");



                };
fclose(New);
fclose(Old);
return;
};
 






























		
		
