#ifndef _SMB_H_
#define _SMB_H_

#include "protocol.h"
#include "smbprot.h"
#include <kapp.h>
#include <qlist.h>
#include <qdict.h>

class SMBManager;
class SMBMachine;
class SMBShare;

class SMBManager : public Protocol
{
public:
	SMBManager();
	~SMBManager();

	virtual const FileInfoList* entryInfoList(bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const QStrList* entryList(bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE) { errorperm(); return 0;}
	bool mkdir(const char *pathname) { return errorperm();}
	QString absPath() { return "";}
	bool setPath(const char *pathname);
	QString dirName() { return "";}
	bool remove(const char *filename, ProgressDlg *dlg = 0) { return errorperm();}
	bool rmdir(const char *dirname, ProgressDlg *dlg = 0) { return errorperm();}
	bool isRoot() { return errorperm();}
	bool rename(const char *src, const char *dest) { return errorperm();}
	bool exists(const char *filename) { return errorperm();};
	bool chmod(const char *filename, int perm) { return errorperm();}
	bool chown(const char *filanem, const char *owner, const char *group) { return errorperm();}

	bool copyToProtocol(const char *filename, const char *targetDir = 0, bool move = 0, ProgressDlg *dlg = 0) { return errorperm();}
	bool copyFromProtocol(const char *filename, const char *targetDir, bool move = 0, ProgressDlg *dlg = 0) { return errorperm();}
	bool init() { return true;}
	bool finish() { return true;}
	virtual bool cleanup();
	virtual bool matchURL(KURL url);
	const char* currentURL() { return Prefix.data();};
	bool isLocal() { return false;};
	unsigned long long freeSize(const char *dirname) { return (unsigned long long)0;}
	virtual bool hasChilds(const char *dirname) { return true;}
	FileInfo* getInfo(KURL& url) { return 0;}
	virtual void refresh() { UpdateFlag = true;}

	virtual void processBuffer(const QString& Buffer);

protected:
	bool errorperm() { ErrorMsg = i18n("Operation not permitted"); return false;}
	bool getMachineList();
//	bool getMachineListFromRange();
//	bool getMachineListFromWINS();
	bool getIPList(QStrList& list, const char *broadcastIP = 0);
	void translateMachineList();
	void getNMBInfo(ulong ip, QString& name, QString& work);

private:
	QList<SMBMachine>	*MachineList;
	ulong			IPStart, IPStop;
	bool			UpdateFlag;
	QDict<FileInfoList>	GroupDict;
	QString			CurrentGroup;
};

class SMBMachine : public SMBManager
{
public:
	SMBMachine(const char *name, const char *work, const char *ip);
	~SMBMachine();

	const FileInfoList* entryInfoList(bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	const char* machine() { return Name.data();}
	const char* workgroup() { return Workgroup.data();}
	const char* ip() { return IP.data();}
	void cleanProtocols();
	bool matchURL(KURL url);
	bool cleanup();
	bool needLogin() { return (UpdateFlag && (User.isEmpty() || (!User.isEmpty() && Passwd.isEmpty())));};
	void setLogin(const char *user, const char *pwd) { User = user; Passwd = pwd;}
	const char* user() { return User.data();}
	const char* passwd() { return Passwd.data();}

	virtual void processBuffer(const QString& Buffer);

protected:
	bool getShareList();
	void translateShareList();
	void filterEntries(bool dirsOnly);

private:
	QString		Name;
	QString		Workgroup;
	QString		IP;
	FileInfoList	*Entries;
	FileInfoList	*FilteredEntries;
	QString		User;
	QString		Passwd;
	QList<SMBShare>	*ShareList;
	bool		UpdateFlag;
};

class SMBShare : public SmbProtocol
{
public:
	SMBShare(const char *mpoint, const char *service, const char *user, const char *passwd, const char* ip);
	~SMBShare();

	const char* typestr() const { return TypeStr.data();}
	void setShareInfo(const char *name, const char *type) { ShareName = name; TypeStr = type;}
	const char* shareName() const { return ShareName.data();}
//	bool isAccesible() { return true;}
	const FileInfoList* entryInfoList(bool hidden, bool dirsOnly = FALSE, bool showArchive = FALSE);
	bool setPath(const char *pathname);
	bool matchURL(KURL url);
	const char* service() { return Service.data();}

private:
	QString		TypeStr;
	QString		ShareName;
};

#endif
