#include "preview.h"
#include <kapp.h>
#include <qsize.h>

PreviewArea::PreviewArea(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	PreviewFileInfo = 0;

	PreviewContent = new QPushButton(this);
	PreviewContent->setGeometry(5,2,0,0);
	PreviewContent->setAutoResize(true);
	PreviewContent->setMinimumSize(16,16);
	PreviewContent->setText(i18n("Preview area"));
	connect(PreviewContent,SIGNAL(clicked()),SIGNAL(previewClicked()));

	PreviewInfo = new QLabel(this);
	PreviewInfo->setGeometry(151,2,0,0);
	PreviewInfo->setAutoResize(true);
	PreviewInfo->setText(i18n("Name:\nSize:\nOwner/Group:\nPermissions:"));
	QSize infosize = PreviewInfo->sizeHint();

	PreviewValues = new QLabel(this);
	PreviewValues->setGeometry(151+5+infosize.width(),2,0,0);
	PreviewValues->setAutoResize(true);
	PreviewValues->setAlignment(AlignLeft | AlignTop);

	installEventFilter(this);
	Loader = new ImageLoader(this);
}

PreviewArea::~PreviewArea()
{
	if (PreviewFileInfo) delete PreviewFileInfo;
}

void PreviewArea::setFileInfo(FileInfo *fi, bool mult)
{
	Loader->stopLoading();
	if (PreviewFileInfo) { delete PreviewFileInfo; PreviewFileInfo = 0;}
	if (fi == 0) {
		if (!mult) {	// Nohting selected
			PreviewContent->setText(i18n("[Empty]"));
			PreviewValues->setText("");
		}
		else {		// Multiple selection
			PreviewContent->setText(i18n("Multiple\n selection"));
			PreviewValues->setText(i18n("[multiple selection]"));
		}
	}
	else {			// Normal case
		PreviewFileInfo = new FileInfo(*fi);
		QString preview_info;
		QString preview_filetype = " (";
		if( PreviewFileInfo->isSymLink() ) preview_filetype += i18n("link to ");
		if( PreviewFileInfo->isDir() ) preview_filetype += i18n("directory");
		else preview_filetype += i18n("file");
		preview_filetype += ")";
		preview_info.sprintf(i18n("%s%s\n%d bytes\n%s/%s\n%s"),
			PreviewFileInfo->fileName().data(),
			preview_filetype.data(),
			PreviewFileInfo->size(),PreviewFileInfo->owner(),PreviewFileInfo->group(),
			PreviewFileInfo->permissions().data());
		PreviewValues->setText(preview_info);
		PreviewContent->setText(i18n("Preview..."));
		if (PreviewFileInfo->miniImageState() != FileInfo::Loaded) Loader->loadMiniImage(PreviewFileInfo,this,true);
		else if (!PreviewFileInfo->miniImage()->isNull()) PreviewContent->setPixmap(*(PreviewFileInfo->miniImage()));
		else PreviewContent->setText(i18n("No preview"));
	}
}

bool PreviewArea::eventFilter(QObject*, QEvent *e)
{
	if (e->type() == Event_ImageLoad && PreviewFileInfo) {
		if (!PreviewFileInfo->miniImage()->isNull()) PreviewContent->setPixmap(*(PreviewFileInfo->miniImage()));
		else PreviewContent->setText(i18n("No preview"));
		return true;
	}
	return false;
}
