#ifndef _KTREEDIALOG_H_
#define _KTREEDIALOG_H_

#include <qdialog.h>
#include <qlistview.h>
#include <qlist.h>
#include <qframe.h>
#include <qwidget.h>
//#include <knewpanner.h>
#include <qsplitter.h>

class TreeListItem;

class TreeWidget : public QWidget
{
public:
	TreeWidget(QWidget *parent = 0, const char *name = 0) : QWidget(parent,name) {}
protected:
	void resizeEvent(QResizeEvent*);
};

class KTreeDialog : public QDialog
{
	Q_OBJECT;

public:
	KTreeDialog(QWidget *parent = 0, const char *name = 0, bool modal = false, WFlags f = 0);
	~KTreeDialog();

	void addTab(QWidget *w, const char *name);
	void addSubTab(QWidget *w, const char *name, const char *parent = 0);
	void setOkButton(const char *text);
	void setApplyButton(const char *text);
	void setCancelButton(const char *text);
	void setRootText(const char *text);

signals:
	void applyButtonPressed();

protected:
	void resizeEvent(QResizeEvent*);

protected slots:
	void selectionChanged(QListViewItem*);

private:
	QListView	*TreeList;
	TreeWidget	*MainView;
	QList<QWidget>	WidgetList;
	QPushButton	*Ok, *Cancel, *Apply;
	TreeListItem	*Root, *Last;
	QWidget		*CurrentWidget;
	QList<TreeListItem> ItemList;
	QSplitter	*Panner;
};

class TreeListItem : public QListViewItem
{
public:
	TreeListItem(TreeListItem *parent, QWidget *w, const char *name) : QListViewItem(parent,name), Widget(w) {}
	TreeListItem(QListView *parent, const char *name) : QListViewItem(parent,name), Widget(0) {}
	TreeListItem(TreeListItem *parent, TreeListItem *after, QWidget *w, const char *name) : QListViewItem(parent,after,name), Widget(w) {}
	QWidget* widget() { return Widget;}

private:
	QWidget	*Widget;
};

#endif
