#ifndef _KDETAILLIST_H_
#define _KDETAILLIST_H_

#include <qarray.h>
#include <qpopupmenu.h>
#include "kflistbase.h"
#include "kheader.h"

class KDetailList : public KFileListBase
{
	Q_OBJECT

public:
	KDetailList(int format = 0, bool selectionMode = false, QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	virtual ~KDetailList();

	void setColumns(QStrList& Type, QStrList& Width, QString *Names);
	void getColumns(QStrList& Type, QStrList& Width);
	void getDateFormat(int& format);
	void getSelectionMode(bool& mode);
	void setSelectionMode(bool selectionMode);
	void updateItem(FileInfo *item);

public slots:
	void setColumnWidth(int col, int oldw, int w);
	void slotColumnPressed(int col);
	void columnMoved(int from, int to);
	void columnRightClicked(int col, int positionInCol);
	void columnMidClicked(int col);
	void removeColumn();
	void modifyColumn(int id);
	void insertColumn(int id);
	void changeDateFormat(int format);
	void changeSelectionMode(int mode);

signals:
	void hScroll(int value);
	void columnPressed(int col);
	void detailPropertiesChanged();

protected:
	virtual void paintCell(QPainter *p, int row, int col);
	virtual void getTablePosition(int index, int& row, int& col);
	virtual bool getItemCell(int row, int col, FileInfo **item, QPoint p);
	virtual QRect getItemTextRect(FileInfo *item);
	virtual void updateListSize();
	virtual void resizeEvent(QResizeEvent*);
	virtual FileInfo* getNextItem(FileInfo *current, int code);
	virtual void scroll(FileInfo *item);
	virtual QRect getItemRect(FileInfo *item);

	virtual int cellWidth(int col);

	virtual QRect tip(const QPoint& pos, QString& str);

	void createConnectHeader();
	void generateDateString(QString& dateString, QDateTime dateTime);
	void checkPopups();

private:
	int	nCol;
	QArray<int>	ColType;
	QArray<int>	ColWidth;
	QString		*ColName;
	int	nameCol;
	int	DateFormat;
	bool	SelectionMode;
	KHeader	*Header;
	QPopupMenu	*mainPop, *modPop, *insPop, *datePop, *selectionPop;
	int	currentColumn;
	bool	insertToRight;
};

inline void KDetailList::getDateFormat(int& format)
{ format = DateFormat; }

inline void KDetailList::setSelectionMode(bool selectionMode)
{ SelectionMode=selectionMode; }

inline void KDetailList::getSelectionMode(bool& mode)
{ mode = SelectionMode; }

inline void KDetailList::changeSelectionMode(int mode)
{ SelectionMode = (bool) mode; updateSelection(); emit detailPropertiesChanged();}

QString processSize(unsigned long long size);

#endif

