#ifndef _FILEVIEW_H_
#define _FILEVIEW_H_

#include <qwidget.h>
#include <qpixmap.h>
#include <qlabel.h>
#include "kexplorer.def"
#include "kflistbase.h"
#include "kbiconlist.h"
#include "ksiconlist.h"
#include "kdetaillist.h"

class FileViewLabel : public QLabel
{
	Q_OBJECT;

public:
	FileViewLabel(QWidget *parent = 0, const char *name = 0) : QLabel(parent,name) {}
	FileViewLabel(const char *str, QWidget *parent = 0, const char *name = 0) : QLabel(str,parent,name) {}

signals:
	void clicked();

protected:
	void mousePressEvent(QMouseEvent *) { emit clicked();}
};

class FileViewWidget : public QWidget
{
	Q_OBJECT;

public:
	FileViewWidget(int type, bool showMiniImages = false, int format = 0, bool selectionMode = false, QWidget *parent = 0, const char *name = 0);
	~FileViewWidget();

	void setFileList(FileInfoList *list, bool keepSel = false);
	void clearList();
	void setLinkArrows(QPixmap *barrow, QPixmap *sarrow);
	void setDNDIcon(QPixmap *dndicon);
	FileInfoList* getSelected();
	void selectAll();
	void setSelection(FileInfoList& list);
	void setColumns(QStrList& Type, QStrList& Width, QString *Names);
	void getColumns(QStrList& Type, QStrList& Width);
	void getDateFormat(int& dateFormat);
	void getDetailSelectionMode(bool &mode);
	void setDetailSelectionMode(bool detailSelectionMode);
	KFileListBase* getFileView();
	void startRenaming(FileInfo *item);

	void changeType(int newType, bool showMiniImages = false, int format = 0, bool mode = false, QStrList *Type = 0, QStrList *Width = 0, QString *Names = 0);
	void showLabel(bool show);
	void setLabelString(const char *str);
	void activate(bool active);
	void enableTracking(bool value);

signals:
	void selected(FileViewWidget*);
	void renameItem(FileInfo*,const QString&);
	void openItem(FileInfo*);
	void requestMiniImage(FileInfo*);
	void columnPressed(int);
	void popup();
	void selectionChanged();
	void dropAccepted(QDropEvent*,FileInfo*,FileViewWidget*);
	void detailPropertiesChanged();
	void backspacePressed();

protected:
	void createWidget(int type, bool showMiniImages = false, int format = 0, bool selectionMode = false);
	void resizeEvent(QResizeEvent *);

protected slots:
	void widgetSelected(KFileListBase*);
	void dropped(QDropEvent*,FileInfo*);
	void labelClicked();

protected:
	KFileListBase	*FileView;
	int		Type;
	QPixmap		*DNDIcon, *BigLink, *SmallLink;
	FileInfoList	*FileList;
	FileViewLabel	*Label;
	QString		LabelString;
	bool		Active;
};

inline void FileViewWidget::setFileList(FileInfoList *list, bool keepSel)
{
	FileList = list;
	FileView->setFileList(FileList,keepSel);
}

inline void FileViewWidget::setLinkArrows(QPixmap *barrow, QPixmap *sarrow)
{
	BigLink = barrow;
	SmallLink = sarrow;
	FileView->setLinkArrow((Type == BIGICON_ID ? BigLink : SmallLink));
}

inline void FileViewWidget::setDNDIcon(QPixmap *dndicon)
{
	DNDIcon = dndicon;
	FileView->setDNDIcon(DNDIcon);
}

inline FileInfoList* FileViewWidget::getSelected()
{ return FileView->getSelected();}

inline void FileViewWidget::selectAll()
{ FileView->selectAll();}

inline void FileViewWidget::setSelection(FileInfoList& list)
{ FileView->setSelection(list);}

inline void FileViewWidget::setColumns(QStrList& CType, QStrList& Width, QString *Names)
{ if (Type == DETAILICON_ID) ((KDetailList*)FileView)->setColumns(CType,Width,Names);}

inline void FileViewWidget::getColumns(QStrList& CType, QStrList& Width)
{ if (Type == DETAILICON_ID) ((KDetailList*)FileView)->getColumns(CType,Width);}

inline void FileViewWidget::getDateFormat(int& format)
{ if (Type == DETAILICON_ID) ((KDetailList*)FileView)->getDateFormat(format);}

inline void FileViewWidget::getDetailSelectionMode(bool& mode)
{ if (Type == DETAILICON_ID) ((KDetailList*)FileView)->getSelectionMode(mode); }

inline void FileViewWidget::setDetailSelectionMode(bool detailSelectionMode)
{ if (Type == DETAILICON_ID) ((KDetailList*)FileView)->setSelectionMode(detailSelectionMode); }


inline KFileListBase* FileViewWidget::getFileView()
{ return FileView;}

inline void FileViewWidget::enableTracking(bool value)
{ FileView->setMouseTracking(value); if (!value) FileView->setCursor(arrowCursor);}

inline void FileViewWidget::labelClicked()
{ if (FileView) FileView->setFocus();}

inline void FileViewWidget::clearList()
{ FileView->clearList();}

inline void FileViewWidget::startRenaming(FileInfo *item)
{ FileView->startRenaming(item);}

#endif
