#ifndef _BOOKM_H_
#define _BOOKM_H_

#include <qstring.h>
#include <qtextstream.h>
#include <qlist.h>

#define	BOOKMARK_MENU	0x01
#define	BOOKMARK_TOOL	0x02
#define	BOOKMARK_DIR	0x10
#define	BOOKMARK_URL	0x20
#define	BOOKMARK_LOC(x)		((x) & 0x0F)
#define	BOOKMARK_TYPE(x)	((x) & 0xF0)

class BookmarkBase
{
public:
	BookmarkBase(BookmarkBase* p=0) : Parent(p) { Childs.setAutoDelete(false); if (p) p->addChild(this); }
	virtual ~BookmarkBase() { clear(); if (Parent) Parent->removeChild(this); }
	void addChild(BookmarkBase* c) { Childs.append(c); }
	void removeChild(BookmarkBase* c) { Childs.take(Childs.findRef(c)); }
	void clear() { while (!Childs.isEmpty()) delete Childs.first(); }
	virtual void save(QTextStream& t) {}

	QString		Name;
	int		Status;
	QList<BookmarkBase>	Childs;
	BookmarkBase*	Parent;
};

class BookmarkDir : public BookmarkBase
{
public:
	BookmarkDir(BookmarkBase* p=0, const char* name = 0) : BookmarkBase(p) { Name = name; Status = BOOKMARK_DIR; }
	void save(QTextStream& t);
};

class BookmarkUrl : public BookmarkBase
{
public:
	BookmarkUrl(const char* url, BookmarkBase* p=0, const char* name = 0, int accelKey = 0, const char* _icon = 0, int status = BOOKMARK_MENU)
		: BookmarkBase(p), Bookmark(url), AccelKey(accelKey), IconName(_icon)
	{ if (!name) Name = url; else Name = name; Status |= BOOKMARK_URL; Status = (status|BOOKMARK_URL);}
	void save(QTextStream& t) { t << "bookmark," << Bookmark << ',' << Name << ',' << AccelKey << ',' << IconName << ',' << BOOKMARK_LOC(Status) << ',' << endl; }

	QString		Bookmark;
	int		AccelKey;
	QString		IconName;
};

bool loadBookmarkFile(const char* filename, BookmarkBase* root);
bool saveBookmarkFile(const char* filename, BookmarkBase* root);

#endif
