/**********************************************************************

	--- Qt Architect generated file ---

	File: Options.h
	Last generated: Fri Feb 19 21:03:35 1999

	DO NOT EDIT!!!  This file will be automatically
	regenerated by qtarch.  All changes will be lost.

 *********************************************************************/

#ifndef Options_included
#define Options_included

#include <qtabdlg.h>
#include <kconfig.h>
#include "ktreedialog.h"

#include "OptionsGeneral.h"
#include "OptionsExtensions.h"
#include "OptionsDetail.h"
#include "OptionsView.h"
#include "OptionsMisc.h"
#include "OptionsSMB.h"

struct KExplorer_options;

class Options : public KTreeDialog
{
    Q_OBJECT

public:

    Options
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~Options();

    void setConfig(KExplorer_options *);
    void setExtList(KMimeExtList*, KPIconLoader*, bool);
    void setColumns(QStrList& ColType, QStrList& ColWidth, QString *ColName);
    void getColumns(QStrList& ColType, QStrList& ColWidth);
    void setDateFormat(int i);
    void setProtList(SubProtList *list);
    void getProtList(SubProtList *list);

    bool useKDEIcons();
    bool useKDEMimeTypes();
    const char* iconPath();
    const char* extensionFile();
    bool useMagicNumbers();
    const char* magicFile();
    bool extensionsModified();
    bool columnsModified();
    int dateFormat();
    int miniImageSaving();
    bool archModified();
    const char* shell();
    int startup();
    int imageSize();
    bool defaultEdit();
    const char* editApplication();
    bool passwdSaving();
    bool mouseTrackingEnabled();
    bool selectionMode();
    bool sortingExtended();
    int historySize();
    int urlToolBarStyle();
    void writeSMB();
    bool singleClick();
    int sambaVersion();
    bool treeFollow();
    bool appsInSubMenu();

public slots:


protected slots:


protected:
	OptionsGeneral		*General;
	OptionsExtensions	*Extensions;
	OptionsDetail		*Detail;
	OptionsView		*View;
	OptionsMisc		*Misc;
	OptionsSMB		*SMB;
};

inline void Options::setExtList(KMimeExtList *list, KPIconLoader *IL, bool UseKDEMimeTypes)
{ Extensions->setExtList(list,IL,UseKDEMimeTypes);}

inline void Options::setColumns(QStrList& ColType, QStrList& ColWidth, QString *ColName)
{ Detail->setColumns(ColType,ColWidth,ColName);}

inline void Options::getColumns(QStrList& ColType, QStrList& ColWidth)
{ Detail->getColumns(ColType,ColWidth);}

inline bool Options::useKDEIcons()
{ return General->KDEIcons->isChecked();}

inline bool Options::useKDEMimeTypes()
{ return General->KDEMime->isChecked();}

inline const char* Options::iconPath()
{ return General->LocalIconPath->text();}

inline const char* Options::extensionFile()
{ return General->LocalMimeFile->text();}

inline bool Options::useMagicNumbers()
{ return General->UseMagic->isChecked();}

inline const char* Options::magicFile()
{ return General->MagicFile->text();}

inline bool Options::extensionsModified()
{ return Extensions->Modified;}

inline bool Options::columnsModified()
{ return Detail->Modified;}

inline int Options::dateFormat()
{ return Detail->DateFormat->currentItem();}

inline void Options::setProtList(SubProtList *list)
{ View->setProtList(list);}

inline void Options::getProtList(SubProtList *list)
{ View->getProtList(list);}

inline int Options::miniImageSaving()
{ return View->SavingPolicy->currentItem();}

inline bool Options::archModified()
{ return View->Modified;}

inline const char* Options::shell()
{ return General->Shell->text();}

inline int Options::startup()
{ return General->Startup->currentItem();}

inline int Options::imageSize()
{ return (View->ImageSaveIfSize->isChecked() ? QString(View->ImageSize->text()).toInt()*1024 : -1);}

inline bool Options::defaultEdit()
{ return Misc->DefaultEdit->isChecked();}

inline bool Options::singleClick()
{ return Misc->SingleClick->isChecked();}

inline const char* Options::editApplication()
{ return Misc->EditApplication->text();}

inline bool Options::passwdSaving()
{ return Misc->PasswdSaving->isChecked();}

inline bool Options::mouseTrackingEnabled()
{ return Misc->MouseTracking->isChecked();}

inline bool Options::selectionMode()
{ return (bool) Detail->SelectionMode->currentItem();}

inline bool Options::sortingExtended()
{ return Misc->SortingExtended->isChecked();}

inline int Options::historySize()
{ return QString(Misc->HistorySize->text()).toInt();}

inline int Options::urlToolBarStyle()
{ return Misc->URLToolBarStyle->currentItem();}

inline void Options::writeSMB()
{ SMB->writeSMB();}

inline int Options::sambaVersion()
{ return SMB->SambaVersion->currentItem();}

inline bool Options::treeFollow()
{ return Misc->TreeFollow->isChecked();}

inline bool Options::appsInSubMenu()
{ return Misc->AppsInSubMenu->isChecked();}

#endif // Options_included
