#ifndef _OPENDLG_H_
#define _OPENDLG_H_

#include <qdialog.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include "kmime.h"
#include "kpiconloader.h"

class OpenDlg : public QDialog
{
	Q_OBJECT;

public:
	OpenDlg(KMimeAppList *list, KPIconLoader *Loader, QWidget *parent = 0, const char *name = 0);
	virtual ~OpenDlg();

	const char* text() { return EditText->text();}

protected slots:
	void activated(QListViewItem *item);
	void dblClicked(QListViewItem *item);
	void filterApplications(bool show_well_known_only);
	void resizeEvent(QResizeEvent *);

protected:
	QListView	*ListView;
	QLineEdit	*EditText;
	QCheckBox	*KDEOnlyCheckbox;
	QPushButton	*ok;
	QPushButton	*cancel;

	KMimeAppList	*list;
	KPIconLoader 	*Loader;
};

#endif
