/***************************************************************************
                          kprima.h  -  description                              
                             -------------------                                         
    begin                : Tue May 18 16:19:15 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KPRIMA_H
#define KPRIMA_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kprocess.h>

// application specific includes
#include "PrintManager.h"
#include "LogViewer.h"
#include "printsettings.h"
#include "resource.h"
#include "kaboutdialog.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KPriMaView is
  * created which creates your view.
  */
class KPriMaApp : public KTMainWindow 
{
  Q_OBJECT

public:
  /** construtor */
  KPriMaApp(); 
  /** destructor */
  ~KPriMaApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  void setDefaultPrinter(const int);
  void setDefaultPaper(const int);

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** open a document */
  void slotFileOpen();
  /** save a document under a different filename*/
  void slotFileSaveAs();
  /** preview the actual file */
  void slotFilePreview();
  /** print the actual file */
  void slotFilePrint();
  /** exits the application */
  void slotFileQuit();
  /** put the marked text/object into the clipboard and remove
    *	it from the document */
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** show the log viewer */
  void slotViewLogViewer();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
  void slotSetWorkFile(const char*);
  /** show Mirko Suckers About Dialog */
  void slotAbout();
  void slotAboutQt();
  void slotSendEmail(const char*, const char*);
  void slotOpenURL(const char*);

	/** change the settings for installed printers */
	void slotSettingsPrinter();
	void slotSettingsSave();
	
private:
	/** connect used widgets together */
	void connectWidgets();
	
	int 		makePostscript();
	int 		transformFile();
	int 		executeCommand(const QString&, KProcess::RunMode = KProcess::Block);
	QString substituteInFilePSFile(const QString&,
					const QString&, const QString&);

  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
	/** settings_menu contains all items of the settings entry */
  QPopupMenu *settings_menu;
	
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;

  PrintManager 	*view;
  PrintSettings *_settings;
  LogViewer			*logViewer;
//  KShellProcess	process;
  KAboutDialog 	about;

	QString 			_PS_Viewer;
	QString				_TargetFile;
	QString				_TargetFileTransfer;
	QString				_dataDir;
	QString				_toolDir;
};
 
#endif // KPRIMA_H





























