/***************************************************************************
                          kprima.cpp  -  description                              
                             -------------------                                         
    begin                : Tue May 18 16:19:15 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <qmessagebox.h>
#include <qimage.h>
#include <kfiledialog.h>
#include <kimgio.h>
#include <kapp.h>
#include "kprima.h"
#include "PrinterSettingsDialog.h"
#include "LogViewer.h"
#include "kaboutdialog.h"


KPriMaApp::KPriMaApp()
{
  setCaption("KPriMa " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  // create a new object that handles the print settings
	_settings = new PrintSettings();
	logViewer = new LogViewer();

  // connect used widgets together
  connectWidgets();
  _settings->slotInit();
	// give the PrintSettings object to the view
	view->registerHandler(_settings);

	_PS_Viewer					= "kghostview %s";
	_TargetFile					= "/tmp/KPriMa_TMP_PSFILE.ps";
	_TargetFileTransfer	= "/tmp/KPriMa_TMP_PSTRANS.ps";
	_dataDir = kapp->kde_datadir() + (QString) "/kprima";
	_toolDir = _dataDir + (QString) "/tools";
	
	// add _toolDir to PATH
	//QString path = (QString) getenv("PATH");
	//path += (QString) ":" + _toolDir + (QString) ":";
	//debug("PATH=%s",path.data());
	//if (setenv("PATH", path.data(),1) == 0)
	//	debug("setenv ok");
	//else
	//	debug("setenv error");
}

KPriMaApp::~KPriMaApp()
{
	if (view)
		delete view;
		
	if (_settings)
		delete _settings;
}

void KPriMaApp::connectWidgets()
{
	// connect to PrintManager
	connect(view, SIGNAL(signalPrint()), this, SLOT(slotFilePrint()));
	connect(view, SIGNAL(signalPreview()), this, SLOT(slotFilePreview()));
	connect(view, SIGNAL(signalQuit()), this, SLOT(slotFileQuit()));
	connect(view, SIGNAL(signalChangeFile()), this, SLOT(slotFileOpen()));
	connect(view, SIGNAL(signalOptions()), this, SLOT(slotSettingsPrinter()));
	connect(view, SIGNAL(signalAbout()), this, SLOT(slotAbout()));
	
	connect(&about, SIGNAL(sendEmail(const char*, const char*)),
					this, SLOT(slotSendEmail(const char*, const char*)));
	connect(&about, SIGNAL(openURL(const char*)),
					this, SLOT(slotOpenURL(const char*)));
					
//	connect(&process,SIGNAL(receivedStdout(KProcess *,char *,int)),
//					logViewer,SLOT(slotGotData(KProcess *,char *,int)));
//	connect(&process,SIGNAL(receivedStderr(KProcess *,char *,int)),
//					logViewer,SLOT(slotGotData(KProcess *,char *,int)));

}

void KPriMaApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KPriMaApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KPriMaApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("Save &as..."), ID_FILE_SAVE_AS );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("Previe&w"), ID_FILE_PREVIEW );
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
  file_menu->setAccel(CTRL+Key_S, ID_FILE_SAVE_AS);
  file_menu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
  file_menu->setAccel(CTRL+Key_V, ID_FILE_PREVIEW);
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Log Viewer"), ID_VIEW_LOGVIEWER);
  view_menu->insertSeparator();
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  settings_menu = new QPopupMenu();
  settings_menu->insertItem(i18n("Change &Options..."), ID_SETTINGS_PRINTER );
  settings_menu->insertSeparator();
  settings_menu->insertItem(i18n("&Save Options"), ID_SETTINGS_SAVE );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu->insertItem(i18n("Help on KPriMa"),
												KApplication::getKApplication(),
												SLOT(appHelpActivated()), Key_F1);
  help_menu->insertSeparator();
  help_menu->insertItem(i18n("About &KPriMa..."), ID_HELP_ABOUT );
  help_menu->insertItem(i18n("About &Qt"), 				ID_HELP_ABOUT_QT );
  help_menu->insertItem(i18n("About &KDE"),
												KApplication::getKApplication(),
												SLOT(aboutKDE()));

  help_menu->setAccel(CTRL+Key_A, ID_HELP_ABOUT);

  //help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&View"), view_menu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Settings"), settings_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(file_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(view_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(settings_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(settings_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(help_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(help_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));
}
void KPriMaApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File"));
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE_AS, true, i18n("Save File As"));
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  connect(toolBar(), SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)));

}

void KPriMaApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void KPriMaApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  view = new PrintManager(this,"KPriMa");
  setView(view);

}

void KPriMaApp::saveOptions()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

}

void KPriMaApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
void KPriMaApp::slotSetWorkFile(const char *f)
{
	if (_settings)
		_settings->setWorkFile((QString)f);
}

void KPriMaApp::slotSendEmail(const char *name, const char *email)
{
	QString command = 0;
	command.sprintf("kmail -s KPriMa %s",email);
	executeCommand(command,KProcess::DontCare);
}

void KPriMaApp::slotOpenURL(const char *url)
{
	QString command = 0;
	command.sprintf("kfmclient openURL %s",url);
	executeCommand(command,KProcess::DontCare);
}

void KPriMaApp::slotAbout()
{
	QString ddir = _dataDir + (QString) "/PriMa_3d.xpm";
  QImage logo;
  // -----
  kimgioRegister();
  if(logo.load(ddir.data()))
    {
      QPixmap pix;
      pix=logo;
      about.setLogo(pix);
    }
  about.setCaption(i18n("About KPriMa"));
  about.setVersion((QString)i18n("This is Version "VERSION" of KPriMa"));
  // ----- set the application author:
  about.setAuthor
    ("Torsten Uhlmann", "TUhlmann@gmx.de", "", i18n("Initial developer."));
  // ----- set the application maintainer:
  about.setMaintainer("Torsten Uhlmann", // name
		      "TUhlmann@gmx.de", // email address
		      "http://tuhlmann.purespace.de/projects/kprima", // URL
		      i18n("Current maintainer.")); // description
  // ----- add some contributors:
  about.addContributor("Jrg Rdler", "jora@jops.in-berlin.de",
  				"http://www.in-berlin.de/User/jops/PriMa/PriMa.de.html",
		      i18n("Initial Author of PriMa"));
  about.addContributor("Mirko Sucker",
		       "Mirko@kde.org",
		       0,
		       i18n("Author of the About Dialog"));
  // ----- contents of the dialog have changed, adapt sizes:
  about.adjust();
  about.exec();
  // -----
  return;
}

void KPriMaApp::slotAboutQt()
{
	QMessageBox::aboutQt(this, i18n("About Qt"));
}

void KPriMaApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));

	QString f = KFileDialog::getOpenFileName();
	if (!f.isEmpty())
		if (!_settings->setWorkFile(f))
			QMessageBox::information(0,i18n("Change File"),
				i18n("Could not change the file name!"),
				QMessageBox::Ok | QMessageBox::Default);

  slotStatusMsg(IDS_DEFAULT);
}

void KPriMaApp::slotFileSaveAs()
{
  int 		error = 0;
  QString command;
  QString file 	= _settings->getWorkFile();

  slotStatusMsg(i18n("Saving transformed file under new filename..."));

  if (file.isEmpty())
  {
		QMessageBox::information(0,i18n("Save File As"),
			i18n("You must specify a file!"),
			QMessageBox::Ok | QMessageBox::Default);
  	slotStatusMsg(IDS_DEFAULT);
  	return;
  }

	QString f = KFileDialog::getSaveFileName(0,0,0,file);
	if (f.isEmpty())
	{
		debug("cancel");
		return;
	}

	debug("save to %s",f.data());

  if (!_settings->isPostscriptValid())
  	if ((error = makePostscript()) != 0)
  	{
			QMessageBox::information(0,i18n("Save File As"),
				i18n("Could not generate a Postscript file!"),
				QMessageBox::Ok | QMessageBox::Default);
  		slotStatusMsg(IDS_DEFAULT);
  		return;
  	}
  	
  if (!_settings->isTransformValid())
  	if ((error = transformFile()) != 0)
  	{
			QMessageBox::information(0,i18n("Save File As"),
				i18n("Could not transform the file!"),
				QMessageBox::Ok | QMessageBox::Default);
  		slotStatusMsg(IDS_DEFAULT);
  		return;
  	}

  QFile sfile(_TargetFileTransfer);
  QFile dfile(f);

  if (!sfile.open( IO_Raw | IO_ReadOnly ))
  {
		QMessageBox::information(0,i18n("Save File As"),
			i18n("Could not open " + _TargetFileTransfer + " for reading!"),
			QMessageBox::Ok | QMessageBox::Default);
		return;
  }

  if (!dfile.open( IO_Raw | IO_WriteOnly ))
  {
		QMessageBox::information(0,i18n("Save File As"),
			i18n("Could not open " + f + " for writing!"),
			QMessageBox::Ok | QMessageBox::Default);
		return;
  }

  char dataBlock[1025];
  int	len = 0;
  while ((len = sfile.readBlock(dataBlock,1024)) > 0)
  	dfile.writeBlock(dataBlock,len);
  	
  slotStatusMsg(IDS_DEFAULT);
}

void KPriMaApp::slotFilePreview()
{
  slotStatusMsg(i18n("Previewing..."));

  int error = 0;
  QString command;
	PrinterEntry *entry = _settings->getPrinterEntry();
  QString 			file 	= _settings->getWorkFile();
	QString 			c 	 	= entry->previewCommand;

  if (file.isEmpty())
  {
		QMessageBox::information(0,i18n("Preview File"),
			i18n("You must specify a file!"),
			QMessageBox::Ok | QMessageBox::Default);
  	slotStatusMsg(IDS_DEFAULT);
  	return;
  }
  if (!_settings->isPostscriptValid())
  	if ((error = makePostscript()) != 0)
  	{
			QMessageBox::information(0,i18n("Preview File"),
				i18n("Could not generate a Postscript file!"),
				QMessageBox::Ok | QMessageBox::Default);
  		slotStatusMsg(IDS_DEFAULT);
  		return;
  	}
  	
  if (!_settings->isTransformValid())
  	if ((error = transformFile()) != 0)
  	{
			QMessageBox::information(0,i18n("Preview File"),
				i18n("Could not transform the file!"),
				QMessageBox::Ok | QMessageBox::Default);
  		slotStatusMsg(IDS_DEFAULT);
  		return;
  	}

	if (_TargetFileTransfer.isEmpty())
		return;
		
	// find %PSFILE and substitute it with the
	// chosen file and a temporar name for the PSFILE
	command = substituteInFilePSFile(c,0,_TargetFileTransfer);
	if (command.isEmpty())
		return;
  	
  // command.sprintf(_PS_Viewer.data(),_TargetFileTransfer.data());

  if ((error = executeCommand(command,KProcess::DontCare)) != 0)
  {
		QMessageBox::information(0,i18n("Preview File"),
			i18n("Could not start Postscript Previewer!"),
			QMessageBox::Ok | QMessageBox::Default);
  }

  slotStatusMsg(IDS_DEFAULT);
}

void KPriMaApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  int error 					= 0;
  QString command			= 0;
  QString file 				= _settings->getWorkFile();
	PrinterEntry *entry = _settings->getPrinterEntry();
	QString c 					= entry->printCommand;
	

  if (file.isEmpty())
  {
		QMessageBox::information(0,i18n("Printing File"),
			i18n("You must specify a file!"),
			QMessageBox::Ok | QMessageBox::Default);
  	slotStatusMsg(IDS_DEFAULT);
  	return;
  }
  if (!_settings->isPostscriptValid())
  	if ((error = makePostscript()) != 0)
  	{
			QMessageBox::information(0,i18n("Printing File"),
				i18n("Could not generate a Postscript file!"),
				QMessageBox::Ok | QMessageBox::Default);
  		slotStatusMsg(IDS_DEFAULT);
  		return;
  	}
  	
  if (!_settings->isTransformValid())
  	if ((error = transformFile()) != 0)
  	{
			QMessageBox::information(0,i18n("Printing File"),
				i18n("Could not transform the file!"),
				QMessageBox::Ok | QMessageBox::Default);
  		slotStatusMsg(IDS_DEFAULT);
  		return;
  	}

	if (_TargetFileTransfer.isEmpty())
		return;
		
	// find %PSFILE and substitute it with the
	// chosen file and a temporar name for the PSFILE
	command = substituteInFilePSFile(c,0,_TargetFileTransfer);
	if (command.isEmpty())
		return;
		
  if ((error = executeCommand(command,KProcess::DontCare)) != 0)
  {
		QMessageBox::information(0,i18n("Printing File"),
			i18n("The specified print command for that printer\ndid not work!"),
			QMessageBox::Ok | QMessageBox::Default);
  }

  slotStatusMsg(IDS_DEFAULT);
}

void KPriMaApp::slotFileQuit()
{ 
  ///////////////////////////////////////////////////////////////////
  // exits the Application
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
}

void KPriMaApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

void KPriMaApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KPriMaApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}

void KPriMaApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void KPriMaApp::commandCallback(int id_){
  switch (id_){
    case ID_FILE_OPEN:                slotFileOpen();break;
    case ID_FILE_SAVE_AS:             slotFileSaveAs();break;
    case ID_FILE_PREVIEW:             slotFilePreview();break;
    case ID_FILE_PRINT:               slotFilePrint();break;
    case ID_FILE_QUIT:                slotFileQuit();break;

    case ID_HELP_ABOUT:               slotAbout();break;
    case ID_HELP_ABOUT_QT:            slotAboutQt();break;

    case ID_SETTINGS_PRINTER:         slotSettingsPrinter();break;
    case ID_SETTINGS_SAVE:         		slotSettingsSave();break;

    case ID_VIEW_LOGVIEWER:           slotViewLogViewer();break;
    case ID_VIEW_TOOLBAR:             slotViewToolBar();break;
    case ID_VIEW_STATUSBAR:           slotViewStatusBar();break;
  }
}

void KPriMaApp::statusCallback(int id_){
  switch (id_){
    case ID_FILE_OPEN:         slotStatusHelpMsg(i18n("Opens an existing document"));break;
    case ID_FILE_SAVE_AS:      slotStatusHelpMsg(i18n("Save the document as..."));break;
    case ID_FILE_PREVIEW:      slotStatusHelpMsg(i18n("Previews the current document"));break;
    case ID_FILE_PRINT:        slotStatusHelpMsg(i18n("Prints the current document"));break;
    case ID_FILE_QUIT:         slotStatusHelpMsg(i18n("Exits the program"));break;

    case ID_HELP_ABOUT:        slotStatusHelpMsg(i18n("Show an About Dialog"));break;
    case ID_HELP_ABOUT_QT:     slotStatusHelpMsg(i18n("Show where QT comes from"));break;

    case ID_SETTINGS_PRINTER:  slotStatusHelpMsg(i18n("Change your printer settings"));break;
    case ID_SETTINGS_SAVE:  	 slotStatusHelpMsg(i18n("Save the printer settings"));break;

    case ID_VIEW_LOGVIEWER:    slotStatusHelpMsg(i18n("shows the Log Viewer"));break;
    case ID_VIEW_TOOLBAR:      slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));break;
    case ID_VIEW_STATUSBAR:    slotStatusHelpMsg(i18n("Enables / disables the actual Statusbar"));break;
  }
}

void KPriMaApp::slotSettingsPrinter()
{
  slotStatusMsg(i18n("Change settings for installed printers..."));

  PrinterSettingsDialog *dialog = new PrinterSettingsDialog(_settings->getPrinterList());
  int ret = dialog->exec();
  if (ret == QDialog::Accepted)
  {
  	//debug("OK Button");
  	// get values from dialog and update PrintSettings object
  	_settings->setPrinterList(dialog->getPrinterList());
  	// PrintSettings should emit a signal so that
  	// PrintManager is gonna be repainted
  }

  slotStatusMsg(IDS_DEFAULT);
}

void KPriMaApp::slotSettingsSave()
{
  slotStatusMsg(i18n("Save settings for installed printers..."));

	_settings->slotSaveConfigFile();

  slotStatusMsg(IDS_DEFAULT);
}

/** before transforming a file we need to make sure it is PS
		Therefore we call a script defined in the transformCommand
		of the actual printer */
int KPriMaApp::makePostscript()
{
	int err							= 0;
	PrinterEntry *entry = _settings->getPrinterEntry();
	QString c 					= entry->transformCommand;
	QString InFile 			= _settings->getWorkFile();
	
	if (InFile.isEmpty())
		return -1;
		
	if (_TargetFile.isEmpty())
		return -2;
		
	// find %INFILE and %PSFILE and substitute them by the
	// chosen file and a temporar name for the PSFILE
	QString command = substituteInFilePSFile(c,InFile,_TargetFile);
	if (command.isEmpty())
		return -3;
	
	if ((err = executeCommand(command)) == 0)
		_settings->setPostscriptValid(true);

	return err;
}

int KPriMaApp::transformFile()
{
  QString command = 0;
  QString range 	= 0;
  int 		error 	= 0;
  int			fromPage = _settings->getFromPage();
  int			toPage	= _settings->getToPage();

  /* set selected papersize */
  command.sprintf("psresize -p%s < %s ", _settings->getPaper().data(), _TargetFile.data());

  /* any need to use psselect now? */
  if ((_settings->getPageSelect() != PrintSettings::all) || (fromPage != 0) ||
  		(toPage != 0))
  {
    command += "| psselect ";
    if (_settings->getPageSelect() == PrintSettings::even )
      command += "-e ";
    if (_settings->getPageSelect() == PrintSettings::odd )
      command += "-o ";
    if ((fromPage != 0) || (toPage != 0))
    {
      range.sprintf("-p%d-%d ", ((fromPage != 0) ? fromPage : toPage),
	      ((toPage != 0) ? toPage : fromPage));
      command += range.copy();
    }
  }
  /* use psnup */
  if (_settings->getPagesPerSheet() != PrintSettings::one)
  {
  	range = "";
    range.sprintf("| psnup -p%s -%1dup ",_settings->getPaper().data(),
    								_settings->getPagesPerSheetDecimal());
    command += range.copy();
  }
  /* use psbook */
  if (_settings->isBook())
  {
  	range = "";
    range.sprintf("| psbook -s%d ",_settings->getSignature());
    command += range.copy();
  }
  /* reverse order */
  if (_settings->isReverseOrder())
  {
    command += "| psselect -r";
  }
  command += "> ";
  command += _TargetFileTransfer;

  error = executeCommand(command);

  if (!error)
		_settings->setTransformValid(true);
		
  return(error);
}

int KPriMaApp::executeCommand(const QString &command,
															KProcess::RunMode rm)
{
 	KShellProcess	process;
 	
  bool success       	= false;

	connect(&process,SIGNAL(receivedStdout(KProcess *,char *,int)),
					logViewer,SLOT(slotGotData(KProcess *,char *,int)));
	connect(&process,SIGNAL(receivedStderr(KProcess *,char *,int)),
					logViewer,SLOT(slotGotData(KProcess *,char *,int)));

  // now spawn process
 	process.clearArguments();
  debug("execute: %s",command.data());
 	process << command.data();
	success = process.start(rm, KProcess::AllOutput);
 	if (!success)
	{
  	QMessageBox::information(0,i18n("External Process"),
    	i18n("An external process could not be started!"),
 	  	QMessageBox::Ok | QMessageBox::Default);
 	  return -1;
 	}
	return 0;
}

QString KPriMaApp::substituteInFilePSFile(const QString &c,
				const QString &InFile, const QString &OutFile)
{
	QString command = c.copy();
	int idx = 0;
	bool ready = false;
	if (InFile)
	{
		while (!ready)
		{
			idx = command.find("%INFILE",0,false);
			if (idx != -1)
			{
				// string found, replace it
				command.replace(idx,7,InFile);
			} else
				ready = true;
		}
		// search for %PSFILE
		ready = false;
	}
	if (OutFile)
	{
		while (!ready)
		{
			idx = command.find("%PSFILE",0,false);
			if (idx != -1)
			{
				// string found, replace it
				command.replace(idx,7,OutFile);
			} else
				ready = true;
		}
	}
	return command.copy();
}

void KPriMaApp::slotViewLogViewer()
{
	logViewer->show();
}

void KPriMaApp::setDefaultPrinter(const int printer)
{
	view->slotPrinterChanged(printer);
}

void KPriMaApp::setDefaultPaper(const int paper)
{
	view->slotPaperChanged(paper);
}




















