/***************************************************************************
                          PrinterSettingsDialog.cpp  -  description
                             -------------------
    begin                : Wed Dec 22 1999
    copyright            : (C) 1999 by Torsten Uhlmann
    email                : TUhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qmessagebox.h>
#include <qlist.h>
#include <kapp.h>
#include "PrinterSettingsDialog.h"
#include "printsettings.h"
#include "resource.h"

PrinterSettingsDialog::PrinterSettingsDialog(const PrinterList &pl, QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();

	connect( currentPrinter, SIGNAL(activated(int)), SLOT(slotNewPrinterSelected(int)) );
	connect( addPrinterButton, SIGNAL(clicked()), SLOT(slotAddPrinter()) );
	connect( okButton, SIGNAL(clicked()), SLOT(accept()) );
	connect( cancelButton, SIGNAL(clicked()), SLOT(reject()) );
	connect( acceptPrinterButton, SIGNAL(clicked()), SLOT(slotAcceptPrinter()) );
	connect( clearEntryButton, SIGNAL(clicked()), SLOT(slotClearFields()) );

	setCaption( "Printer Settings" );
	newPrinter = false;
	_printerList = pl;
	
	// set PrinterBox
	currentPrinter->clear();
	QListIterator<PrinterEntry> iterator(_printerList);
	for (iterator.toFirst(); iterator.current(); ++iterator)
		currentPrinter->insertItem(iterator.current()->description);
		
	iterator.toFirst();
	if (iterator.current())
	{
		printerName->setText(iterator.current()->description);
		transformCommand->setText(iterator.current()->transformCommand);
		previewCommand->setText(iterator.current()->previewCommand);
		printCommand->setText(iterator.current()->printCommand);
	}
}


PrinterSettingsDialog::~PrinterSettingsDialog()
{
}

/** build a PrinterList from the internally stored values
		and return it */
PrinterList PrinterSettingsDialog::getPrinterList()
{
	return _printerList;
}

void PrinterSettingsDialog::slotClearFields()
{
	printerName->clear();
	transformCommand->clear();
	previewCommand->clear();
	printCommand->clear();
}

void PrinterSettingsDialog::slotAddPrinter()
{
	// append the made changes to the PrinterList
	if ((!printerName->text()) || (!transformCommand->text()) ||
			(!printCommand->text()))
	{
		QMessageBox::information(0,i18n("Accept Printer"),
			i18n("There are empty fields!"),
			QMessageBox::Ok | QMessageBox::Default);
		return;
	}
	
	if (!previewCommand->text())
	{
		previewCommand->setText(STD_PREVIEW_COMMAND);
	}

	// create new PrinterEntry and append to PrinterList
	PrinterEntry *entry = new PrinterEntry;
	entry->printerNo = _printerList.count() + 1;
	entry->description = printerName->text();
	entry->transformCommand = transformCommand->text();
	entry->previewCommand = previewCommand->text();
	entry->printCommand = printCommand->text();
	_printerList.append(entry);
	// set printer name in pull down list
	currentPrinter->insertItem(printerName->text());
	currentPrinter->setCurrentItem(currentPrinter->count()-1);
}

void PrinterSettingsDialog::slotAcceptPrinter()
{
	// if list is empty go to AddPrinter
	if (currentPrinter->count() == 0)
	{
		slotAddPrinter();
		return;
	}
	
	int idx = 0;
	if ((!printerName->text()) || (!transformCommand->text()) ||
			(!printCommand->text()))
	{
		QMessageBox::information(0,i18n("Accept Printer"),
			i18n("There are empty fields!"),
			QMessageBox::Ok | QMessageBox::Default);
		return;
	}
	
	if (!previewCommand->text())
	{
		previewCommand->setText(STD_PREVIEW_COMMAND);
	}
	
	// overwrite existing entry
	idx = currentPrinter->currentItem();
	currentPrinter->changeItem(printerName->text(),idx);

	// write the new values to the selected printer
	PrinterEntry *entry;
	QListIterator<PrinterEntry> iterator(_printerList);
	iterator.toFirst();
	entry = iterator += idx;
	entry->description = printerName->text();
	entry->transformCommand = transformCommand->text();
	entry->previewCommand 	= previewCommand->text();
	entry->printCommand 		= printCommand->text();
}

void PrinterSettingsDialog::slotNewPrinterSelected(int idx)
{
	// write the values of the selected printer in the
	// entry fields
	PrinterEntry *entry;
	QListIterator<PrinterEntry> iterator(_printerList);
	iterator.toFirst();
	entry = iterator += idx;
	printerName->setText(entry->description);
	transformCommand->setText(entry->transformCommand);
	previewCommand->setText(entry->previewCommand);
	printCommand->setText(entry->printCommand);
}
