/* Dies ist unsere Kradio Klasse, sie verkrpert nur unsere
 * Oberflche 
 * Written Nov 1998 Carsten Gro (carsten@sol.wohnheim.uni-ulm.de)
 * Orientiert sich ein bichen an kexample von Matthias Ettrich
 */

/** 
 * Das KRadio Programm
 * 
 */
#ifndef KRADIO_H
#define KRADIO_H


#include <kapp.h>
#include <kaccel.h>
#include <ktmainwindow.h>
#include <drag.h>
#include <qpopupmenu.h>
#include <qvalidator.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlist.h>
#include <qdialog.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#ifdef DEBUG
#include <iostream.h>
#endif
#include <assert.h>
#include "radioctrl.h"
#include "docking.h"

class FrequenzBox : public QSpinBox {
	// Der Konstruktor, der gleichzeitig auch noch
	// den Validator fr die SpinBox einrichtet
	public:
		FrequenzBox(int minValue, int maxValue, int step, \
			QWidget *parent) : QSpinBox(minValue, maxValue, step,
				parent) {
			v = new QDoubleValidator(87.5, 108.0, 2, this);
			this->setValidator(v);
			magic = MAGIC;
			}
	protected:
		virtual QString mapValueToText(int v) {
			double z;
			assert(MAGIC == magic);
			z = (((double)v)/100);
			sprintf(Wert, "%.2f", z);
			return QString(Wert);
		};
		virtual int mapTextToValue(bool * ok) {
			double z;
			int i;
			assert(MAGIC == magic);
			z = strtod(text(), 0);
			if (z<87.5) z=87.5;
			if (z>108.0) z=108.0;
			*ok = TRUE;
			i = (int)((z * 100)+0.5);
			return i;
		};

	protected:
		enum { MAGIC = 0x300572 };
		unsigned int magic;	// Das kann hilfreich sein
		char 	Wert[20];
		QDoubleValidator * v;
};

/* Die Beschreibung eines gespeicherten Radioprogramms */
class RadioProgramm {
	public:
		RadioProgramm(QString Name, double Wert) {
			s=Name;
			f=Wert;
			magic=MAGIC;
		}
#ifdef DEBUG
		~RadioProgramm() {
			s="MUELL";
			f=1234;
			magic=0xaaaaaaaa;
		}
#endif
		QString Station() {
			assert(MAGIC == magic);
			return s;
		}
		double Frequenz() {
			assert(MAGIC == magic);
			return f;
		}
	protected:
		enum { MAGIC = 0x662277aa };
		unsigned int magic;	// Ein magic value
		QString s;  // Hier merken wir uns die Station
		double  f;  // Und hier die dazugehrige Frequenz
//		QPixmap p;  // Das kommt noch, ein logo... 

};

class KRadio : public KTMainWindow {
	Q_OBJECT
	public:
		KRadio();		   // Konstruktor
		Radio	   * pRadio;	   // Hier ist das Radioobjekt drin
		void loadFile(QString );   // Die Datei von Platte laden
		QComboBox  * pStationList; // Die Qombobox wo die Stationsnamen 
		                           // gezeigt werden
	public slots: 
		void slotOpenFile(void);    // Neue Frequenztabelle laden
		void slotSaveFile(void);    // Frequenztabelle speichen
		void slotQuit(void);	    // Programm beenden
		void slotChangeFrequenz(int ); // Frequenz setzen. 
		void slotChangeStation(const char *); // Station + Frequenz setzen
		void slotNewStation(void);   // Neue Station eintragen
		void slotRemoveStation(void); // Station lschen
		void saveProperties(KConfig *); // Eigenschaften Abspeichern
		void readProperties(KConfig *); // Wieder laden
		void slotDropEvent(KDNDDropZone *); // Joo .. eine Drop
						    // Zone haben wir auch
						    // (ganzes Widget)
		void slotPreferencesMenu(void); // "Einstellungen" Dialog
		void slotDock(void);		// Andocken
		void slotUndock(void);
	protected:
	/* Diverse Initfunktionen */
		void initWidgets(void);
		KAccel * initKeyAccel(void);
		void initPopupMenus(KAccel *);
		void initSize(void);
		void initConnect(void);
		double initList(void);
		void initTooltips(void);

	/* Und nun noch Variablen */
		unsigned int magic;	   // Ein Magic Value
		enum { MAGIC=0xccaacc22 }; // Ein Magic Wert 
		QPopupMenu * pHelpMenu;    // Das hilfe Menu
		QPopupMenu * pFileMenu;    // Das FilePopupMenu in der obersten Zeile
		QPopupMenu * pExtraMenu;   // Das "Extras Menu
		QWidget    * pMainWidget;  // Der "Hintergrund" des Programms 
		FrequenzBox   * pFrequenzBox; // Hier wird die Frequenz angezeigt
		QPushButton * pEditButton; // Der "Neue Station" Knopf
		QPushButton * pRemoveButton; // Der "Station lschen" Knopf
		class DockWidget  * pDocking;	     // Docking!
		KDNDDropZone * pDropZone;  // Die Drop Zone (main widget)
		QList<RadioProgramm> * pListe; // Liste der Programme
	// Ein paar Elemente bei denen ich noch ein bichen unglcklich bin
	// (Programmtechnisch unschn das sie hier sind ... 
		QString	     LastStation;    // Das war die Station beim 
					     // letzten Mal.
		QString	     Device;	     // Normal /dev/radio
};

#endif /* KRADIO_H */
