// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>

class ISOOptions : public QWidget
 {
  Q_OBJECT;
  
 
  public:
    ISOOptions( QWidget *parent=0, const char *name=0,class ISOImage *track=0);
    ~ISOOptions(void);
    void hide(void);
 
  signals:
    void closed(void);
    void needUpdate(void);
    void okPressed(void);      // only in config mode
    void cancelPressed(void);  // only in config mode
    void applyPressed(void);   // only in config mode

  public slots:
    void updateWindow(void);

  protected slots:
    void doUnix(void);
    void doUnixWin(void);
    void doWin(void);
    void doMSDos(void);

    void configOK(void);
    void configApply(void);
    void configCancel(void);

  private:
    class ISOImage *iso;

    class QCheckBox *tdotButton;
    class QCheckBox *noDeepButton;
    class QCheckBox *longNameButton;
    class QCheckBox *leadDotButton;
    class QCheckBox *omitVerButton;
    class QCheckBox *rockButton;
    class QCheckBox *anoRockButton;
    class QCheckBox *transTabButton;
    class QCheckBox *jolietButton;
    class QCheckBox *allButton;

    class QRadioButton *unixButton;
    class QRadioButton *unixWinButton;
    class QRadioButton *winButton;
    class QRadioButton *msDOSButton;

    class QLabel *appIDLabel;
    class QLabel *sysIDLabel;
    class QLabel *volIDLabel;
    class QLabel *preIDLabel;
    class QLabel *pubIDLabel;

    class QLineEdit *appIDEdit;
    class QLineEdit *sysIDEdit;
    class QLineEdit *volIDEdit;
    class QLineEdit *preIDEdit;
    class QLineEdit *pubIDEdit;

    bool configMode;
 };


