/***************************************************************************
              QueryDlgBase.h  -  base class for query dialogs
                         -------------------
    begin                : Thu Nov 25 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef Query_Dlg_Base_H
#define Query_Dlg_Base_H

#include <qstring.h>
#include <qdialog.h>
#include <time.h>
#include <stdlib.h>

class kvoctrainExpr;
class kvoctrainDoc;
class kvoctrainApp;

class QLineEdit;
class QLabel;
class QRadioButton;

class QueryDlgBase : public QDialog
{
  Q_OBJECT
public:

   enum Result { Unknown, Known, Timeout, StopIt };

   QueryDlgBase ( QWidget * parent=0, const char * name=0, bool modal = true)
        : QDialog (parent, name, true, 0)
     {
       kv_app = 0;
       kv_doc = 0;
       kv_exp = 0;
     }

   bool smartCompare (const QString&, const QString&, int level) const;

   bool verifyField(QLineEdit *field, const QString &really);
   void resetField (QLineEdit *field);

   void verifyButton(QRadioButton *radio, bool is_ok);
   void resetButton (QRadioButton *radio);

   int getRandom(int range)
     {
//        srand((unsigned int)time((time_t *)NULL));
        return (int) (range * ((1.0*rand())/RAND_MAX));
     }

   virtual ~QueryDlgBase() {}

public slots:
    virtual void initFocus() const;

signals:
        void sigOptions();
        void sigEditEntry(int row, int col);

protected:
   int            q_row,
                  q_ocol,
                  q_tcol;
   kvoctrainApp  *kv_app;
   kvoctrainDoc  *kv_doc;
   kvoctrainExpr *kv_exp;
   QString        translation;
   int            showCounter;
   QTimer        *qtimer;
};


#endif // Query_Dlg_Base_H
