/***************************************************************************
              QueryDlgBase.cpp  -  base class for query dialogs
                         -------------------
    begin                : Wed Feb 16 20:50:53 MET 2000
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "QueryDlgBase.h"

#include <qlineedit.h>
#include <qradiobutton.h>
#include <qfont.h>

#include <iostream.h>


void QueryDlgBase::initFocus() const
{
  //
}


bool QueryDlgBase::smartCompare (const QString& s1, const QString &s2,
                                 int level) const
{
  return s1.stripWhiteSpace() == s2.stripWhiteSpace();
}


bool QueryDlgBase::verifyField(QLineEdit *field, const QString &really)
{
  if (!field->isEnabled() )
    return true;

  //FIXME: modify only text color
  QColorGroup u_normal( QColor( QRgb(0) ),
                      QColor( QRgb(12632256) ),
                      QColor( QRgb(16777215) ),
                      QColor( QRgb(6316128) ),
                      QColor( QRgb(10526880) ),
                      QColor( QRgb(255) ),
                      QColor( QRgb(16777215) ) );

  //FIXME: modify only text color
  QColorGroup k_normal( QColor( QRgb(0) ),
                        QColor( QRgb(12632256) ),
                        QColor( QRgb(16777215) ),
                        QColor( QRgb(6316128) ),
                        QColor( QRgb(10526880) ),
                        QColor( QRgb(0x008000) ),
                        QColor( QRgb(16777215) ) );

  QPalette known_pal( field->palette());
  QPalette unknown_pal( field->palette());

  QFont ft = field->font();
  if (ft.weight() != QFont::Bold) {
    ft.setWeight(QFont::Bold);
    field->setFont(ft);
  }

  bool ret = false;
  if (smartCompare(really, field->text(), 0) ) {
    ret = true;
    if (known_pal.normal() != k_normal || known_pal.active() != k_normal) {
      // replace text colors
      known_pal.setNormal(k_normal);
      known_pal.setActive(k_normal);
      field->setPalette( known_pal );
    }
  }
  else
    if (unknown_pal.normal() != u_normal || unknown_pal.active() != u_normal) {
      // replace text colors
      unknown_pal.setNormal(u_normal);
      unknown_pal.setActive(u_normal);
      field->setPalette( unknown_pal );
    }
  return ret;
}


void QueryDlgBase::resetField(QLineEdit *field)
{
  if (!field->isEnabled() )
    return;

  //FIXME: modify only text color
  QColorGroup normal( QColor( QRgb(0) ),
                      QColor( QRgb(12632256) ),
                      QColor( QRgb(16777215) ),
                      QColor( QRgb(6316128) ),
                      QColor( QRgb(10526880) ),
                      QColor( QRgb(0) ),
                      QColor( QRgb(16777215) ) );

  QPalette pal( field->palette());
  // replace text colors

  if (pal.normal() != normal || pal.active() != normal) {
    pal.setNormal(normal);
    pal.setActive(normal);
    field->setPalette( pal );
  }

  QFont ft = field->font();
  if (ft.weight() != QFont::Normal) {
    ft.setWeight(QFont::Normal);
    field->setFont(ft);
  }
}

void QueryDlgBase::verifyButton(QRadioButton *radio, bool is_ok)
{
  if (!radio->isEnabled() )
    return;

  //FIXME: modify only text color
  QColorGroup u_normal( QColor( QRgb(0) ),
                      QColor( QRgb(12632256) ),
                      QColor( QRgb(16777215) ),
                      QColor( QRgb(6316128) ),
                      QColor( QRgb(10526880) ),
                      QColor( QRgb(255) ),
                      QColor( QRgb(16777215) ) );

  //FIXME: modify only text color
  QColorGroup k_normal( QColor( QRgb(0) ),
                        QColor( QRgb(12632256) ),
                        QColor( QRgb(16777215) ),
                        QColor( QRgb(6316128) ),
                        QColor( QRgb(10526880) ),
                        QColor( QRgb(0x008000) ),
                        QColor( QRgb(16777215) ) );

  QPalette known_pal( radio->palette());
  QPalette unknown_pal( radio->palette());

  // replace text colors

  QFont ft = radio->font();
  if (ft.weight() != QFont::Bold) {
    ft.setWeight(QFont::Bold);
    radio->setFont(ft);
  }

  if (is_ok) {
    if (known_pal.normal() != k_normal || known_pal.active() != k_normal) {
      known_pal.setNormal(k_normal);
      known_pal.setActive(k_normal);
      radio->setPalette( known_pal );
    }
  }
  else {
    if (unknown_pal.normal() != u_normal || unknown_pal.active() != u_normal) {
      unknown_pal.setNormal(u_normal);
      unknown_pal.setActive(u_normal);
      radio->setPalette( unknown_pal );
    }
  }
}


void QueryDlgBase::resetButton(QRadioButton *radio)
{
  if (!radio->isEnabled() )
    return;

  //FIXME: modify only text color
  QColorGroup normal( QColor( QRgb(0) ),
                      QColor( QRgb(12632256) ),
                      QColor( QRgb(16777215) ),
                      QColor( QRgb(6316128) ),
                      QColor( QRgb(10526880) ),
                      QColor( QRgb(0) ),
                      QColor( QRgb(16777215) ) );

  QPalette pal(radio->palette());
  // replace text colors, avoid flickering
  if (pal.normal() != normal || pal.active() != normal) {
    pal.setNormal(normal);
    pal.setActive(normal);
    radio->setPalette( pal );
  }

  QFont ft = radio->font();
  if (ft.weight() != QFont::Normal) {
    ft.setWeight(QFont::Normal);
    radio->setFont(ft);
  }
}
