/***************************************************************************
                  ArtQueryDlg.h  -  query dialog for articles
                             -------------------
    begin                : Fri Dec 3 18:28:18 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "ArtQueryDlg.h"

#define Inherited ArtQueryDlgData

#include "QueryDlg.h"
#include "resource.h"
#include "kvoctraindoc.h"
#include "QueryManager.h"
#include "ProgressChart.h"
#include "kvoctrain.h"
#include "eadebug.h"

#include <kapp.h> 

#include <qtimer.h>
#include <qkeycode.h>

#include "compat_2x.h"

ArtQueryDlg::ArtQueryDlg
(
        QString type,
        int entry,
        int col,
        int query_cycle,
        int query_num,
        int query_startnum,
        kvoctrainExpr *exp,
        kvoctrainApp  *kv_app,
        kvoctrainDoc  *doc,
        const Article &articles,
        int   mtime,
        QWidget *parent,
        char    *name
)
	:
	Inherited( parent, name )
{
        qtimer = 0;
        setCaption (QString(KVOCTRAIN_TITLE) + ": " + i18n("Article training"));
        setQuery (type, entry, col,
                  query_cycle, query_num, query_startnum,
                  exp, kv_app, doc, articles, mtime);
        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


void ArtQueryDlg::setQuery(QString type,
                           int entry,
                           int col,
                           int q_cycle,
                           int q_num,
                           int q_start,
                           kvoctrainExpr *exp,
                           kvoctrainApp  *app,
                           kvoctrainDoc  *doc,
                           const Article &art,
                           int mtime)
{
   kv_exp = exp;
   kv_app = app;
   kv_doc = doc;
   q_row = entry;
   q_ocol = col;
   showCounter = 0;
   show_all->setDefault(true);
   articles = art;

   QString s;
   if (col == 0)
     s = exp->getOriginal().stripWhiteSpace();
   else
     s = exp->getTranslation(q_ocol).stripWhiteSpace();

   QString def, indef;
   bool removed = false;

   articles.female(def, indef);
   rb_fem->setText (i18n("&female:\t")+def+" / "+indef);
   rb_fem->setEnabled (!QString(def+indef).isEmpty() );
   if (!removed && s.find(def+" ") == 0) {
     s.remove (0, def.length()+1);
     removed = true;
   }
   if (!removed && s.find(indef+" ") == 0) {
     s.remove (0, indef.length()+1);
     removed = true;
   }

   articles.male(def, indef);
   male->setText (i18n("&male:\t")+def+" / "+indef);
   male->setEnabled (!QString(def+indef).isEmpty() );
   if (!removed && s.find(def+" ") == 0) {
     s.remove (0, def.length()+1);
     removed = true;
   }
   if (!removed && s.find(indef+" ") == 0) {
     s.remove (0, indef.length()+1);
     removed = true;
   }

   articles.natural(def, indef);
   natural->setText (i18n("&natural:\t")+def+" / "+indef);
   natural->setEnabled (!QString(def+indef).isEmpty() );
   if (!removed && s.find(def+" ") == 0) {
     s.remove (0, def.length()+1);
     removed = true;
   }
   if (!removed && s.find(indef+" ") == 0) {
     s.remove (0, indef.length()+1);
     removed = true;
   }

   orgField->setText(s);
   s.setNum (q_cycle);
   progCount->setText (s);
   progChart->setData (q_start, q_num);
   progChart->repaint();

   if (mtime >= 1000) { // more than 1000 milli-seconds
     if (qtimer == 0)
       qtimer = new QTimer( this );
     connect( qtimer, SIGNAL(timeout()), this, SLOT(timeoutReached()) );
     qtimer->start(mtime, TRUE);
   }
}


ArtQueryDlg::~ArtQueryDlg()
{
}


void ArtQueryDlg::initFocus() const
{
  rb_fem->setFocus();
}


void ArtQueryDlg::optionsClicked()
{
   emit sigOptions();
}


void ArtQueryDlg::showAllClicked()
{
  resetButton(rb_fem);
  resetButton(male);
  resetButton(rb_fem);

  if (kv_exp->getType (q_ocol) == QM_NOUN  QM_TYPE_DIV  QM_NOUN_F)
    rb_fem->setChecked (true);
  else if (kv_exp->getType (q_ocol) == QM_NOUN  QM_TYPE_DIV  QM_NOUN_M)
    male->setChecked (true);
  else if (kv_exp->getType (q_ocol) == QM_NOUN  QM_TYPE_DIV  QM_NOUN_S)
    natural->setChecked (true);
  else
    KDEBUG (KDEBUG_ERROR, 0, "[ArtQueryDlg::showAllClicked]: unknown type");
  dont_know->setDefault(true);
}


void ArtQueryDlg::showMoreClicked()
{
}


void ArtQueryDlg::verifyClicked()
{
  bool known = false;
  if (kv_exp->getType (q_ocol) == QM_NOUN  QM_TYPE_DIV  QM_NOUN_F)
    known = rb_fem->isChecked ();
  else if (kv_exp->getType (q_ocol) == QM_NOUN  QM_TYPE_DIV  QM_NOUN_M)
    known = male->isChecked ();
  else if (kv_exp->getType (q_ocol) == QM_NOUN  QM_TYPE_DIV  QM_NOUN_S)
    known = natural->isChecked ();

  if (rb_fem->isChecked() ) {
    verifyButton(rb_fem, known);
    resetButton(male);
    resetButton(natural);
  }
  else if (male->isChecked() ) {
    verifyButton(male, known);
    resetButton(rb_fem);
    resetButton(natural);
  }
  else if (natural->isChecked() ) {
    verifyButton(natural, known);
    resetButton(male);
    resetButton(rb_fem);
  }

  if (known)
    know_it->setDefault(true);
  else
    dont_know->setDefault(true);
}


void ArtQueryDlg::knowItClicked()
{
   done (Known);
}


void ArtQueryDlg::timeoutReached()
{
   done (Timeout);
}


void ArtQueryDlg::dontKnowClicked()
{
   done (Unknown);
}


void ArtQueryDlg::stopItClicked()
{
   done (StopIt);
}


void ArtQueryDlg::editClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_ocol);
}


void ArtQueryDlg::keyPressEvent( QKeyEvent *e )
{
  switch( e->key() )
  {
    case Key_Escape:
      dontKnowClicked();
    break;
      
    case Key_Return:
    case Key_Enter:
      if (dont_know->isDefault() )
        dontKnowClicked();
      else if (know_it->isDefault() )
        knowItClicked();
      else if (show_all->isDefault() )
        showAllClicked();
    break;
      
    default:
      e->ignore();
    break;
  }
}


void ArtQueryDlg::returnPressed()
{
}


void ArtQueryDlg::slotFemClicked()
{
  resetButton(rb_fem);
  resetButton(male);
  resetButton(rb_fem);
}


void ArtQueryDlg::slotMaleClicked()
{
  resetButton(male);
  resetButton(natural);
  resetButton(rb_fem);
}


void ArtQueryDlg::slotNaturalClicked()
{
  resetButton(natural);
  resetButton(male);
  resetButton(rb_fem);
}
