/***************************************************************************
                AdjQueryDlg.h  -  query dialog for adjectives
                             -------------------
    begin                : Sat Dec 4 15:09:18 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#include "AdjQueryDlg.h"

#include "QueryDlg.h"
#include "resource.h"
#include "kvoctraindoc.h"
#include "QueryManager.h"
#include "ProgressChart.h"
#include "kvoctrain.h"
#include "eadebug.h"

#include <kapp.h> 

#include <qtimer.h>
#include <qkeycode.h>

#include "compat_2x.h"

#define Inherited AdjQueryDlgData

AdjQueryDlg::AdjQueryDlg
(
        QString type,
        int entry,
        int col,
        int query_cycle,
        int query_num,
        int query_startnum,
        kvoctrainExpr *exp,
        kvoctrainApp  *kv_app,
        kvoctrainDoc  *doc,
        const Comparison &_comp,
        int   mtime,
        QWidget* parent,
        const char* name
)
	:
	Inherited( parent, name )
{
        qtimer = 0;
	setCaption (QString(KVOCTRAIN_TITLE) + ": " + i18n("Comparison training"));

        lev1Label->setBuddy(lev1Field);
        lev2Label->setBuddy(lev2Field);
        lev3Label->setBuddy(lev3Field);

        setQuery (type, entry, col,
                  query_cycle, query_num, query_startnum,
                  exp, kv_app, doc, _comp, mtime);
        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


void AdjQueryDlg::setQuery(QString type,
                           int entry,
                           int col,
                           int q_cycle,
                           int q_num,
                           int q_start,
                           kvoctrainExpr *exp,
                           kvoctrainApp  *app,
                           kvoctrainDoc  *doc,
                           const Comparison &_comp,
                           int mtime)
{
   kv_app = app;
   kv_doc = doc;
   kv_exp = exp;
   q_row = entry;
   q_ocol = col;
   showCounter = 0;
   comp = _comp;
   show_all->setDefault(true);
   QString s;
   s.setNum (q_cycle);
   progCount->setText (s);
   progChart->setData (q_start, q_num);
   progChart->repaint();

   int sel = getRandom(3);
   switch (sel) {
     case 0: lev1Field->setText (comp.l1() );
     break;
     case 1: lev2Field->setText (comp.l2() );
     break;
     case 2: lev3Field->setText (comp.l3() );
     break;
   }

   lev1Field->setEnabled(!comp.l1().isEmpty() );
   lev2Field->setEnabled(!comp.l2().isEmpty() );
   lev3Field->setEnabled(!comp.l3().isEmpty() );

   if (mtime >= 1000) { // more than 1000 milli-seconds
     if (qtimer == 0)
       qtimer = new QTimer( this );
     connect( qtimer, SIGNAL(timeout()), this, SLOT(timeoutReached()) );
     qtimer->start(mtime, TRUE);
   }
   resetAllFields();
}


void AdjQueryDlg::initFocus() const
{
  lev1Field->setFocus();
}


AdjQueryDlg::~AdjQueryDlg()
{
}


void AdjQueryDlg::optionsClicked()
{
   emit sigOptions();
}


void AdjQueryDlg::showAllClicked()
{
  resetAllFields();
  lev1Field->setText (comp.l1() );
  lev2Field->setText (comp.l2() );
  lev3Field->setText (comp.l3() );
  dont_know->setDefault(true);
}


void AdjQueryDlg::verifyClicked()
{
  bool all_known = true;

  if (!verifyField (lev1Field, comp.l1()) )
    all_known = false;

  if (!verifyField (lev2Field, comp.l2()) )
    all_known = false;

  if (!verifyField (lev3Field, comp.l3()) )
    all_known = false;

  if (all_known)
    know_it->setDefault(true);
  else
    dont_know->setDefault(true);
}


void AdjQueryDlg::resetAllFields()
{
  resetField(lev1Field);
  resetField(lev2Field);
  resetField(lev3Field);
}


void AdjQueryDlg::knowItClicked()
{
   done (Known);
}


void AdjQueryDlg::timeoutReached()
{
   done (Timeout);
}


void AdjQueryDlg::dontKnowClicked()
{
   done (Unknown);
}


void AdjQueryDlg::stopItClicked()
{
   done (StopIt);
}


void AdjQueryDlg::editClicked()
{

   if (qtimer != 0)
     qtimer->stop();

   emit sigEditEntry (q_row, KV_COL_ORG+q_ocol);
}


void AdjQueryDlg::keyPressEvent( QKeyEvent *e )
{
  switch( e->key() )
  {
    case Key_Escape:
      dontKnowClicked();
    break;
      
    case Key_Return:
    case Key_Enter:
      if (dont_know->isDefault() )
        dontKnowClicked();
      else if (know_it->isDefault() )
        knowItClicked();
      else if (show_all->isDefault() )
        showAllClicked();
    break;
      
    default:
      e->ignore();
    break;
  }
}


void AdjQueryDlg::returnPressed()
{
}


void AdjQueryDlg::lev1Changed(EA_QTSTR)
{
  resetField (lev1Field);
}


void AdjQueryDlg::lev2Changed(EA_QTSTR)
{
  resetField (lev2Field);
}


void AdjQueryDlg::lev3Changed(EA_QTSTR)
{
  resetField (lev3Field);
}
